/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CompoundIterator<E>
implements Iterator<E> {
    private Iterator<? extends E> first;
    private Iterator<? extends E> second;

    public CompoundIterator(Iterator<? extends E> first, Iterator<? extends E> second) {
        this.first = Objects.requireNonNull(first);
        this.second = Objects.requireNonNull(second);
    }

    @Override
    public boolean hasNext() {
        return this.first.hasNext() || this.first != this.second && (this.first = this.second).hasNext();
    }

    @Override
    public E next() {
        try {
            return this.first.next();
        }
        catch (NoSuchElementException ex) {
            if (this.first == this.second) {
                throw ex;
            }
            this.first = this.second;
            return this.first.next();
        }
    }

    @Override
    public void remove() {
        this.first.remove();
    }
}

