// recorder-worklet.js
class RecorderProcessor extends AudioWorkletProcessor {
  constructor() {
    super();
    this.buffer = [];
  }

  process(inputs, outputs, parameters) {
    const input = inputs[0];
    if (input.length > 0) {
      const channelData = input[0]; // mono input
      this.port.postMessage(channelData.slice()); // Copy to avoid transfer issues
    }
    return true; // Keep processor alive
  }
}

registerProcessor('recorder-processor', RecorderProcessor);
