// https://minify-js.com/
const EXSID_USBVID=1027,HARDSID_USBVID=25985,SIDBLASTER_USBVID=1027,SIDBLASTER_USBDESC="SIDBlaster/USB",USBSID_USBVID=51966,USBSID_USBPID=16401,USBSID_USBDESC="USBSID-Pico",HardwareFunctions={init:void 0,write:void 0,delay:void 0,pause:void 0,continue:void 0,next:void 0,reset:void 0,quit:void 0,mapping:void 0},Chip={NEXT:-1,RESET:-2,QUIT:-3,PAUSE:-4,CONTINUE:-5};function Queue(){var e,i;return Object.freeze({enqueue(a){const n={value:a,next:void 0};i=e?i.next=n:e=n},enqueueAll(a){a.head&&(e?i.next=a.head:e=a.head,i=a.tail)},dequeue(){if(e){var i=e.value;return e=e.next,i}},dequeueAll(){var a={head:e,tail:i};return i=e=void 0,a},peek:()=>e?.value,clear(){i=e=void 0},isNotEmpty:()=>e})}var mapping,lastChipModel,usbPlayTimer,sidWriteQueue=new Queue,deviceCount=0,chipCount=0,engine="EMULATION";async function init_hardware(){var e=void 0;let i=await navigator.usb.getDevices();if(0===i.length)try{e=await navigator.usb.requestDevice({filters:[{vendorId:HARDSID_USBVID},{vendorId:EXSID_USBVID},{vendorId:USBSID_USBVID,productId:16401}]})}catch(e){console.log(e)}else for(let a=0;a<i.length;a++){let n=i[a];if(n.vendorId===HARDSID_USBVID||n.vendorId===EXSID_USBVID||n.vendorId===USBSID_USBVID){e=n;break}}e?(await e.open(),console.log("Opened:",e.opened),console.log(`Product name: ${e.productName}, serial number ${e.serialNumber}`),await init_hardware_by_device(e)):console.log("No devices found!")}async function init_hardware_by_device(e){await init_hardware_by_device_and_vendor(e,e.vendorId,e.productName)}async function init_hardware_by_vendor(e,i){await init_hardware_by_device_and_vendor(void 0,e,i)}async function init_hardware_by_device_and_vendor(e,i,a){i==SIDBLASTER_USBVID&&a.startsWith(SIDBLASTER_USBDESC)?(HardwareFunctions.init=init_sidblaster,HardwareFunctions.reset=reset_sidblaster,HardwareFunctions.write=write_sidblaster,HardwareFunctions.next=next_sidblaster,HardwareFunctions.quit=quit_sidblaster,HardwareFunctions.mapping="sidblaster-mapping/",HardwareFunctions.mapped=mapped_sidblaster,engine="SIDBLASTER"):i==EXSID_USBVID?(HardwareFunctions.init=init_exsid,HardwareFunctions.reset=reset_exsid,HardwareFunctions.write=write_exsid,HardwareFunctions.delay=delay_exsid,HardwareFunctions.pause=pause_exsid,HardwareFunctions.continue=continue_exsid,HardwareFunctions.next=next_exsid,HardwareFunctions.quit=quit_exsid,HardwareFunctions.mapping="exsid-mapping/",HardwareFunctions.mapped=mapped_exsid,engine="EXSID"):i==HARDSID_USBVID?(HardwareFunctions.init=init_hardsid,HardwareFunctions.reset=reset_hardsid,HardwareFunctions.write=write_hardsid,HardwareFunctions.delay=delay_hardsid,HardwareFunctions.pause=pause_hardsid,HardwareFunctions.continue=continue_hardsid,HardwareFunctions.next=next_hardsid,HardwareFunctions.quit=quit_hardsid,HardwareFunctions.mapping="hardsid-mapping/",HardwareFunctions.mapped=mapped_hardsid,engine="HARDSID"):i==USBSID_USBVID?(HardwareFunctions.init=init_usbsid,HardwareFunctions.reset=reset_usbsid,HardwareFunctions.write=write_usbsid,HardwareFunctions.delay=delay_usbsid,HardwareFunctions.pause=pause_usbsid,HardwareFunctions.continue=continue_usbsid,HardwareFunctions.next=next_usbsid,HardwareFunctions.quit=quit_usbsid,HardwareFunctions.mapping="usbsid-mapping/",HardwareFunctions.mapped=mapped_usbsid,engine="USBSID"):engine="EMULATION",deviceCount=0,chipCount=0,await HardwareFunctions.init(e),void 0!==usbPlayTimer&&clearTimeout(usbPlayTimer),reset_UsbQueue()}function set_UsbMapping(e){mapping=e,console.log(mapping),HardwareFunctions.mapped()}var p=0;function reset_UsbQueue(){lastChipModel=void 0,sidWriteQueue.clear(),sidWriteQueue.enqueue({chip:Chip.RESET}),p=0}function pause_UsbQueue(){lastChipModel=void 0,sidWriteQueue.clear(),sidWriteQueue.enqueue({chip:0==p?Chip.PAUSE:Chip.CONTINUE}),p=0==p?1:0}async function doPlay(){for(;sidWriteQueue.isNotEmpty();){if(write=sidWriteQueue.dequeue(),write.chip==Chip.QUIT)return await HardwareFunctions.quit(),void(ajaxRequest&&ajaxRequest.cancel());if(write.chip==Chip.RESET)return await HardwareFunctions.reset(),void(usbPlayTimer=setTimeout((()=>this.doPlay()),250));if(write.chip==Chip.PAUSE)HardwareFunctions.pause();else if(write.chip==Chip.CONTINUE)HardwareFunctions.continue();else if(write.chip==Chip.NEXT){if(0!=await HardwareFunctions.next())return sidWriteQueue.enqueue({chip:Chip.NEXT}),void(usbPlayTimer=setTimeout((()=>this.doPlay()),250));Vue.nextTick((()=>app.setNextPlaylistEntry()))}else-1==write.reg?await HardwareFunctions.delay(write):await HardwareFunctions.write(write)}usbPlayTimer=setTimeout((()=>this.doPlay()))}async function init_exsid(e){return deviceCount=1,-1!=await exSID_init(e)?0:-1}async function reset_exsid(){exSID_reset(0)}async function write_exsid(e){if(e.reg=31&e.reg,e.reg<=24){const i=mapping[e.chip];lastChipModel!==i&&(await exSID_chipselect("MOS8580"===i?ChipSelect.XS_CS_CHIP1:ChipSelect.XS_CS_CHIP0),lastChipModel=i),await exSID_clkdwrite(e.cycles,e.reg,e.value)}}async function delay_exsid(e){await exSID_delay(e.cycles)}async function pause_exsid(){xSoutb(XSP_AD_IOCTAM,1)}async function continue_exsid(){xSoutb(XSP_AD_IOCTAU,1)}async function quit_exsid(){await exSID_exit()}async function mapped_exsid(){const e=mapping[0],i="true"===mapping[-1],a="true"===mapping[-2],n=mapping[-3];a&&(lastChipModel=e,exSID_chipselect(ChipSelect.XS_CS_BOTH)),exSID_audio_op(AudioOp.XS_AU_MUTE),exSID_clockselect("PAL"===n?ClockSelect.XS_CL_PAL:ClockSelect.XS_CL_NTSC),i?exSID_audio_op("MOS6581"===e?AudioOp.XS_AU_6581_8580:AudioOp.XS_AU_8580_6581):exSID_audio_op("MOS6581"===e?AudioOp.XS_AU_6581_6581:AudioOp.XS_AU_8580_8580),exSID_audio_op(AudioOp.XS_AU_UNMUTE)}async function next_exsid(){return exSID_is_playing()?-1:(exSID_reset(0),0)}async function init_hardsid(e){return await hardsid_usb_init(e,!0,SysMode.SIDPLAY),deviceCount=hardsid_usb_getdevcount(),console.log("Device count: "+deviceCount),deviceCount>0?(chipCount=hardsid_usb_getsidcount(0),console.log("Chip count: "+chipCount),0):-1}async function reset_hardsid(){await hardsid_usb_abortplay(0);for(let e=0;e<chipCount;e++)await hardsid_usb_reset(0,e,0)}async function write_hardsid(e){for(await delay_hardsid(e);await hardsid_usb_write(0,e.chip<<5|e.reg,e.value)==WState.BUSY;);}async function quit_hardsid(){}async function mapped_hardsid(){}async function delay_hardsid(e){let i=e.cycles;for(;i>65535;){for(;await hardsid_usb_delay(0,65535)==WState.BUSY;);i-=65536}if(i>0)for(;await hardsid_usb_delay(0,i)==WState.BUSY;);}async function pause_hardsid(){}async function continue_hardsid(){}async function next_hardsid(){for(await hardsid_usb_sync(0);await hardsid_usb_flush(0)==WState.BUSY;);return 0}async function init_sidblaster(){return deviceCount=1,-1!=await sidblaster_init()?0:-1}async function reset_sidblaster(){sidblaster_reset(0)}async function write_sidblaster(e){sidblaster_write(e.cycles,e.reg,e.value)}async function quit_sidblaster(){await sidblaster_exit()}async function mapped_sidblaster(){}async function next_sidblaster(){return sidblaster_is_playing()?-1:(sidblaster_reset(),0)}async function init_usbsid(e){return deviceCount=1,-1!=await usbsid_init(e,!1)?(await reset_usbsid(),0):-1}async function delay_usbsid(e){}async function pause_usbsid(){await usbsid_pause()}async function continue_usbsid(){await usbsid_continue()}async function reset_usbsid(){await usbsid_reset()}async function next_usbsid(){return await usbsid_is_playing()?-1:(await usbsid_reset(),0)}async function write_usbsid(e){await usbsid_writecycled(e.cycles,e.chip,e.reg,e.value)}async function quit_usbsid(){await usbsid_close()}async function mapped_usbsid(){mapping[0],mapping[-1],mapping[-2],mapping[-3];const e=mapping[-4];console.log(e)}