/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.tardriver;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.cio.AbstractOutputSocket;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.IoBuffer;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.OutputBusyException;
import net.java.truecommons.cio.OutputService;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.io.DisconnectingOutputStream;
import net.java.truecommons.io.Sink;
import net.java.truecommons.io.Streams;
import net.java.truecommons.shed.HashMaps;
import net.java.truevfs.comp.tardriver.TarDriver;
import net.java.truevfs.comp.tardriver.TarDriverEntry;
import net.java.truevfs.kernel.spec.FsModel;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

@NotThreadSafe
public final class TarOutputService
implements OutputService<TarDriverEntry> {
    private final Map<String, TarDriverEntry> entries = new LinkedHashMap<String, TarDriverEntry>(HashMaps.initialCapacity((int)47));
    private final OutputStream out;
    private final TarArchiveOutputStream taos;
    private final TarDriver driver;
    private boolean busy;

    @CreatesObligation
    public TarOutputService(FsModel model, Sink sink, TarDriver driver) throws IOException {
        Objects.requireNonNull(model);
        this.driver = Objects.requireNonNull(driver);
        this.out = sink.stream();
        try {
            TarArchiveOutputStream taos = new TarArchiveOutputStream(this.out, 10240, driver.getEncoding());
            taos.setAddPaxHeadersForNonAsciiNames(driver.getAddPaxHeaderForNonAsciiNames());
            taos.setLongFileMode(driver.getLongFileMode());
            taos.setBigNumberMode(driver.getBigNumberMode());
            this.taos = taos;
        }
        catch (Throwable ex) {
            try {
                this.out.close();
            }
            catch (Throwable ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    private IoBufferPool getPool() {
        return this.driver.getPool();
    }

    public int size() {
        return this.entries.size();
    }

    public Iterator<TarDriverEntry> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    @CheckForNull
    public TarDriverEntry entry(String name) {
        return this.entries.get(name);
    }

    public OutputSocket<TarDriverEntry> output(final TarDriverEntry local) {
        Objects.requireNonNull(local);
        final class Output
        extends AbstractOutputSocket<TarDriverEntry> {
            Output() {
            }

            public TarDriverEntry target() {
                return local;
            }

            public OutputStream stream(InputSocket<? extends Entry> peer) throws IOException {
                if (TarOutputService.this.isBusy()) {
                    throw new OutputBusyException(local.getName());
                }
                if (local.isDirectory()) {
                    TarOutputService.this.updateProperties(local, DirectoryTemplate.INSTANCE);
                    return new EntryOutputStream(local);
                }
                TarOutputService.this.updateProperties(local, Output.target(peer));
                return -1L == local.getSize() ? new BufferedEntryOutputStream(local) : new EntryOutputStream(local);
            }
        }
        return new Output();
    }

    private void updateProperties(TarDriverEntry local, @CheckForNull Entry peer) {
        if (-1L == local.getModTime().getTime()) {
            local.setModTime(System.currentTimeMillis());
        }
        if (null != peer && -1L == local.getSize()) {
            local.setSize(peer.getSize(Entry.Size.DATA));
        }
    }

    private boolean isBusy() {
        return this.busy;
    }

    public void close() throws IOException {
        this.taos.close();
        this.out.close();
    }

    @CleanupObligation
    private final class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final IoBuffer buffer;
        final TarDriverEntry local;
        boolean closed;

        @CreatesObligation
        BufferedEntryOutputStream(TarDriverEntry local) throws IOException {
            this.local = local;
            IoBuffer buffer = this.buffer = (IoBuffer)TarOutputService.this.getPool().allocate();
            try {
                this.out = buffer.output().stream(null);
            }
            catch (Throwable ex) {
                try {
                    buffer.release();
                }
                catch (Throwable ex2) {
                    ex.addSuppressed(ex2);
                }
                throw ex;
            }
            TarOutputService.this.entries.put(local.getName(), local);
            TarOutputService.this.busy = true;
        }

        @DischargesObligation
        public void close() throws IOException {
            assert (null != this.out);
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputService.this.busy = false;
            this.out.close();
            TarOutputService.this.updateProperties(this.local, (Entry)this.buffer);
            this.storeBuffer();
        }

        void storeBuffer() throws IOException {
            IoBuffer buffer = this.buffer;
            Throwable t1 = null;
            try (InputStream in = buffer.input().stream(null);){
                TarArchiveOutputStream taos = TarOutputService.this.taos;
                taos.putArchiveEntry((ArchiveEntry)this.local);
                Streams.cat((InputStream)in, (OutputStream)taos);
                taos.closeArchiveEntry();
            }
            catch (Throwable t2) {
                t1 = t2;
                throw t2;
            }
            finally {
                try {
                    buffer.release();
                }
                catch (Throwable t2) {
                    if (null == t1) {
                        throw t2;
                    }
                    t1.addSuppressed(t2);
                }
            }
        }
    }

    @CleanupObligation
    private final class EntryOutputStream
    extends DisconnectingOutputStream {
        boolean closed;

        @CreatesObligation
        EntryOutputStream(TarDriverEntry local) throws IOException {
            super((OutputStream)TarOutputService.this.taos);
            TarOutputService.this.taos.putArchiveEntry((ArchiveEntry)local);
            TarOutputService.this.entries.put(local.getName(), local);
            TarOutputService.this.busy = true;
        }

        public boolean isOpen() {
            return !this.closed;
        }

        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputService.this.busy = false;
            TarOutputService.this.taos.closeArchiveEntry();
        }
    }

    private static final class DirectoryTemplate
    implements Entry {
        static final DirectoryTemplate INSTANCE = new DirectoryTemplate();

        private DirectoryTemplate() {
        }

        public String getName() {
            return "/";
        }

        public long getSize(Entry.Size type) {
            return 0L;
        }

        public long getTime(Entry.Access type) {
            return -1L;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
            return null;
        }
    }
}

