/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.utils;

public class ByteUtils {
    private static final char[] HEXARRAY = "0123456789ABCDEF".toCharArray();

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder r = new StringBuilder(bytes.length * 3);
        for (byte b : bytes) {
            r.append(HEXARRAY[b >> 4 & 0xF]);
            r.append(HEXARRAY[b & 0xF]);
            r.append(' ');
        }
        return r.substring(0, r.length() - 1);
    }

    public static byte getLowByte(int value) {
        byte lowByte = ByteUtils.getLowByte(value, 255);
        return lowByte;
    }

    public static byte getLowByte(int value, int mask) {
        byte lowByte = (byte)(value & mask);
        return lowByte;
    }

    public static byte[] concat(byte[] array1, byte[] array2) {
        byte[] result = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }
}

