/*
 * Decompiled with CFR 0.152.
 */
package kickass;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.nonasm.tools.FileTool;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.mainparse.MainParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.metanodes.AsmNodeList;
import kickass.setup.KickAssemblerSetup;
import kickass.state.EvaluationState;

public class AssemblerToolbox {
    public static AsmNode loadAndLexOrError(String string, EvaluationState evaluationState, SourceRange sourceRange) {
        AsmNode asmNode = AssemblerToolbox.loadAndLex(string, evaluationState);
        if (asmNode == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Couldn't load file: " + string, sourceRange));
        }
        return asmNode;
    }

    public static AsmNode loadAndLex(String string, EvaluationState evaluationState) {
        File file = evaluationState.fileMgr.getFile(string, false);
        File file2 = evaluationState.fileMgr.getFile(string, true);
        String string2 = FileTool.getCanonicalFilePath(file2);
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (Exception exception) {
            return null;
        }
        return AssemblerToolbox.loadAndLex(bufferedInputStream, string2, evaluationState);
    }

    public static AsmNode loadAndLexOrError(InputStream inputStream, String string, EvaluationState evaluationState, SourceRange sourceRange) {
        AsmNode asmNode = AssemblerToolbox.loadAndLex(inputStream, string, evaluationState);
        if (asmNode == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Couldn't load file: " + string, sourceRange));
        }
        return asmNode;
    }

    public static AsmNode loadAndLex(InputStream inputStream, String string, EvaluationState evaluationState) {
        List<AsmNode> list;
        MainParser mainParser;
        ITokenStream iTokenStream = KickAssemblerSetup.getLexer(string, new InputStreamReader(inputStream), evaluationState);
        evaluationState.mainParser = mainParser = KickAssemblerSetup.getMainParser(evaluationState);
        try {
            list = mainParser.parseAll(iTokenStream, evaluationState);
        }
        catch (IOException iOException) {
            return null;
        }
        AsmNodeList asmNodeList = new AsmNodeList(list);
        return asmNodeList;
    }
}

