/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.misc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.nonasm.tools.EnumUtil;
import kickass.nonasm.tools.tuples.Pair;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ParameterMap {
    private SourceRange range;
    private Map<String, Pair<SourceRange, ExprNode>> parameters = new HashMap<String, Pair<SourceRange, ExprNode>>();
    private Map<String, Value> evaluatedValues = new HashMap<String, Value>();

    public ParameterMap(SourceRange sourceRange) {
        this.range = sourceRange;
    }

    public boolean addParameter(String string, SourceRange sourceRange, ExprNode exprNode, EvaluationState evaluationState) {
        if (this.parameters.containsKey(string)) {
            evaluationState.diagnosticMgr.add(new AsmError("Duplicate parameter", sourceRange));
            return false;
        }
        this.parameters.put(string, new Pair<SourceRange, ExprNode>(sourceRange, exprNode));
        return true;
    }

    public SourceRange getRange() {
        return this.range;
    }

    public boolean exist(String string) {
        return this.parameters.containsKey(string);
    }

    public ExprNode getExpr(String string) {
        Pair<SourceRange, ExprNode> pair = this.parameters.get(string);
        return pair == null ? null : pair.getB();
    }

    public SourceRange getNameRange(String string) {
        Pair<SourceRange, ExprNode> pair = this.parameters.get(string);
        return pair == null ? null : pair.getA();
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public void addErrorsForUnknownParameters(Set<String> set, EvaluationState evaluationState) {
        for (String string : this.parameters.keySet()) {
            if (set.contains(string)) continue;
            evaluationState.diagnosticMgr.add(new AsmError("Unknown parameter", this.getNameRange(string)));
        }
    }

    public void addErrorsForUnknownParameters(Predicate<String> predicate, EvaluationState evaluationState) {
        for (String string : this.parameters.keySet()) {
            if (predicate.test(string)) continue;
            evaluationState.diagnosticMgr.add(new AsmError("Unknown parameter", this.getNameRange(string)));
        }
    }

    public void addErrorsForMutualExclusiveParameres(EvaluationState evaluationState, String ... stringArray) {
        String string = null;
        for (String string2 : this.parameters.keySet()) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            if (string == null) {
                string = string2;
                continue;
            }
            evaluationState.diagnosticMgr.add(new AsmError("Can't define this parameter when '" + string + "' is defined", this.getNameRange(string2)));
        }
    }

    public void addErrorIfNotExist(String string, EvaluationState evaluationState) {
        if (!this.exist(string)) {
            evaluationState.diagnosticMgr.add(new AsmError("Paremter '" + string + "' is missing.", this.range));
        }
    }

    public void addErrorIfNotExist(Collection<String> collection, EvaluationState evaluationState) {
        for (String string : collection) {
            this.addErrorIfNotExist(string, evaluationState);
        }
    }

    public void executePrepass(EvaluationState evaluationState) {
        for (Pair<SourceRange, ExprNode> pair : this.parameters.values()) {
            pair.getB().executePrepass(evaluationState);
        }
    }

    public boolean anyInvalidValues(Set<String> set) {
        for (String string : set) {
            Value value = this.evaluatedValues.get(string);
            if (value == null || !value.isInvalid()) continue;
            return true;
        }
        return false;
    }

    public boolean anyInvalidValues() {
        for (Value value : this.evaluatedValues.values()) {
            if (!value.isInvalid()) continue;
            return true;
        }
        return false;
    }

    public Value evaluate(String string, EvaluationState evaluationState) {
        return !this.exist(string) ? null : this.getExpr(string).evaluate(evaluationState);
    }

    public boolean evaluateAllParameters(EvaluationState evaluationState) {
        boolean bl = false;
        for (Map.Entry<String, Pair<SourceRange, ExprNode>> entry : this.parameters.entrySet()) {
            Value value = entry.getValue().getB().evaluate(evaluationState);
            this.evaluatedValues.put(entry.getKey(), value);
            bl |= value.isInvalid();
        }
        return bl;
    }

    public Value getValue(String string) {
        return this.evaluatedValues.get(string);
    }

    public String getStringValue(String string) {
        return this.getStringValue(string, null);
    }

    public String getStringValue(String string, String string2) {
        if (!this.exist(string)) {
            return string2;
        }
        return this.getValue(string).getString(this.getNameRange(string));
    }

    public boolean getBoolValue(String string, boolean bl) {
        if (!this.exist(string)) {
            return bl;
        }
        return this.getValue(string).getBoolean(this.getNameRange(string));
    }

    public int getIntValue(String string) {
        return this.getValue(string).getInt(this.getNameRange(string));
    }

    public int getIntValue(String string, int n) {
        if (!this.exist(string)) {
            return n;
        }
        return this.getValue(string).getInt(this.getNameRange(string));
    }

    public Integer getIntegerValue(String string, Integer n) {
        if (!this.exist(string)) {
            return n;
        }
        return this.getValue(string).getInt(this.getNameRange(string));
    }

    public <T extends Enum<?>> T getEnumValue(Class<T> clazz, String string, T t) {
        if (!this.exist(string)) {
            return t;
        }
        String string2 = this.getStringValue(string);
        T t2 = EnumUtil.get(clazz, string2);
        if (t2 == null) {
            this.throwParameterException(string, "Unknown litteral '" + string2 + "'");
        }
        return t2;
    }

    public void throwParameterException(String string, String string2) {
        throw new AsmErrorException(string2, this.getNameRange(string));
    }
}

