/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.function.special;

import kickass.common.exceptions.AsmErrorException;
import kickass.nonasm.util.functions.Action3;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ValSActionVarArg<T extends Value>
extends Function {
    private boolean failOnInvalidArgs = true;
    private Action3<T, Value[], SourceRange> action;

    public ValSActionVarArg(String string, Action3<T, Value[], SourceRange> action3) {
        super(string, null, null, true);
        this.action = action3;
    }

    public ValSActionVarArg(String string, boolean bl, Action3<T, Value[], SourceRange> action3) {
        super(string, null, null, true);
        this.action = action3;
        this.failOnInvalidArgs = bl;
    }

    @Override
    public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
        if (valueArray[0].isInvalid()) {
            return valueArray[0];
        }
        if (this.failOnInvalidArgs) {
            for (int i = 1; i < valueArray.length; ++i) {
                if (!valueArray[i].isInvalid()) continue;
                throw new AsmErrorException("Function can't be called when argument " + i + " is invalid (Unresolved label, etc.)", sourceRange);
            }
        }
        this.action.apply(valueArray[0], valueArray, sourceRange);
        return valueArray[0];
    }
}

