/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.segments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import kickass.common.exceptions.ShouldNotBeHereException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.segments.resolvers.IStartResolver;

public class SegmentMemoryBlock {
    public static final Comparator<SegmentMemoryBlock> comparator = SegmentMemoryBlock.getComparator();
    private static long nextBlockSequenceNo = 0L;
    private boolean isVirtual;
    private long seqenceNo;
    private int level;
    private String name;
    private IStartResolver startResolver = null;
    private int start = -1;
    private ArrayList<Entry> entries = new ArrayList();
    private boolean closedForNewEntries = false;
    private int unfilledEntries = 0;
    private int unresolvedLengths = 0;
    private int noOfBytes = 0;
    private byte[] bytes = null;

    public SegmentMemoryBlock(String string, boolean bl) {
        this.name = string;
        this.isVirtual = bl;
        this.seqenceNo = ++nextBlockSequenceNo;
    }

    public SegmentMemoryBlock(String string, long l, int n) {
        this.name = string;
        this.isVirtual = false;
        this.seqenceNo = l;
        this.start = n;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setStartResolver(IStartResolver iStartResolver) {
        this.startResolver = iStartResolver;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void closeForNewEntries() {
        this.closedForNewEntries = true;
    }

    public long getSequenceNo() {
        return this.seqenceNo;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public String getName() {
        return this.name;
    }

    public int getStart() {
        if (this.start < 0 && this.startResolver != null) {
            this.start = this.startResolver.resolve();
        }
        return this.start;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void addDoneEntry(Entry entry) {
        if (this.closedForNewEntries) {
            throw new ShouldNotBeHereException("Can't add entries to a closed block.");
        }
        if (!entry.isFilled()) {
            throw new ShouldNotBeHereException("Entries must be filled when directly added.");
        }
        this.entries.add(entry);
        this.noOfBytes += entry.bytes.length;
    }

    public void addDoneEntry(byte[] byArray, SourceRange sourceRange) {
        if (this.closedForNewEntries) {
            throw new ShouldNotBeHereException("Can't add entries to a closed block.");
        }
        this.entries.add(new Entry(byArray, sourceRange));
        this.noOfBytes += byArray.length;
    }

    public Entry createNewEntry() {
        if (this.closedForNewEntries) {
            throw new ShouldNotBeHereException("Can't create entres on a closed memoryblock.");
        }
        Entry entry = new Entry();
        this.entries.add(entry);
        ++this.unfilledEntries;
        ++this.unresolvedLengths;
        return entry;
    }

    public boolean isFinished() {
        return this.closedForNewEntries && this.unfilledEntries <= 0 && this.getStart() >= 0;
    }

    public boolean isEmpty() {
        return this.noOfBytes == 0;
    }

    public int getNoOfBytes() {
        if (!this.closedForNewEntries || this.unresolvedLengths > 0) {
            return -1;
        }
        return this.noOfBytes;
    }

    public int getEnd() {
        if (!this.closedForNewEntries) {
            return -1;
        }
        int n = this.getStart();
        int n2 = this.getNoOfBytes();
        if (n < 0 || n2 < 0) {
            return -1;
        }
        return n + n2;
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            byte[] byArray = new byte[this.noOfBytes];
            int n = 0;
            for (Entry entry : this.entries) {
                int n2 = entry.bytes.length;
                System.arraycopy(entry.bytes, 0, byArray, n, entry.bytes.length);
                n += n2;
            }
            if (n != byArray.length) {
                throw new ShouldNotBeHereException("Invalid number of bytes in memblock! Contact the author.");
            }
            this.bytes = byArray;
        }
        return this.bytes;
    }

    public boolean hasSameContent(SegmentMemoryBlock segmentMemoryBlock, boolean bl) {
        if (this.isVirtual != segmentMemoryBlock.isVirtual) {
            return false;
        }
        if (this.start != segmentMemoryBlock.start) {
            return false;
        }
        if (bl && !this.name.equals(segmentMemoryBlock.name)) {
            return false;
        }
        return Arrays.equals(this.getBytes(), segmentMemoryBlock.getBytes());
    }

    private static Comparator<SegmentMemoryBlock> getComparator() {
        return new Comparator<SegmentMemoryBlock>(){

            @Override
            public int compare(SegmentMemoryBlock segmentMemoryBlock, SegmentMemoryBlock segmentMemoryBlock2) {
                int n = Integer.compare(segmentMemoryBlock.getStart(), segmentMemoryBlock2.getStart());
                if (n != 0) {
                    return n;
                }
                int n2 = Integer.compare(segmentMemoryBlock.getNoOfBytes(), segmentMemoryBlock2.getNoOfBytes());
                if (n2 != 0) {
                    return n2;
                }
                int n3 = Boolean.compare(segmentMemoryBlock.isVirtual(), segmentMemoryBlock2.isVirtual());
                if (n3 != 0) {
                    return n3;
                }
                byte[] byArray = segmentMemoryBlock.getBytes();
                byte[] byArray2 = segmentMemoryBlock2.getBytes();
                for (int i = 0; i < byArray.length; ++i) {
                    int n4 = Byte.compare(byArray[i], byArray2[i]);
                    if (n4 == 0) continue;
                    return n4;
                }
                return segmentMemoryBlock.getName().compareTo(segmentMemoryBlock2.getName());
            }
        };
    }

    public class Entry {
        private boolean isLengthResolved = false;
        private byte[] bytes;
        private SourceRange range;
        private int setN = -1;

        public Entry() {
        }

        public Entry(byte[] byArray, SourceRange sourceRange) {
            this.bytes = byArray;
            this.range = sourceRange;
        }

        public void setNoOfBytes(int n) {
            if (this.isLengthResolved) {
                if (this.setN != n) {
                    throw new ShouldNotBeHereException("Inconsistent bytecount. Contact the author!");
                }
                return;
            }
            this.setN = n;
            SegmentMemoryBlock.this.noOfBytes += n;
            SegmentMemoryBlock.this.unresolvedLengths--;
            this.isLengthResolved = true;
        }

        public void fillEntry(byte[] byArray, SourceRange sourceRange) {
            if (this.bytes != null) {
                return;
            }
            this.bytes = byArray;
            this.range = sourceRange;
            --SegmentMemoryBlock.this.unfilledEntries;
            this.setNoOfBytes(byArray.length);
        }

        public boolean isFilled() {
            return this.bytes != null;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public SourceRange getRange() {
            return this.range;
        }
    }
}

