/*
 * Decompiled with CFR 0.152.
 */
package mpg;

import mpg.Frame;
import mpg.MPGLib;

public class Common {
    public static final int[][][] tabsel_123 = new int[][][]{new int[][]{{0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384}, {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320}}, new int[][]{{0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}}};
    public static final int[] freqs = new int[]{44100, 48000, 32000, 22050, 24000, 16000, 11025, 12000, 8000};
    public float[][] muls = new float[27][64];
    private static final int MAX_INPUT_FRAMESIZE = 4096;
    private static final String[] modes = new String[]{"Stereo", "Joint-Stereo", "Dual-Channel", "Single-Channel"};
    private static final String[] layers = new String[]{"Unknown", "I", "II", "III"};

    public final boolean head_check(long head, int check_layer) {
        int nLayer = (int)(4L - (head >> 17 & 3L));
        if ((head & 0xFFE00000L) != 0xFFE00000L) {
            return false;
        }
        if (nLayer == 4) {
            return false;
        }
        if (check_layer > 0 && nLayer != check_layer) {
            return false;
        }
        if ((head >> 12 & 0xFL) == 15L) {
            return false;
        }
        if ((head >> 10 & 3L) == 3L) {
            return false;
        }
        return (head & 3L) != 2L;
    }

    public final int decode_header(Frame fr, long newhead) {
        if ((newhead & 0x100000L) != 0L) {
            fr.lsf = (newhead & 0x80000L) != 0L ? 0 : 1;
            fr.mpeg25 = false;
        } else {
            fr.lsf = 1;
            fr.mpeg25 = true;
        }
        fr.lay = (int)(4L - (newhead >> 17 & 3L));
        if ((newhead >> 10 & 3L) == 3L) {
            throw new RuntimeException("Stream error");
        }
        fr.sampling_frequency = fr.mpeg25 ? (int)(6L + (newhead >> 10 & 3L)) : (int)((newhead >> 10 & 3L) + (long)(fr.lsf * 3));
        boolean bl = fr.error_protection = (newhead >> 16 & 1L) == 0L;
        if (fr.mpeg25) {
            fr.bitrate_index = (int)(newhead >> 12 & 0xFL);
        }
        fr.bitrate_index = (int)(newhead >> 12 & 0xFL);
        fr.padding = (int)(newhead >> 9 & 1L);
        fr.extension = (int)(newhead >> 8 & 1L);
        fr.mode = (int)(newhead >> 6 & 3L);
        fr.mode_ext = (int)(newhead >> 4 & 3L);
        fr.copyright = (int)(newhead >> 3 & 1L);
        fr.original = (int)(newhead >> 2 & 1L);
        fr.emphasis = (int)(newhead & 3L);
        fr.stereo = fr.mode == 3 ? 1 : 2;
        switch (fr.lay) {
            case 1: {
                fr.framesize = tabsel_123[fr.lsf][0][fr.bitrate_index] * 12000;
                fr.framesize /= freqs[fr.sampling_frequency];
                fr.framesize = (fr.framesize + fr.padding << 2) - 4;
                fr.down_sample = 0;
                fr.down_sample_sblimit = 32 >> fr.down_sample;
                break;
            }
            case 2: {
                fr.framesize = tabsel_123[fr.lsf][1][fr.bitrate_index] * 144000;
                fr.framesize /= freqs[fr.sampling_frequency];
                fr.framesize += fr.padding - 4;
                fr.down_sample = 0;
                fr.down_sample_sblimit = 32 >> fr.down_sample;
                break;
            }
            case 3: {
                if (fr.framesize > 4096) {
                    System.err.printf("Frame size too big.\n", new Object[0]);
                    fr.framesize = 4096;
                    return 0;
                }
                if (fr.bitrate_index == 0) {
                    fr.framesize = 0;
                    break;
                }
                fr.framesize = tabsel_123[fr.lsf][2][fr.bitrate_index] * 144000;
                fr.framesize /= freqs[fr.sampling_frequency] << fr.lsf;
                fr.framesize = fr.framesize + fr.padding - 4;
                break;
            }
            default: {
                System.err.printf("Sorry, layer %d not supported\n", fr.lay);
                return 0;
            }
        }
        return 1;
    }

    public final void print_header(Frame fr) {
        System.err.printf("MPEG %s, Layer: %s, Freq: %d, mode: %s, modext: %d, BPF : %d\n", fr.mpeg25 ? "2.5" : (fr.lsf != 0 ? "2.0" : "1.0"), layers[fr.lay], freqs[fr.sampling_frequency], modes[fr.mode], fr.mode_ext, fr.framesize + 4);
        System.err.printf("Channels: %d, copyright: %s, original: %s, CRC: %s, emphasis: %d.\n", fr.stereo, fr.copyright != 0 ? "Yes" : "No", fr.original != 0 ? "Yes" : "No", fr.error_protection ? "Yes" : "No", fr.emphasis);
        System.err.printf("Bitrate: %d Kbits/s, Extension value: %d\n", tabsel_123[fr.lsf][fr.lay - 1][fr.bitrate_index], fr.extension);
    }

    public final void print_header_compact(Frame fr) {
        System.err.printf("MPEG %s layer %s, %d kbit/s, %d Hz %s\n", fr.mpeg25 ? "2.5" : (fr.lsf != 0 ? "2.0" : "1.0"), layers[fr.lay], tabsel_123[fr.lsf][fr.lay - 1][fr.bitrate_index], freqs[fr.sampling_frequency], modes[fr.mode]);
    }

    public final int getbits(MPGLib.mpstr_tag mp, int number_of_bits) {
        if (number_of_bits <= 0 || null == mp.wordpointer) {
            return 0;
        }
        long rval = mp.wordpointer[mp.wordpointerPos + 0] & 0xFF;
        rval <<= 8;
        rval |= (long)(mp.wordpointer[mp.wordpointerPos + 1] & 0xFF);
        rval <<= 8;
        rval |= (long)(mp.wordpointer[mp.wordpointerPos + 2] & 0xFF);
        rval <<= mp.bitindex;
        rval &= 0xFFFFFFL;
        mp.bitindex += number_of_bits;
        mp.wordpointerPos += mp.bitindex >> 3;
        mp.bitindex &= 7;
        return (int)(rval >>= 24 - number_of_bits);
    }

    public final int getbits_fast(MPGLib.mpstr_tag mp, int number_of_bits) {
        long rval = mp.wordpointer[mp.wordpointerPos + 0] & 0xFF;
        rval <<= 8;
        rval |= (long)(mp.wordpointer[mp.wordpointerPos + 1] & 0xFF);
        rval <<= mp.bitindex;
        rval &= 0xFFFFL;
        mp.bitindex += number_of_bits;
        mp.wordpointerPos += mp.bitindex >> 3;
        mp.bitindex &= 7;
        return (int)(rval >>= 16 - number_of_bits);
    }

    public final int set_pointer(MPGLib.mpstr_tag mp, int backstep) {
        if (mp.fsizeold < 0 && backstep > 0) {
            System.err.printf("hip: Can't step back %d bytes!\n", backstep);
            return -1;
        }
        byte[] bsbufold = mp.bsspace[1 - mp.bsnum];
        int bsbufoldPos = 512;
        mp.wordpointerPos -= backstep;
        if (backstep != 0) {
            System.arraycopy(bsbufold, bsbufoldPos + mp.fsizeold - backstep, mp.wordpointer, mp.wordpointerPos, backstep);
        }
        mp.bitindex = 0;
        return 0;
    }
}

