/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.compiletime;

import client.teavm.common.compiletime.IniConfigTeaVM;
import client.teavm.common.compiletime.LookupTableTeaVM;
import client.teavm.common.compiletime.PaletteTeaVM;
import client.teavm.common.compiletime.RomsTeaVM;
import client.teavm.common.compiletime.SidIdInfoTeaVM;
import client.teavm.common.compiletime.SidIdTeaVM;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public interface ICompileTime {
    public static final Base64.Decoder DECODER = Base64.getDecoder();
    public static final Map<String, String> DEFAULTS = IniConfigTeaVM.getIniConfig(false);
    public static final Map<String, String> ALL_ROMS = RomsTeaVM.getJavaScriptRoms(false);
    public static final byte[] CHAR_ROM = DECODER.decode(ALL_ROMS.get("CHAR_ROM"));
    public static final byte[] BASIC_ROM = DECODER.decode(ALL_ROMS.get("BASIC_ROM"));
    public static final byte[] KERNAL_ROM = DECODER.decode(ALL_ROMS.get("KERNAL_ROM"));
    public static final byte[] C1541_ROM = DECODER.decode(ALL_ROMS.get("C1541_ROM"));
    public static final byte[] C1541_II_ROM = DECODER.decode(ALL_ROMS.get("C1541_II_ROM"));
    public static final byte[] JIFFY_DOS_C64_ROM = DECODER.decode(ALL_ROMS.get("JIFFYDOS_C64_ROM"));
    public static final byte[] JIFFY_DOS_C1541_ROM = DECODER.decode(ALL_ROMS.get("JIFFYDOS_C1541_ROM"));
    public static final byte[] MPS803_ROM = DECODER.decode(ALL_ROMS.get("MPS803_ROM"));
    public static final byte[] PSID_DRIVER_BIN = DECODER.decode(ALL_ROMS.get("PSID_DRIVER_ROM"));
    public static final byte[] TURBO_HEADER_ROM = DECODER.decode(ALL_ROMS.get("TURBO_HEADER_ROM"));
    public static final byte[] TURBO_DATA_ROM = DECODER.decode(ALL_ROMS.get("TURBO_DATA_ROM"));
    public static final byte[] SLOW_HEADER_ROM = DECODER.decode(ALL_ROMS.get("SLOW_HEADER_ROM"));
    public static final Map<String, byte[]> BUILT_INS = new HashMap<String, byte[]>();
    public static final Map<String, String> PALETTE = PaletteTeaVM.getPalette(false);
    public static final int[] COMBINED_LINES_EVEN = Arrays.stream(PALETTE.get("COMBINED_LINES_EVEN").split(",")).mapToInt(s -> Integer.parseInt(s, 16)).toArray();
    public static final int[] COMBINED_LINES_ODD = Arrays.stream(PALETTE.get("COMBINED_LINES_ODD").split(",")).mapToInt(s -> Integer.parseInt(s, 16)).toArray();
    public static final byte[] LINE_PALETTE_EVEN = DECODER.decode(PALETTE.get("LINE_PALETTE_EVEN"));
    public static final byte[] LINE_PALETTE_ODD = DECODER.decode(PALETTE.get("LINE_PALETTE_ODD"));
    public static final String SID_ID_CFG = SidIdTeaVM.getSidIdCfg(false);
    public static final byte[] SID_ID_CFG_BIN = DECODER.decode(SID_ID_CFG);
    public static final String SID_ID_INFO_CFG = SidIdInfoTeaVM.getSidIdInfoCfg(false);
    public static final byte[] SID_ID_INFO_CFG_BIN = DECODER.decode(SID_ID_INFO_CFG);
    public static final String LOOKUP_TABLE = LookupTableTeaVM.getLookupTable(false);
    public static final float[] AUD_LOOKUP_TABLE = ICompileTime.toFloatArray(Arrays.stream(LOOKUP_TABLE.split(",")).mapToDouble(Double::parseDouble).toArray());

    default public byte[] getBuiltIn(String key) {
        return BUILT_INS.computeIfAbsent(key, theKey -> DECODER.decode(ALL_ROMS.get(theKey)));
    }

    public static float[] toFloatArray(double[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (float)array[i];
        }
        return result;
    }
}

