/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.config;

import java.util.ArrayList;
import java.util.List;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.config.IAudioSection;
import libsidplay.config.IC1541Section;
import libsidplay.config.IConsoleSection;
import libsidplay.config.IEmulationSection;
import libsidplay.config.IFilterSection;
import libsidplay.config.IPrinterSection;
import libsidplay.config.ISidPlay2Section;
import libsidplay.config.IWhatsSidSection;

public interface IConfig {
    public static final int REQUIRED_CONFIG_VERSION = 25;

    public ISidPlay2Section getSidplay2Section();

    public IAudioSection getAudioSection();

    public IEmulationSection getEmulationSection();

    public IC1541Section getC1541Section();

    public IPrinterSection getPrinterSection();

    public IConsoleSection getConsoleSection();

    public IWhatsSidSection getWhatsSidSection();

    public List<? extends IFilterSection> getFilterSection();

    default public List<String> getFilterNames(Emulation emulation, ChipModel chipModel) {
        ArrayList<String> result = new ArrayList<String>();
        for (IFilterSection iFilterSection : this.getFilterSection()) {
            if (!(emulation == Emulation.RESID && chipModel == ChipModel.MOS6581 && iFilterSection.isReSIDFilter6581() || emulation == Emulation.RESID && chipModel == ChipModel.MOS8580 && iFilterSection.isReSIDFilter8580() || emulation == Emulation.RESIDFP && chipModel == ChipModel.MOS6581 && iFilterSection.isReSIDfpFilter6581()) && (emulation != Emulation.RESIDFP || chipModel != ChipModel.MOS8580 || !iFilterSection.isReSIDfpFilter8580())) continue;
            result.add(iFilterSection.getName());
        }
        return result;
    }
}

