/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.reloc65;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class Reloc65 {
    private static final byte[] CMP_O64 = new byte[]{1, 0, 111, 54, 53};
    private static final int bufPos = 26;
    private int tdiff;
    private String[] ud;
    private HashMap<String, Integer> globals;

    public ByteBuffer reloc65(byte[] buf, int addr) {
        byte[] rdtab;
        if (!ByteBuffer.wrap(buf, 0, CMP_O64.length).equals(ByteBuffer.wrap(CMP_O64))) {
            return null;
        }
        int hlen = 26 + this.read_options(buf, 26);
        int tbase = ((buf[9] & 0xFF) << 8) + (buf[8] & 0xFF);
        int tlen = ((buf[11] & 0xFF) << 8) + (buf[10] & 0xFF);
        int dlen = ((buf[15] & 0xFF) << 8) + (buf[14] & 0xFF);
        this.tdiff = addr - tbase;
        this.globals = new HashMap();
        byte[] segt = buf;
        int segtPos = hlen;
        byte[] segd = segt;
        int sedPos = segtPos + tlen;
        byte[] utab = segd;
        int utabPos = sedPos + dlen;
        byte[] rttab = utab;
        int rttabPos = utabPos + this.read_undef(utab, utabPos);
        byte[] extab = rdtab = rttab;
        int rdtabPos = this.reloc_seg(segt, segtPos, tlen, rttab, rttabPos);
        int extabPos = this.reloc_seg(segd, sedPos, dlen, rdtab, rdtabPos);
        this.reloc_globals(extab, extabPos);
        buf[9] = (byte)(addr >> 8 & 0xFF);
        buf[8] = (byte)(addr & 0xFF);
        return ByteBuffer.wrap(segt, segtPos, tlen);
    }

    private int read_options(byte[] buf, int pos) {
        int l = 0;
        int c = buf[pos + 0] & 0xFF;
        while (c != 0) {
            c = buf[pos + (l += c)] & 0xFF;
        }
        return ++l;
    }

    private int read_undef(byte[] buf, int pos) {
        int l = 2;
        int n = (buf[pos] & 0xFF) + ((buf[pos + 1] & 0xFF) << 8);
        this.ud = new String[n];
        for (int i = 0; i < n; ++i) {
            byte[] tmp = new byte[32];
            for (int j = 0; j < buf.length; ++j) {
                if (buf[pos + l + j] == 0) {
                    this.ud[i] = new String(tmp, 0, j, StandardCharsets.US_ASCII);
                    break;
                }
                tmp[j] = buf[pos + l + j];
            }
            while (buf[pos + l++] != 0) {
            }
        }
        return l;
    }

    private int reloc_seg(byte[] buf, int bufPos, int len, byte[] rtab, int rtabPos) {
        int adr = -1;
        while (rtab[rtabPos] != 0) {
            if ((rtab[rtabPos] & 0xFF) == 255) {
                adr += 254;
                ++rtabPos;
                continue;
            }
            adr += rtab[rtabPos] & 0xFF;
            int type = rtab[++rtabPos] & 0xE0;
            int seg = rtab[rtabPos] & 7;
            ++rtabPos;
            switch (type) {
                case 128: {
                    int old = (buf[bufPos + adr] & 0xFF) + ((buf[bufPos + adr + 1] & 0xFF) << 8);
                    int newv = seg != 0 ? old + this.reldiff(seg) : old + this.find_global(rtab, rtabPos);
                    buf[bufPos + adr] = (byte)(newv & 0xFF);
                    buf[bufPos + adr + 1] = (byte)(newv >> 8 & 0xFF);
                    break;
                }
                case 64: {
                    int old = ((buf[bufPos + adr] & 0xFF) << 8) + (rtab[rtabPos] & 0xFF);
                    int newv = seg != 0 ? old + this.reldiff(seg) : old + this.find_global(rtab, rtabPos);
                    buf[bufPos + adr] = (byte)(newv >> 8 & 0xFF);
                    rtab[rtabPos] = (byte)(newv & 0xFF);
                    ++rtabPos;
                    break;
                }
                case 32: {
                    int old = buf[bufPos + adr] & 0xFF;
                    int newv = seg != 0 ? old + this.reldiff(seg) : old + this.find_global(rtab, rtabPos);
                    buf[bufPos + adr] = (byte)(newv & 0xFF);
                    break;
                }
            }
            if (seg != 0) continue;
            rtabPos += 2;
        }
        if (adr > len) {
            System.err.println("reloc65: Warning: relocation table entries past segment end!\n");
        }
        return ++rtabPos;
    }

    private int find_global(byte[] bp, int bpPos) {
        String name = this.ud[(bp[bpPos + 0] & 0xFF) + ((bp[bpPos + 1] & 0xFF) << 8)];
        return this.globals.get(name);
    }

    private int reloc_globals(byte[] buf, int bufPos) {
        int n = (buf[bufPos + 0] & 0xFF) + ((buf[bufPos + 1] & 0xFF) << 8);
        bufPos += 2;
        int newv = 0;
        while (n != 0) {
            while (buf[bufPos++] != 0) {
            }
            int seg = buf[bufPos] & 0xFF;
            int old = (buf[bufPos + 1] & 0xFF) + ((buf[bufPos + 2] & 0xFF) << 8);
            newv = seg != 0 ? old + this.reldiff(seg) : old + this.find_global(buf, bufPos + 1);
            buf[bufPos + 1] = (byte)(newv & 0xFF);
            buf[bufPos + 2] = (byte)(newv >> 8 & 0xFF);
            bufPos += 3;
            --n;
        }
        return bufPos;
    }

    private int reldiff(int s) {
        return s == 2 ? this.tdiff : 0;
    }
}

