/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.stringsearch;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class CharIntMap
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 1L;
    private int[] array;
    private char lowest;
    private int defaultValue;

    public CharIntMap() {
    }

    public CharIntMap(int extent, char lowest) {
        this(extent, lowest, 0);
    }

    public CharIntMap(int extent, char lowest, int defaultValue) {
        this.array = new int[extent];
        this.lowest = lowest;
        if (defaultValue != 0) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = defaultValue;
            }
            this.defaultValue = defaultValue;
        }
    }

    public Object clone() {
        CharIntMap out = new CharIntMap();
        out.lowest = this.lowest;
        out.defaultValue = this.defaultValue;
        if (this.array != null) {
            out.array = new int[this.array.length];
            System.arraycopy(this.array, 0, out.array, 0, this.array.length);
        }
        return out;
    }

    public int get(char c) {
        char x = (char)(c - this.lowest);
        if (x >= this.array.length) {
            return this.defaultValue;
        }
        return this.array[x];
    }

    public void set(char c, int val) {
        char x = (char)(c - this.lowest);
        if (x >= this.array.length) {
            return;
        }
        this.array[x] = val;
    }

    public int getExtent() {
        return this.array.length;
    }

    public char getLowest() {
        return this.lowest;
    }

    public char getHighest() {
        return (char)(this.lowest + this.array.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharIntMap)) {
            return false;
        }
        CharIntMap m = (CharIntMap)obj;
        if (this.lowest != m.lowest) {
            return false;
        }
        if (this.defaultValue != m.defaultValue) {
            return false;
        }
        if (this.array == null && m.array == null) {
            return true;
        }
        if (this.array != null && m.array == null) {
            return false;
        }
        if (this.array == null && m.array != null) {
            return false;
        }
        if (this.array != null && m.array != null) {
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i] == m.array[i]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int out = this.getClass().getName().hashCode();
        out ^= this.lowest;
        out ^= this.defaultValue;
        if (this.array != null) {
            for (int element : this.array) {
                out ^= element;
            }
        }
        return out;
    }

    public String toString() {
        StringBuffer out = new StringBuffer(128);
        out.append("{ CharIntMap: lowest = ");
        out.append(this.lowest);
        out.append(", defaultValue = ");
        out.append(this.defaultValue);
        if (this.array != null) {
            out.append(", array = ");
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i] == 0) continue;
                out.append(i);
                out.append(": ");
                out.append(this.array[i]);
            }
        }
        out.append(" }");
        return out.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.array == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.array.length);
            for (int element : this.array) {
                out.writeInt(element);
            }
        }
        out.writeChar(this.lowest);
        out.writeInt(this.defaultValue);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int l = in.readInt();
        if (l > 0) {
            this.array = new int[l];
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = in.readInt();
            }
        }
        this.lowest = in.readChar();
        this.defaultValue = in.readInt();
    }
}

