/*
 * Decompiled with CFR 0.152.
 */
package server.netsiddev.ini;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import libsidplay.config.IFilterSection;
import server.netsiddev.ini.IniJSIDDeviceAudioSection;
import server.netsiddev.ini.IniJSIDDeviceSection;
import server.netsiddev.ini.IniJSIDDeviceWhatsSidSection;
import sidplay.ini.IniFilterSection;
import sidplay.ini.IniReader;

public class JSIDDeviceConfig {
    protected static final int REQUIRED_CONFIG_VERSION = 1;
    private static final String FILE_NAME = "jsiddevice.ini";
    private final File iniPath = this.getINIPath();
    private static final String JSIDDEVICE1_NAME_PREFIX = "JSidDevice";
    private IniJSIDDeviceSection jsiddeviceSection;
    private IniJSIDDeviceAudioSection audioSection;
    private IniJSIDDeviceWhatsSidSection whatsSidSection;
    protected IniReader iniReader;
    private String[] filterList;

    private void clear() {
        this.jsiddeviceSection = new IniJSIDDeviceSection(this.iniReader);
        this.audioSection = new IniJSIDDeviceAudioSection(this.iniReader);
        this.whatsSidSection = new IniJSIDDeviceWhatsSidSection(this.iniReader);
        ArrayList<String> filters = new ArrayList<String>();
        ArrayList<String> filtersResidfp = new ArrayList<String>();
        ArrayList<String> filtersResid = new ArrayList<String>();
        for (String heading : this.iniReader.listSections()) {
            if (!heading.matches("Filter.*")) continue;
            String filterName = heading.substring(6);
            if (filterName.startsWith(JSIDDEVICE1_NAME_PREFIX)) {
                filters.add(filterName);
                continue;
            }
            IFilterSection iniFilter = this.getFilter(filterName);
            if (iniFilter.isReSIDfpFilter6581() || iniFilter.isReSIDfpFilter8580()) {
                filtersResidfp.add(filterName);
                continue;
            }
            filtersResid.add(filterName);
        }
        Collections.sort(filters);
        Collections.sort(filtersResidfp);
        Collections.sort(filtersResid, new compareReSidFilterNames());
        filters.addAll(filtersResid);
        filters.addAll(filtersResidfp);
        this.filterList = filters.toArray(new String[0]);
    }

    public IFilterSection getFilter(String filterName) {
        return new IniFilterSection(this.iniReader, "Filter" + filterName);
    }

    public String[] getFilterList() {
        return this.filterList;
    }

    public JSIDDeviceConfig(boolean createIfNotExists) {
        this.read();
        if (!this.iniPath.exists() && createIfNotExists) {
            this.write();
        }
    }

    private void read() {
        if (this.iniPath.exists()) {
            try (FileInputStream is = new FileInputStream(this.iniPath);){
                this.iniReader = new IniReader(is);
                this.clear();
                if (this.jsiddeviceSection.getVersion() == 1) {
                    return;
                }
                this.createINIBackup(this.iniPath);
            }
            catch (Exception e) {
                System.err.println("INI reading failed: " + e.getMessage());
            }
            System.out.println("INI file old/broken (version=" + this.jsiddeviceSection.getVersion() + "). Using default settings.");
        }
        this.readInternal();
    }

    private File getINIPath() {
        for (String parent : new String[]{System.getProperty("user.dir"), System.getProperty("user.home")}) {
            File configPlace = new File(parent, FILE_NAME);
            if (!configPlace.exists()) continue;
            return configPlace;
        }
        return new File(System.getProperty("user.home"), FILE_NAME);
    }

    private void createINIBackup(File iniFile) {
        iniFile.renameTo(new File(iniFile.getParent(), "jsiddevice.ini.bak"));
    }

    private void readInternal() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("server/netsiddev/ini/jsiddevice.ini");){
            this.iniReader = new IniReader(is);
            this.clear();
            this.jsiddeviceSection.setVersion(1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write() {
        try {
            if (!this.iniReader.isDirty()) {
                return;
            }
            this.iniReader.save(this.iniPath.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IniJSIDDeviceSection jsiddevice() {
        return this.jsiddeviceSection;
    }

    public final IniJSIDDeviceAudioSection audio() {
        return this.audioSection;
    }

    public final IniJSIDDeviceWhatsSidSection whatsSidSection() {
        return this.whatsSidSection;
    }

    public class compareReSidFilterNames
    implements Comparator<String> {
        private static final String LIGHT8580 = "Light8580";
        private static final String LIGHT = "Light";
        private static final String DARK = "Dark";

        @Override
        public int compare(String o1, String o2) {
            if (o1.startsWith(LIGHT) && !o2.startsWith(LIGHT)) {
                return -1;
            }
            if (o2.startsWith(LIGHT) && !o1.startsWith(LIGHT)) {
                return 1;
            }
            if (o2.startsWith(LIGHT) && o1.startsWith(LIGHT)) {
                if (o1.startsWith(LIGHT8580) && !o2.startsWith(LIGHT8580)) {
                    return 1;
                }
                if (o2.startsWith(LIGHT8580) && !o1.startsWith(LIGHT8580)) {
                    return -1;
                }
                return -o1.compareTo(o2);
            }
            if (o1.startsWith(DARK) && !o2.startsWith(DARK)) {
                return 1;
            }
            if (o2.startsWith(DARK) && !o1.startsWith(DARK)) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }
}

