/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.EventScheduler;
import libsidplay.common.SIDListener;
import libsidplay.config.IAudioSection;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;
import sidplay.audio.siddump.SIDDumpExtension;
import sidplay.audio.siddump.SidDumpOutput;

public abstract class SIDDumpDriver
extends SIDDumpExtension
implements AudioDriver,
SIDListener {
    protected OutputStream out;
    private ByteBuffer sampleBuffer;

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        AudioConfig cfg = new AudioConfig(audioSection);
        this.init(cpuClock);
        this.setTimeInSeconds(false);
        this.out = this.getOut(recordingFilename);
        this.out.write(this.toHeaderString().getBytes(StandardCharsets.ISO_8859_1));
        this.sampleBuffer = ByteBuffer.allocateDirect(cfg.getChunkFrames() * 2 * cfg.getChannels()).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void add(SidDumpOutput output) throws IOException {
        this.out.write(output.toString().getBytes(StandardCharsets.ISO_8859_1));
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    @Override
    public void write() throws InterruptedException {
    }

    @Override
    public void close() {
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    @Override
    public boolean isRecording() {
        return true;
    }

    @Override
    public String getExtension() {
        return ".txt";
    }

    protected abstract OutputStream getOut(String var1) throws IOException;

    public static class SIDDumpStreamDriver
    extends SIDDumpDriver {
        public SIDDumpStreamDriver(OutputStream out) {
            this.out = out;
        }

        @Override
        protected OutputStream getOut(String recordingFilename) {
            return this.out;
        }
    }

    public static class SIDDumpFileDriver
    extends SIDDumpDriver {
        @Override
        protected OutputStream getOut(String recordingFilename) throws IOException {
            System.out.println("Recording, file=" + recordingFilename);
            return new FileOutputStream(recordingFilename);
        }

        @Override
        public void close() {
            super.close();
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing SIDDumpDriver stream", e);
                }
                finally {
                    this.out = null;
                }
            }
        }
    }
}

