/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio.xuggle;

import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import sidplay.audio.xuggle.XuggleBase;
import sidplay.player.ObjectProperty;
import sidplay.player.State;

public abstract class XuggleVideoPlayer
extends XuggleBase
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(XuggleVideoPlayer.class.getName());
    protected ObjectProperty<State> stateProperty = new ObjectProperty<State>(State.class.getSimpleName(), State.QUIT);
    private IContainer container;
    private IStreamCoder videoCoder;
    private IStreamCoder audioCoder;
    private int videoStreamId;
    private int audioStreamId;
    private IConverter converter;

    public XuggleBase.VideoInfo open(String filename) {
        this.stateProperty.set(State.OPEN);
        this.container = IContainer.make();
        this.throwExceptionOnError(this.container.open(filename, IContainer.Type.READ, null), "Could not open: '" + filename + "'");
        this.videoStreamId = -1;
        this.audioStreamId = -1;
        for (int streamIdx = 0; streamIdx < this.container.getNumStreams(); ++streamIdx) {
            IStreamCoder coder = this.container.getStream((long)streamIdx).getStreamCoder();
            if (this.videoStreamId == -1 && coder.getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO) {
                this.videoStreamId = streamIdx;
                this.videoCoder = coder;
                continue;
            }
            if (this.audioStreamId != -1 || coder.getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO) continue;
            this.audioStreamId = streamIdx;
            this.audioCoder = coder;
        }
        if (this.videoStreamId == -1 && this.audioStreamId == -1) {
            throw new RuntimeException("could not find audio or video stream in container: " + filename);
        }
        if (this.videoCoder != null) {
            this.throwExceptionOnError(this.videoCoder.open(null, null));
        }
        if (this.audioCoder != null) {
            this.throwExceptionOnError(this.audioCoder.open(null, null));
        }
        this.dump();
        this.stateProperty.set(State.START);
        return new XuggleBase.VideoInfo(this.container, this.audioCoder, this.videoCoder);
    }

    @Override
    public void run() {
        this.stateProperty.set(State.PLAY);
        try {
            IPacket packet = IPacket.make();
            while (this.container.readNextPacket(packet) >= 0 && (this.stateProperty.get() == State.PLAY || this.stateProperty.get() == State.PAUSE)) {
                while (this.stateProperty.get() == State.PAUSE) {
                    Thread.yield();
                }
                if (this.videoStreamId != -1 && packet.getStreamIndex() == this.videoStreamId) {
                    this.decodeVideoPacket(packet);
                    continue;
                }
                if (this.audioStreamId == -1 || packet.getStreamIndex() != this.audioStreamId) continue;
                this.decodeAudioPacket(packet);
            }
            packet.delete();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.stateProperty.get() == State.PLAY) {
            this.stateProperty.set(State.END);
        }
    }

    private void decodeAudioPacket(IPacket packet) throws InterruptedException {
        int bytesDecoded;
        IAudioSamples samples = IAudioSamples.make((long)1024L, (long)this.audioCoder.getChannels());
        for (int offset = 0; offset < packet.getSize() && (bytesDecoded = this.audioCoder.decodeAudio(samples, packet, offset)) >= 0; offset += bytesDecoded) {
            if (!samples.isComplete()) continue;
            this.write(samples.getData().getByteArray(0, samples.getSize()));
        }
    }

    private void decodeVideoPacket(IPacket packet) {
        IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)this.videoCoder.getPixelType(), (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
        int bytesDecoded = this.videoCoder.decodeVideo(picture, packet, 0);
        if (bytesDecoded < 0) {
            return;
        }
        if (picture.isComplete()) {
            if (this.converter == null) {
                this.converter = ConverterFactory.createConverter((String)"XUGGLER-BGR-24", (IVideoPicture)picture);
            }
            this.write(this.converter.toImage(picture));
        }
    }

    public void pauseContinue() {
        if (this.stateProperty.get() == State.PLAY) {
            this.stateProperty.set(State.PAUSE);
        } else {
            this.stateProperty.set(State.PLAY);
        }
    }

    public void terminate() {
        this.stateProperty.set(State.QUIT);
    }

    public void close() {
        this.converter = null;
        if (this.videoCoder != null) {
            this.videoCoder.close();
            this.videoCoder = null;
        }
        if (this.audioCoder != null) {
            this.audioCoder.close();
            this.audioCoder = null;
        }
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
    }

    private void dump() {
        LOGGER.info(String.format("*** Start of Video Info ***", new Object[0]));
        StringBuilder containerInfo = new StringBuilder();
        containerInfo.append(String.format("Number of streams: %d; ", this.container.getNumStreams()));
        containerInfo.append(String.format("Start time: %d; ", this.container.getStartTime()));
        containerInfo.append(String.format("Duration: %dus; ", this.container.getDuration()));
        containerInfo.append(String.format("File Size: %d bytes; ", this.container.getFileSize()));
        containerInfo.append(String.format("Bit Rate: %d bytes/sec; ", this.container.getBitRate()));
        LOGGER.info(containerInfo.toString());
        if (this.videoStreamId != -1) {
            IStream videoStream = this.container.getStream((long)this.videoStreamId);
            StringBuilder videoInfo = new StringBuilder();
            videoInfo.append(String.format("type: %s; ", this.videoCoder.getCodecType()));
            videoInfo.append(String.format("codec: %s; ", this.videoCoder.getCodecID()));
            videoInfo.append(String.format("duration: %sus; ", videoStream.getDuration()));
            videoInfo.append(String.format("timebase: %d/%d; ", videoStream.getTimeBase().getNumerator(), videoStream.getTimeBase().getDenominator()));
            videoInfo.append(String.format("video timebase: %d/%d; ", this.videoCoder.getTimeBase().getNumerator(), this.videoCoder.getTimeBase().getDenominator()));
            videoInfo.append(String.format("frame rate: %f; ", videoStream.getFrameRate().getDouble()));
            videoInfo.append(String.format("frames: %f; ", videoStream.getFrameRate().getDouble() * (double)this.container.getDuration() / 1000000.0));
            LOGGER.info(videoInfo.toString());
        }
        if (this.audioStreamId != -1) {
            IStream audioStream = this.container.getStream((long)this.audioStreamId);
            StringBuilder audioInfo = new StringBuilder();
            audioInfo.append(String.format("type: %s; ", this.audioCoder.getCodecType()));
            audioInfo.append(String.format("codec: %s; ", this.audioCoder.getCodecID()));
            audioInfo.append(String.format("duration: %sus; ", audioStream.getDuration()));
            audioInfo.append(String.format("audio timebase: %d/%d; ", audioStream.getTimeBase().getNumerator(), audioStream.getTimeBase().getDenominator()));
            audioInfo.append(String.format("coder timebase: %d/%d; ", this.audioCoder.getTimeBase().getNumerator(), this.audioCoder.getTimeBase().getDenominator()));
            audioInfo.append(String.format("sample rate: %d; ", this.audioCoder.getSampleRate()));
            audioInfo.append(String.format("samples: %f; ", (double)((long)this.audioCoder.getSampleRate() * this.container.getDuration()) / 1000000.0));
            audioInfo.append(String.format("channels: %d; ", this.audioCoder.getChannels()));
            LOGGER.info(audioInfo.toString());
        }
    }

    protected abstract void write(byte[] var1) throws InterruptedException;

    protected abstract void write(BufferedImage var1);
}

