/*
 * Decompiled with CFR 0.152.
 */
package ui.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;

public class Extract7ZipUtil {
    private File archive;
    private File outputDirectoryFile;
    private List<File> filesList = new ArrayList<File>();

    public Extract7ZipUtil(File archive, File outputDirectory) {
        this.archive = archive;
        this.outputDirectoryFile = outputDirectory;
    }

    public void extract() throws IOException {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.archive, "r");
             IInArchive inArchive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(randomAccessFile));){
            inArchive.extract(null, false, (IArchiveExtractCallback)new ExtractCallback(inArchive));
        }
    }

    public File getZipFile() {
        return new File(this.archive.getAbsolutePath()){

            @Override
            public File[] listFiles() {
                return Extract7ZipUtil.this.filesList.toArray(new File[0]);
            }
        };
    }

    private class ExtractCallback
    implements IArchiveExtractCallback {
        private IInArchive inArchive;
        private OutputStream outputStream;
        private File file;
        private boolean isFolder;

        private ExtractCallback(IInArchive inArchive) {
            this.inArchive = inArchive;
        }

        public void setTotal(long total) throws SevenZipException {
        }

        public void setCompleted(long completeValue) throws SevenZipException {
        }

        public ISequentialOutStream getStream(int index, ExtractAskMode extractAskMode) throws SevenZipException {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                    this.outputStream = null;
                }
                catch (IOException e1) {
                    throw new SevenZipException("Error closing file: " + this.file.getAbsolutePath());
                }
            }
            this.isFolder = (Boolean)this.inArchive.getProperty(index, PropID.IS_FOLDER);
            if (extractAskMode != ExtractAskMode.EXTRACT) {
                return null;
            }
            String path = (String)this.inArchive.getProperty(index, PropID.PATH);
            this.file = new File(Extract7ZipUtil.this.outputDirectoryFile, path);
            if (this.isFolder) {
                this.createDirectory(this.file);
                return null;
            }
            this.createDirectory(this.file.getParentFile());
            Extract7ZipUtil.this.filesList.add(this.file);
            try {
                this.outputStream = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new SevenZipException("Error opening file: " + this.file.getAbsolutePath(), (Throwable)e);
            }
            return data -> {
                try {
                    this.outputStream.write(data);
                }
                catch (IOException e) {
                    throw new SevenZipException("Error writing to file: " + this.file.getAbsolutePath());
                }
                return data.length;
            };
        }

        private void createDirectory(File parentFile) throws SevenZipException {
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new SevenZipException("Error creating directory: " + parentFile.getAbsolutePath());
            }
        }

        public void prepareOperation(ExtractAskMode extractAskMode) throws SevenZipException {
        }

        public void setOperationResult(ExtractOperationResult extractOperationResult) throws SevenZipException {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                    this.outputStream = null;
                }
                catch (IOException e) {
                    throw new SevenZipException("Error closing file: " + this.file.getAbsolutePath());
                }
            }
        }
    }
}

