/*
 * Decompiled with CFR 0.152.
 */
package ui.oscilloscope;

import javafx.fxml.FXML;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import libsidplay.common.SIDEmu;
import sidplay.Player;
import ui.common.C64Window;
import ui.oscilloscope.SIDGauge;

public final class FilterGauge
extends SIDGauge {
    @FXML
    private TitledPane border;
    @FXML
    private ImageView area;

    public FilterGauge() {
    }

    public FilterGauge(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    protected ImageView getArea() {
        return this.area;
    }

    @Override
    protected TitledPane getTitledPane() {
        return this.border;
    }

    @Override
    public SIDGauge sample(SIDEmu sidemu) {
        int fc = sidemu.readInternalRegister(21) & 7;
        this.accumulate((float)(fc |= (sidemu.readInternalRegister(22) & 0xFF) << 3) / 2047.0f);
        return this;
    }

    @Override
    public void addImage(SIDEmu sidemu) {
        if (sidemu != null) {
            byte vol = sidemu.readInternalRegister(24);
            this.setText(this.createText(vol));
        }
        super.addImage(sidemu);
    }

    private String createText(byte vol) {
        StringBuilder result = new StringBuilder();
        result.append(this.localizer.getString("FILTER"));
        result.append(" ");
        if ((vol & 0x10) != 0) {
            result.append("L");
        }
        if ((vol & 0x20) != 0) {
            result.append("B");
        }
        if ((vol & 0x40) != 0) {
            result.append("H");
        }
        return result.toString();
    }
}

