/*
 * Decompiled with CFR 0.152.
 */
package ui.statusbar;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Iterator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.c1541.C1541;
import libsidplay.sidtune.SidTune;
import libsidutils.sidid.SidIdInfo;
import libsidutils.status.Status;
import sidplay.Player;
import sidplay.player.State;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.util.DesktopUtil;
import ui.entities.config.C1541Section;

public class StatusBar
extends C64VBox
implements UIPart {
    private static Clip MOTORSOUND_AUDIOCLIP;
    private static Clip TRACKSOUND_AUDIOCLIP;
    @FXML
    private Label statusLbl;
    private StringBuilder playerId;
    private StringBuilder playerinfos;
    private Status status;
    private Tooltip statusTooltip;
    private Timeline scrollText;
    private Timeline timer;
    private int oldHalfTrack;
    private boolean oldMotorOn;
    private StateChangeListener propertyChangeListener;

    public StatusBar() {
    }

    public StatusBar(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.playerId = new StringBuilder();
        this.playerinfos = new StringBuilder();
        this.status = new Status(this.util.getPlayer(), this.util.getPlayer().getTune(), this.util.getPlayer().getSidBuilder(), this.util.getPlayer().getAudioDriver(), tune -> this.util.getPlayer().getRecordingFilename(), () -> this.util.getPlayer().getSidDatabaseInfo(db -> db.getSongLength(this.util.getPlayer().getTune()), 0.0), () -> this.util.getPlayer().isPsid64Detected(), this.util.getBundle()::getString);
        this.statusTooltip = new Tooltip();
        this.statusLbl.setOnMouseClicked(e -> {
            if (this.statusLbl.getUserData() != null) {
                DesktopUtil.browse(this.statusLbl.getUserData().toString());
            }
        });
        this.propertyChangeListener = new StateChangeListener();
        this.util.getPlayer().stateProperty().addListener(this.propertyChangeListener);
        Duration duration = Duration.millis((double)500.0);
        KeyFrame frame = new KeyFrame(duration, evt -> this.setStatusLine(), new KeyValue[0]);
        this.timer = new Timeline(new KeyFrame[]{frame});
        this.timer.setCycleCount(-1);
        this.timer.playFromStart();
    }

    protected void setStatusLine() {
        boolean motorOn;
        C1541Section c1541Section = this.util.getConfig().getC1541Section();
        C1541 c1541 = this.util.getPlayer().getFloppies()[0];
        boolean bl = motorOn = c1541Section.isDriveSoundOn() && c1541.getDiskController().isMotorOn();
        if (MOTORSOUND_AUDIOCLIP != null) {
            if (!this.oldMotorOn && motorOn) {
                MOTORSOUND_AUDIOCLIP.loop(-1);
            } else if (this.oldMotorOn && !motorOn) {
                MOTORSOUND_AUDIOCLIP.stop();
            }
        }
        this.oldMotorOn = motorOn;
        int halfTrack = c1541.getDiskController().getHalfTrack();
        if (TRACKSOUND_AUDIOCLIP != null && this.oldHalfTrack != halfTrack && motorOn) {
            TRACKSOUND_AUDIOCLIP.stop();
            TRACKSOUND_AUDIOCLIP.setFramePosition(0);
            TRACKSOUND_AUDIOCLIP.start();
        }
        this.oldHalfTrack = halfTrack;
        Datasette datasette = this.util.getPlayer().getDatasette();
        if (datasette.getMotor()) {
            DoubleProperty progressProperty = this.util.progressProperty(this.getScene());
            progressProperty.setValue((Number)Float.valueOf(datasette.getProgress()));
        }
        String determineTapeActivity = this.status.determineTapeActivity(true);
        String determineDiskActivity = this.status.determineDiskActivity(true);
        String determineSongLength = this.status.determineSongLength(true);
        String determineRecording = this.status.determineRecording();
        String determinePSID64 = this.status.determinePSID64();
        String determineCartridge = this.status.determineCartridge();
        String determineTuneSpeed = this.status.determineTuneSpeed();
        String determineSong = this.status.determineSong();
        StringBuilder line = new StringBuilder();
        line.append(this.status.determineVideoNorm());
        line.append(", ");
        line.append(this.status.determineChipModels());
        line.append(", ");
        line.append(this.status.determineEmulations());
        line.append((CharSequence)this.playerId);
        line.append(determinePSID64.isEmpty() ? "" : ", " + determinePSID64);
        line.append(determineCartridge.isEmpty() ? "" : ", " + determineCartridge);
        line.append(determineTuneSpeed.isEmpty() ? "" : ", " + determineTuneSpeed);
        line.append(determineSong.isEmpty() ? "" : ", " + determineSong);
        line.append(determineDiskActivity.isEmpty() ? "" : ", " + determineDiskActivity);
        line.append(determineTapeActivity.isEmpty() ? "" : ", " + determineTapeActivity);
        line.append(", ");
        line.append(this.status.determineHeap());
        line.append(", ");
        line.append(this.status.determineTime(true));
        line.append(determineSongLength.isEmpty() ? "" : "/" + determineSongLength);
        line.append(determineRecording.isEmpty() ? "" : ", " + determineRecording);
        this.statusLbl.setText(line.toString());
        this.statusLbl.setTooltip(this.playerinfos.length() > 0 ? this.statusTooltip : null);
        this.statusTooltip.setText(this.playerinfos.toString());
    }

    @Override
    public void doClose() {
        if (MOTORSOUND_AUDIOCLIP != null) {
            this.closeClip(MOTORSOUND_AUDIOCLIP);
        }
        if (TRACKSOUND_AUDIOCLIP != null) {
            this.closeClip(TRACKSOUND_AUDIOCLIP);
        }
        this.util.getPlayer().stateProperty().removeListener(this.propertyChangeListener);
    }

    private void recalculateScrollText() {
        if (this.scrollText != null) {
            this.scrollText.stop();
        }
        this.scrollText = this.createScrollTextTimeLine();
    }

    private Timeline createScrollTextTimeLine() {
        Timeline timeLine;
        this.statusLbl.setTranslateX(0.0);
        double sceneWidth = this.getScene().getWidth() - 20.0;
        double statusWidth = this.statusLbl.getLayoutBounds().getWidth();
        if (statusWidth > sceneWidth) {
            double duration = (statusWidth - sceneWidth) / 40.0;
            KeyValue initKeyValue = new KeyValue((WritableValue)this.statusLbl.translateXProperty(), (Object)0);
            KeyFrame initFrame = new KeyFrame(Duration.seconds((double)duration), new KeyValue[]{initKeyValue});
            KeyValue leftKeyValue = new KeyValue((WritableValue)this.statusLbl.translateXProperty(), (Object)(-1.0 * (statusWidth - sceneWidth)));
            KeyFrame leftFrame = new KeyFrame(Duration.seconds((double)(duration + 5.0)), new KeyValue[]{leftKeyValue});
            KeyFrame stillLeftFrame = new KeyFrame(Duration.seconds((double)(duration + 10.0)), new KeyValue[]{leftKeyValue});
            KeyFrame rightFrame = new KeyFrame(Duration.seconds((double)(duration + 15.0)), new KeyValue[]{initKeyValue});
            timeLine = new Timeline(new KeyFrame[]{initFrame, leftFrame, stillLeftFrame, rightFrame});
        } else {
            KeyValue initKeyValue = new KeyValue((WritableValue)this.statusLbl.translateXProperty(), (Object)0);
            KeyFrame initFrame = new KeyFrame(Duration.seconds((double)5.0), new KeyValue[]{initKeyValue});
            timeLine = new Timeline(new KeyFrame[]{initFrame});
        }
        timeLine.setOnFinished(event -> this.recalculateScrollText());
        timeLine.playFromStart();
        return timeLine;
    }

    private void closeClip(Clip clip) {
        if (clip.isOpen()) {
            if (clip.isActive()) {
                clip.stop();
                clip.flush();
            }
            clip.close();
        }
    }

    static {
        try {
            AudioInputStream motorSoundAudioClip = AudioSystem.getAudioInputStream(StatusBar.class.getResource("/ui/sounds/motor.wav"));
            MOTORSOUND_AUDIOCLIP = (Clip)AudioSystem.getLine(new DataLine.Info(Clip.class, motorSoundAudioClip.getFormat()));
            MOTORSOUND_AUDIOCLIP.open(motorSoundAudioClip);
            MOTORSOUND_AUDIOCLIP.setLoopPoints(0, -1);
            AudioInputStream trackSoundAudioClip = AudioSystem.getAudioInputStream(StatusBar.class.getResource("/ui/sounds/track.wav"));
            TRACKSOUND_AUDIOCLIP = (Clip)AudioSystem.getLine(new DataLine.Info(Clip.class, trackSoundAudioClip.getFormat()));
            TRACKSOUND_AUDIOCLIP.open(trackSoundAudioClip);
            TRACKSOUND_AUDIOCLIP.setLoopPoints(0, -1);
        }
        catch (IOException | IllegalArgumentException | LineUnavailableException | UnsupportedAudioFileException e) {
            System.err.println("Warn: drive sounds are not available:" + e.getMessage());
        }
    }

    private class StateChangeListener
    implements PropertyChangeListener {
        private StateChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            SidTune sidTune = StatusBar.this.util.getPlayer().getTune();
            Platform.runLater(() -> {
                if (event.getNewValue() == State.START) {
                    StatusBar.this.status = new Status(StatusBar.this.util.getPlayer(), StatusBar.this.util.getPlayer().getTune(), StatusBar.this.util.getPlayer().getSidBuilder(), StatusBar.this.util.getPlayer().getAudioDriver(), tune -> StatusBar.this.util.getPlayer().getRecordingFilename(), () -> StatusBar.this.util.getPlayer().getSidDatabaseInfo(db -> db.getSongLength(StatusBar.this.util.getPlayer().getTune()), 0.0), () -> StatusBar.this.util.getPlayer().isPsid64Detected(), StatusBar.this.util.getBundle()::getString);
                    this.setPlayerIdAndInfos(sidTune);
                    StatusBar.this.recalculateScrollText();
                }
            });
        }

        private void setPlayerIdAndInfos(SidTune sidTune) {
            block2: {
                Iterator<String> iterator;
                StatusBar.this.playerId.setLength(0);
                StatusBar.this.playerinfos.setLength(0);
                if (sidTune == SidTune.RESET || !(iterator = sidTune.identify().iterator()).hasNext()) break block2;
                String id = iterator.next();
                StatusBar.this.playerId.append(", ");
                StatusBar.this.playerId.append(StatusBar.this.util.getBundle().getString("PLAYER_ID")).append(": ").append(id);
                SidIdInfo.PlayerInfoSection playerInfo = sidTune.getPlayerInfo(id);
                StatusBar.this.statusLbl.setUserData(null);
                if (playerInfo != null) {
                    StatusBar.this.playerinfos.append(playerInfo.toString()).append("\n");
                    StatusBar.this.statusLbl.setUserData((Object)playerInfo.getReference());
                }
                StatusBar.this.playerId.setLength(StatusBar.this.playerId.length() - (id.length() - Math.min(id.length(), 14)));
                if (id.length() > 14) {
                    StatusBar.this.playerId.append("...");
                }
            }
        }
    }
}

