/*
 * Decompiled with CFR 0.152.
 */
package ui.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import libsidutils.fingerprinting.rest.FingerPrintingDataSource;
import libsidutils.fingerprinting.rest.beans.HashBeans;
import libsidutils.fingerprinting.rest.beans.IdBean;
import libsidutils.fingerprinting.rest.beans.IntArrayBean;
import libsidutils.fingerprinting.rest.beans.MusicInfoBean;
import libsidutils.fingerprinting.rest.beans.SongNoBean;
import server.restful.common.ContentTypeAndFileExtensions;

public class FingerprintingClient
implements FingerPrintingDataSource {
    private String url;
    private String username;
    private String password;
    private int connectionTimeout;
    private boolean useXml;

    public FingerprintingClient(String url, String username, String password, int connectionTimeout) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.connectionTimeout = connectionTimeout;
    }

    public void setUseXml(boolean useXml) {
        this.useXml = useXml;
    }

    @Override
    public IdBean insertTune(MusicInfoBean musicInfoBean) {
        try {
            HttpURLConnection connection = this.send(musicInfoBean, MusicInfoBean.class, "/insert-tune", "PUT");
            if (connection.getResponseCode() == 200) {
                return this.receive(IdBean.class, connection);
            }
            throw new IOException(connection.getURL() + "\nResponseCode: " + connection.getResponseCode());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void insertHashes(HashBeans hashBeans) {
        try {
            HttpURLConnection connection = this.send(hashBeans, HashBeans.class, "/insert-hashes", "PUT");
            if (connection.getResponseCode() == 200) {
                return;
            }
            throw new IOException(connection.getURL() + "\nResponseCode: " + connection.getResponseCode());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HashBeans findHashes(IntArrayBean intArray) {
        try {
            HttpURLConnection connection = this.send(intArray, IntArrayBean.class, "/hash", "POST");
            if (connection.getResponseCode() == 200) {
                return this.receive(HashBeans.class, connection);
            }
            throw new IOException(connection.getURL() + "\nResponseCode: " + connection.getResponseCode());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MusicInfoBean findTune(SongNoBean songNoBean) {
        try {
            HttpURLConnection connection = this.send(songNoBean, SongNoBean.class, "/tune", "POST");
            if (connection.getResponseCode() == 200) {
                return this.receive(MusicInfoBean.class, connection);
            }
            throw new IOException(connection.getURL() + "\nResponseCode: " + connection.getResponseCode());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean tuneExists(MusicInfoBean musicInfoBean) {
        try {
            HttpURLConnection connection = this.send(musicInfoBean, MusicInfoBean.class, "/tune-exists", "POST");
            if (connection.getResponseCode() == 200) {
                return this.receive(Boolean.class, connection);
            }
            throw new IOException(connection.getURL() + "\nResponseCode: " + connection.getResponseCode());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> HttpURLConnection send(T parameter, Class<T> tClass, String requestPath, String requestMethod) throws MalformedURLException, IOException, ProtocolException, JAXBException, URISyntaxException {
        HttpURLConnection connection = (HttpURLConnection)new URI(this.url + requestPath).toURL().openConnection();
        connection.setConnectTimeout(this.connectionTimeout);
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(requestMethod);
        connection.setRequestProperty("Authorization", "BASIC " + Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8)));
        if (this.useXml) {
            connection.setRequestProperty("Content-Type", ContentTypeAndFileExtensions.MIME_TYPE_XML.toString());
            connection.setRequestProperty("Accept", ContentTypeAndFileExtensions.MIME_TYPE_XML.getMimeType());
            JAXBContext.newInstance((Class[])new Class[]{tClass}).createMarshaller().marshal(parameter, connection.getOutputStream());
        } else {
            connection.setRequestProperty("Content-Type", ContentTypeAndFileExtensions.MIME_TYPE_JSON.toString());
            connection.setRequestProperty("Accept", ContentTypeAndFileExtensions.MIME_TYPE_JSON.getMimeType());
            connection.getOutputStream().write(new ObjectMapper().writeValueAsBytes(parameter));
        }
        connection.getOutputStream().flush();
        return connection;
    }

    private <T> T receive(Class<T> theClass, HttpURLConnection connection) {
        try {
            if (connection.getContentLength() == 0) {
                T t = null;
                return t;
            }
            Object obj = this.useXml ? JAXBContext.newInstance((Class[])new Class[]{theClass}).createUnmarshaller().unmarshal(connection.getInputStream()) : new ObjectMapper().readValue(connection.getInputStream(), theClass);
            if (theClass.isInstance(obj)) {
                Object object = obj;
                return (T)object;
            }
            T t = null;
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            connection.disconnect();
        }
    }
}

