#include "Math.h"
#include "Object.h"
#include "ArithmeticException.h"
#include "../../org/teavm/runtime/Allocator.h"
#include "../../org/teavm/runtime/ExceptionHandling.h"
#include "../../../strings.h"

double meth_jl_Math_log10(double teavm_local_1) {
    return (log(teavm_local_1) / 0x1.26bb1bbb55516p1);
}
double meth_jl_Math_pow(double teavm_local_1, double teavm_local_2) {
    return pow(teavm_local_1, teavm_local_2);
}
int32_t meth_jl_Math_round(float teavm_local_1) {
    int32_t teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(0));
    teavm_local_2 = ((int32_t) (teavm_local_1 + (TEAVM_WITH_CALL_SITE_ID(23547, meth_jl_Math_signum(teavm_local_1)) * 0x1.0p-1f)));
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
int64_t meth_jl_Math_floorDiv(int64_t teavm_local_1, int32_t teavm_local_2) {
    int64_t teavm_local_3;
    TEAVM_ALLOC_STACK(INT32_C(0));
    teavm_local_3 = TEAVM_WITH_CALL_SITE_ID(23548, meth_jl_Math_floorDiv_0(teavm_local_1, ((int64_t) teavm_local_2)));
    TEAVM_RELEASE_STACK;
    return teavm_local_3;
}
int64_t meth_jl_Math_floorDiv_0(int64_t teavm_local_1, int64_t teavm_local_2) {
    int64_t teavm_local_3;
    teavm_local_3 = (teavm_local_1 / teavm_local_2);
    if ((((teavm_local_1 ^ teavm_local_2) < INT64_C(0)) && ((teavm_local_3 * teavm_local_2) != teavm_local_1))) {
        teavm_local_3 = (teavm_local_3 - INT64_C(1));
    }
    return teavm_local_3;
}
int32_t meth_jl_Math_floorMod(int64_t teavm_local_1, int32_t teavm_local_2) {
    int32_t teavm_local_3;
    TEAVM_ALLOC_STACK(INT32_C(0));
    teavm_local_3 = ((int32_t) TEAVM_WITH_CALL_SITE_ID(23549, meth_jl_Math_floorMod_0(teavm_local_1, ((int64_t) teavm_local_2))));
    TEAVM_RELEASE_STACK;
    return teavm_local_3;
}
int64_t meth_jl_Math_floorMod_0(int64_t teavm_local_1, int64_t teavm_local_2) {
    int64_t teavm_local_3;
    teavm_local_3 = (teavm_local_1 % teavm_local_2);
    if ((((teavm_local_1 ^ teavm_local_2) < INT64_C(0)) && (teavm_local_3 != INT64_C(0)))) {
        teavm_local_3 = (teavm_local_3 + teavm_local_2);
    }
    return teavm_local_3;
}
int64_t meth_jl_Math_addExact(int64_t teavm_local_1, int64_t teavm_local_2) {
    int64_t teavm_local_3;
    void* teavm_local_4;
    TEAVM_ALLOC_STACK(INT32_C(1));
    teavm_local_3 = (teavm_local_1 + teavm_local_2);
    if ((((teavm_local_1 ^ teavm_local_3) < INT64_C(0)) && ((teavm_local_1 ^ teavm_local_2) >= INT64_C(0)))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_4 = TEAVM_WITH_CALL_SITE_ID(23550, meth_otr_Allocator_allocate(&jl_ArithmeticException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_4);
        TEAVM_WITH_CALL_SITE_ID(23551, meth_jl_ArithmeticException__init__0(teavm_local_4));
        TEAVM_WITH_CALL_SITE_ID(23552, meth_otr_ExceptionHandling_throwException(teavm_local_4));
        TEAVM_UNREACHABLE
    }
    TEAVM_RELEASE_STACK;
    return teavm_local_3;
}
int64_t meth_jl_Math_multiplyExact(int64_t teavm_local_1, int32_t teavm_local_2) {
    int64_t teavm_local_3;
    TEAVM_ALLOC_STACK(INT32_C(0));
    teavm_local_3 = TEAVM_WITH_CALL_SITE_ID(23553, meth_jl_Math_multiplyExact_0(teavm_local_1, ((int64_t) teavm_local_2)));
    TEAVM_RELEASE_STACK;
    return teavm_local_3;
}
int64_t meth_jl_Math_multiplyExact_0(int64_t teavm_local_1, int64_t teavm_local_2) {
    int64_t teavm_local_3;
    void* teavm_local_4;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if ((teavm_local_2 != INT64_C(1))) {
        if ((teavm_local_1 == INT64_C(1))) {
            teavm_local_1 = teavm_local_2;
        } else if (((teavm_local_1 != INT64_C(0)) && (teavm_local_2 != INT64_C(0)))) {
            teavm_local_3 = (teavm_local_1 * teavm_local_2);
            if (((teavm_local_1 == (int64_t) INT64_C(0x8000000000000000)) && (teavm_local_2 == -INT64_C(1)))) {
                goto teavm_label_1;
            }
            if (((teavm_local_2 == (int64_t) INT64_C(0x8000000000000000)) && (teavm_local_1 == -INT64_C(1)))) {
                goto teavm_label_1;
            }
            if (((teavm_local_3 / teavm_local_2) != teavm_local_1)) {
                goto teavm_label_1;
            }
            teavm_local_1 = teavm_local_3;
        } else {
            teavm_local_1 = INT64_C(0);
        }
    }
    TEAVM_RELEASE_STACK;
    return teavm_local_1;
teavm_label_1:;
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    teavm_local_4 = TEAVM_WITH_CALL_SITE_ID(23554, meth_otr_Allocator_allocate(&jl_ArithmeticException_Cls));
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_4);
    TEAVM_WITH_CALL_SITE_ID(23555, meth_jl_ArithmeticException__init__0(teavm_local_4));
    TEAVM_WITH_CALL_SITE_ID(23556, meth_otr_ExceptionHandling_throwException(teavm_local_4));
    TEAVM_UNREACHABLE
}
double meth_jl_Math_random() {
    return teavm_rand();
}
int32_t meth_jl_Math_min(int32_t teavm_local_1, int32_t teavm_local_2) {
    if ((teavm_local_1 < teavm_local_2)) {
        teavm_local_2 = teavm_local_1;
    }
    return teavm_local_2;
}
int32_t meth_jl_Math_max(int32_t teavm_local_1, int32_t teavm_local_2) {
    if ((teavm_local_1 > teavm_local_2)) {
        teavm_local_2 = teavm_local_1;
    }
    return teavm_local_2;
}
double meth_jl_Math_min_0(double teavm_local_1, double teavm_local_2) {
    if ((teavm_local_1 != teavm_local_1)) {
        return teavm_local_1;
    }
    if (((teavm_local_1 == 0.0) && ((teavm_local_2 == 0.0) && ((1.0 / teavm_local_2) == -INFINITY)))) {
        return teavm_local_2;
    }
    if ((teavm_local_1 <= teavm_local_2)) {
        teavm_local_2 = teavm_local_1;
    }
    return teavm_local_2;
}
double meth_jl_Math_max_0(double teavm_local_1, double teavm_local_2) {
    if ((teavm_local_1 != teavm_local_1)) {
        return teavm_local_1;
    }
    if (((teavm_local_1 == 0.0) && ((teavm_local_2 == 0.0) && ((1.0 / teavm_local_1) == -INFINITY)))) {
        return teavm_local_2;
    }
    if ((teavm_local_1 >= teavm_local_2)) {
        teavm_local_2 = teavm_local_1;
    }
    return teavm_local_2;
}
int32_t meth_jl_Math_abs(int32_t teavm_local_1) {
    if ((teavm_local_1 < INT32_C(0))) {
        teavm_local_1 = (-teavm_local_1);
    }
    return teavm_local_1;
}
int64_t meth_jl_Math_abs_1(int64_t teavm_local_1) {
    if ((teavm_local_1 < INT64_C(0))) {
        teavm_local_1 = (-teavm_local_1);
    }
    return teavm_local_1;
}
double meth_jl_Math_abs_0(double teavm_local_1) {
    double teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(0));
    teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(23557, fabs(teavm_local_1));
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
float meth_jl_Math_signum(float teavm_local_1) {
    int32_t teavm_local_2;
    if (isnan(((double) teavm_local_1))) {
        return teavm_local_1;
    }
    teavm_local_2 = teavm_compare_float(teavm_local_1, 0.0f);
    if ((teavm_local_2 < INT32_C(0))) {
        teavm_local_1 = -1.0f;
    } else if ((teavm_local_2 > INT32_C(0))) {
        teavm_local_1 = 1.0f;
    }
    return teavm_local_1;
}
int32_t supertypeof_jl_Math(TeaVM_Class* cls) {
    int32_t tag = cls->tag;
    if (tag < 1601 || tag >= 1603) return INT32_C(0);
    return INT32_C(1);
}
alignas(8) jl_Math_VT jl_Math_Cls = {
    .parent = {
        .parent = {
            .size = (int32_t) (intptr_t) TEAVM_ALIGN(sizeof(cls_jl_Math), sizeof(void*)),
            .flags = 2048,
            .tag = 1601,
            .canary = 0,
            .name = NULL,
            .simpleName = NULL,
            .arrayType = NULL,
            .itemType = NULL,
            .isSupertypeOf = &supertypeof_jl_Math,
            .superclass = (TeaVM_Class*) &jl_Object_Cls,
            .superinterfaceCount = 0,
            .superinterfaces = NULL,
            .layout = NULL,
            .enumValues = NULL,
            .declaringClass = NULL,
            .enclosingClass = NULL,
            .init = NULL
        },
        .virt_hashCode = &meth_jl_Object_hashCode,
        .virt_equals = &meth_jl_Object_equals,
        .virt_clone = &meth_jl_Object_clone,
        .virt_toString = &meth_jl_Object_toString,
        .virt_isEmptyMonitor = &meth_jl_Object_isEmptyMonitor,
        .virt_getClass = &meth_jl_Object_getClass,
        .virt_identity = &meth_jl_Object_identity
    }
};
void sysinitclass_jl_Math() {
}
