/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.psid64;

import java.util.Iterator;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneInfo;
import libsidutils.CBMCodeUtils;

public class Screen {
    private static final String PACKAGE = "PSID64";
    private static final String VERSION = "0.9";
    private static final int WIDTH = 40;
    private static final int HEIGHT = 25;
    private static final int SCREEN_SIZE = 1000;
    private byte[] screen = new byte[1000];
    private int x;
    private int y;

    public Screen(SidTuneInfo tuneInfo) {
        this.clear();
        this.move(5, 1);
        this.write("PSID64 v0.9 by Roland Hermans!");
        this.poke(4, 0, 112);
        this.poke(35, 0, 110);
        this.poke(4, 1, 93);
        this.poke(35, 1, 93);
        this.poke(4, 2, 109);
        this.poke(35, 2, 125);
        for (int i = 0; i < 30; ++i) {
            this.poke(5 + i, 0, 64);
            this.poke(5 + i, 2, 64);
        }
        this.move(0, 4);
        this.write("Name   : ");
        Iterator<String> descriptionIt = tuneInfo.getInfoString().iterator();
        if (descriptionIt.hasNext()) {
            String title = descriptionIt.next();
            this.write(title.substring(0, Math.min(title.length(), 31)));
        }
        this.write("\nAuthor : ");
        if (descriptionIt.hasNext()) {
            String author = descriptionIt.next();
            this.write(author.substring(0, Math.min(author.length(), 31)));
        }
        this.write("\nRelease: ");
        if (descriptionIt.hasNext()) {
            String released = descriptionIt.next();
            this.write(released.substring(0, Math.min(released.length(), 31)));
        }
        this.write(String.format("\nLoad   : $%04x-$%04x", tuneInfo.getLoadAddr(), tuneInfo.getLoadAddr() + tuneInfo.getC64dataLen()));
        this.write(String.format("\nInit   : $%04x", tuneInfo.getInitAddr()));
        this.write("\nPlay   : ");
        if (tuneInfo.getPlayAddr() != 0) {
            this.write(String.format("$%04x", tuneInfo.getPlayAddr()));
        } else {
            this.write("N/A");
        }
        this.write("\nSongs  : ");
        this.write(String.format("%d", tuneInfo.getSongs()));
        if (tuneInfo.getSongs() > 1) {
            this.write(" (now playing");
        }
        boolean hasFlags = false;
        this.write("\nFlags  : ");
        if (tuneInfo.getCompatibility() == SidTune.Compatibility.PSIDv1) {
            hasFlags = this.addFlag(hasFlags, "PlaySID");
        }
        hasFlags = this.addFlag(hasFlags, tuneInfo.getClockSpeed().toString());
        hasFlags = this.addFlag(hasFlags, tuneInfo.getSIDModel(0).toString());
        int sid2midNibbles = tuneInfo.getSIDChipBase(1) >> 4 & 0xFF;
        if ((sid2midNibbles & 1) == 0 && (66 <= sid2midNibbles && sid2midNibbles <= 126 || 224 <= sid2midNibbles && sid2midNibbles <= 254)) {
            hasFlags = this.addFlag(hasFlags, tuneInfo.getSIDModel(1).toString() + String.format(" at $%04x", tuneInfo.getSIDChipBase(1)));
        }
        if (!hasFlags) {
            this.write("-");
        }
        this.write("\nClock  :   :  :");
        this.write("\n\n  ");
        if (tuneInfo.getSongs() <= 1) {
            this.write("   [1");
        } else if (tuneInfo.getSongs() <= 10) {
            this.write("  [1-");
            this.putchar(tuneInfo.getSongs() % 10 + 48);
        } else if (tuneInfo.getSongs() <= 11) {
            this.write(" [1-0, A");
        } else {
            this.write("[1-0, A-");
            this.putchar(tuneInfo.getSongs() <= 36 ? tuneInfo.getSongs() - 11 + 65 : 90);
        }
        this.write("] Select song [+] Next song\n");
        this.write("  [-] Previous song [DEL] Blank screen\n");
        if (tuneInfo.getPlayAddr() != 0) {
            this.write("[~] Fast forward [LOCK] Show raster time\n");
        }
        this.write("  [RUN/STOP] Stop [CTRL+CBM+DEL] Reset\n");
        this.move(1, 24);
        this.write("Website: http://psid64.sourceforge.net");
    }

    private boolean addFlag(boolean hasFlags, String flagName) {
        if (hasFlags) {
            this.write(", ");
        } else {
            hasFlags = true;
        }
        this.write(flagName);
        return hasFlags;
    }

    private void clear() {
        for (int i = 0; i < 1000; ++i) {
            this.screen[i] = CBMCodeUtils.iso88591ToScreenRam(' ');
        }
    }

    private void move(int x, int y) {
        if (x < 40 && y < 25) {
            this.x = x;
            this.y = y;
        }
    }

    private void putchar(int c) {
        if (c == 10) {
            this.x = 0;
            this.moveDown();
        } else {
            int offs = this.offset(this.x, this.y);
            this.screen[offs] = CBMCodeUtils.iso88591ToScreenRam((char)c);
            this.moveRight();
        }
    }

    private void write(String str) {
        for (int i = 0; i < str.length(); ++i) {
            this.putchar(str.charAt(i));
        }
    }

    private void poke(int x, int y, int value) {
        if (x < 40 && y < 25) {
            int offs = this.offset(x, y);
            this.screen[offs] = (byte)(value & 0xFF);
        }
    }

    public final byte[] getData() {
        return this.screen;
    }

    public int getDataSize() {
        return 1000;
    }

    private void moveRight() {
        if (this.x < 39) {
            ++this.x;
        }
    }

    private void moveDown() {
        if (this.y < 24) {
            ++this.y;
        }
    }

    private int offset(int x, int y) {
        return x + 40 * y;
    }
}

