/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Convert;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import libsidplay.config.ISidPlay2Section;
import sidplay.ini.IniDefaults;
import sidplay.ini.converter.BeanToStringConverter;
import ui.common.converter.FileAttributeConverter;
import ui.common.converter.FileToStringDeserializer;
import ui.common.converter.FileToStringSerializer;
import ui.common.converter.FileXmlAdapter;
import ui.common.properties.ShadowField;
import ui.favorites.PlaybackType;

@Embeddable
public class SidPlay2Section
implements ISidPlay2Section {
    public static final PlaybackType DEFAULT_PLAYBACK_TYPE = PlaybackType.PLAYBACK_OFF;
    public static final boolean DEFAULT_PROXY_ENABLE = false;
    public static final String DEFAULT_PROXY_HOSTNAME = null;
    public static final int DEFAULT_PROXY_PORT = 80;
    public static final int DEFAULT_FRAME_X = 0;
    public static final int DEFAULT_FRAME_Y = 0;
    public static final int DEFAULT_FRAME_WIDTH = 1310;
    public static final int DEFAULT_FRAME_HEIGHT = 1024;
    public static final boolean DEFAULT_MINIMIZED = false;
    public static final float DEFAULT_VIDEO_SCALING = 1.75f;
    public static final boolean DEFAULT_SHOW_MONITOR = true;
    public static final boolean DEFAULT_PLAY_LIST_STARTS_WITH_ONE = true;
    private int version;
    private ShadowField<BooleanProperty, Boolean> enableDatabase = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_ENABLE_DATABASE);
    private ShadowField<DoubleProperty, Number> startTime = new ShadowField<DoubleProperty, Double>(number -> new SimpleDoubleProperty(number.doubleValue()), IniDefaults.DEFAULT_START_TIME);
    private ShadowField<DoubleProperty, Number> defaultPlayLength = new ShadowField<DoubleProperty, Double>(number -> new SimpleDoubleProperty(number.doubleValue()), IniDefaults.DEFAULT_PLAY_LENGTH);
    private ShadowField<DoubleProperty, Number> fadeInTime = new ShadowField<DoubleProperty, Double>(number -> new SimpleDoubleProperty(number.doubleValue()), IniDefaults.DEFAULT_FADE_IN_TIME);
    private ShadowField<DoubleProperty, Number> fadeOutTime = new ShadowField<DoubleProperty, Double>(number -> new SimpleDoubleProperty(number.doubleValue()), IniDefaults.DEFAULT_FADE_OUT_TIME);
    private ShadowField<ObjectProperty<PlaybackType>, PlaybackType> playbackType = new ShadowField<ObjectProperty, PlaybackType>(SimpleObjectProperty::new, DEFAULT_PLAYBACK_TYPE);
    private ShadowField<BooleanProperty, Boolean> loop = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_LOOP);
    private ShadowField<BooleanProperty, Boolean> single = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_SINGLE_TRACK);
    private ShadowField<BooleanProperty, Boolean> playListStartsWithOne = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, true);
    private ShadowField<ObjectProperty<File>, File> hvmec = new ShadowField<ObjectProperty, Object>(SimpleObjectProperty::new, null);
    private ShadowField<ObjectProperty<File>, File> demos = new ShadowField<ObjectProperty, Object>(SimpleObjectProperty::new, null);
    private ShadowField<ObjectProperty<File>, File> mags = new ShadowField<ObjectProperty, Object>(SimpleObjectProperty::new, null);
    private ShadowField<ObjectProperty<File>, File> cgsc = new ShadowField<ObjectProperty, Object>(SimpleObjectProperty::new, null);
    private ShadowField<ObjectProperty<File>, File> hvsc = new ShadowField<ObjectProperty, Object>(SimpleObjectProperty::new, null);
    private ShadowField<ObjectProperty<File>, File> gameBase64 = new ShadowField<ObjectProperty, Object>(SimpleObjectProperty::new, null);
    private ShadowField<BooleanProperty, Boolean> proxyEnable = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, false);
    private ShadowField<StringProperty, String> proxyHostname = new ShadowField<StringProperty, String>(SimpleStringProperty::new, DEFAULT_PROXY_HOSTNAME);
    private ShadowField<ObjectProperty<Integer>, Integer> proxyPort = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, 80);
    private ShadowField<ObjectProperty<File>, File> lastDirectory = new ShadowField<ObjectProperty, Object>(SimpleObjectProperty::new, null);
    private ShadowField<ObjectProperty<File>, File> tmpDir = new ShadowField<ObjectProperty, File>(SimpleObjectProperty::new, IniDefaults.DEFAULT_TMP_DIR);
    private ShadowField<DoubleProperty, Number> frameX = new ShadowField<DoubleProperty, Integer>(number -> new SimpleDoubleProperty(number.doubleValue()), 0);
    private ShadowField<DoubleProperty, Number> frameY = new ShadowField<DoubleProperty, Integer>(number -> new SimpleDoubleProperty(number.doubleValue()), 0);
    private ShadowField<DoubleProperty, Number> frameWidth = new ShadowField<DoubleProperty, Integer>(number -> new SimpleDoubleProperty(number.doubleValue()), 1310);
    private ShadowField<DoubleProperty, Number> frameHeight = new ShadowField<DoubleProperty, Integer>(number -> new SimpleDoubleProperty(number.doubleValue()), 1024);
    private ShadowField<BooleanProperty, Boolean> minimized = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, false);
    private ShadowField<DoubleProperty, Number> minimizedX = new ShadowField<DoubleProperty, Integer>(number -> new SimpleDoubleProperty(number.doubleValue()), 0);
    private ShadowField<DoubleProperty, Number> minimizedY = new ShadowField<DoubleProperty, Integer>(number -> new SimpleDoubleProperty(number.doubleValue()), 0);
    private ShadowField<DoubleProperty, Number> minimizedWidth = new ShadowField<DoubleProperty, Integer>(number -> new SimpleDoubleProperty(number.doubleValue()), 0);
    private ShadowField<DoubleProperty, Number> minimizedHeight = new ShadowField<DoubleProperty, Integer>(number -> new SimpleDoubleProperty(number.doubleValue()), 0);
    private ShadowField<FloatProperty, Number> videoScaling = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(1.75f));
    private ShadowField<ObjectProperty<Boolean>, Boolean> showMonitor = new ShadowField<ObjectProperty, Boolean>(SimpleObjectProperty::new, true);
    private ShadowField<BooleanProperty, Boolean> palEmulation = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_PAL_EMULATION);
    private ShadowField<FloatProperty, Number> brightness = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_BRIGHTNESS));
    private ShadowField<FloatProperty, Number> contrast = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_CONTRAST));
    private ShadowField<FloatProperty, Number> gamma = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_GAMMA));
    private ShadowField<FloatProperty, Number> saturation = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_SATURATION));
    private ShadowField<FloatProperty, Number> phaseShift = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_PHASE_SHIFT));
    private ShadowField<FloatProperty, Number> offset = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_OFFSET));
    private ShadowField<FloatProperty, Number> tint = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_TINT));
    private ShadowField<FloatProperty, Number> blur = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_BLUR));
    private ShadowField<FloatProperty, Number> bleed = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_BLEED));
    private ShadowField<BooleanProperty, Boolean> turboTape = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_TURBO_TAPE);

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public boolean isEnableDatabase() {
        return this.enableDatabase.get();
    }

    @Override
    public void setEnableDatabase(boolean isEnableDatabase) {
        this.enableDatabase.set(isEnableDatabase);
    }

    public final BooleanProperty enableDatabaseProperty() {
        return this.enableDatabase.property();
    }

    @Override
    public double getStartTime() {
        return this.startTime.get().doubleValue();
    }

    @Override
    public void setStartTime(double startTime) {
        this.startTime.set(startTime);
    }

    public final DoubleProperty startTimeProperty() {
        return this.startTime.property();
    }

    @Override
    public double getDefaultPlayLength() {
        return this.defaultPlayLength.get().doubleValue();
    }

    @Override
    public void setDefaultPlayLength(double defaultPlayLength) {
        this.defaultPlayLength.set(defaultPlayLength);
    }

    public final DoubleProperty defaultPlayLengthProperty() {
        return this.defaultPlayLength.property();
    }

    @Override
    public double getFadeInTime() {
        return this.fadeInTime.get().doubleValue();
    }

    @Override
    public void setFadeInTime(double fadeInTime) {
        this.fadeInTime.set(fadeInTime);
    }

    public final DoubleProperty fadeInTimeProperty() {
        return this.fadeInTime.property();
    }

    @Override
    public double getFadeOutTime() {
        return this.fadeOutTime.get().doubleValue();
    }

    @Override
    public void setFadeOutTime(double fadeOutTime) {
        this.fadeOutTime.set(fadeOutTime);
    }

    public final DoubleProperty fadeOutTimeProperty() {
        return this.fadeOutTime.property();
    }

    @Enumerated(value=EnumType.STRING)
    public PlaybackType getPlaybackType() {
        return this.playbackType.get();
    }

    public void setPlaybackType(PlaybackType playbackType) {
        this.playbackType.set(playbackType);
    }

    public final ObjectProperty<PlaybackType> playbackTypeProperty() {
        return this.playbackType.property();
    }

    @Override
    public boolean isLoop() {
        return this.loop.get();
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop.set(loop);
    }

    public final BooleanProperty loopProperty() {
        return this.loop.property();
    }

    @Override
    public boolean isSingle() {
        return this.single.get();
    }

    @Override
    public void setSingle(boolean isSingle) {
        this.single.set(isSingle);
    }

    public final BooleanProperty singleProperty() {
        return this.single.property();
    }

    public boolean isPlayListStartsWithOne() {
        return this.playListStartsWithOne.get();
    }

    public void setPlayListStartsWithOne(boolean playListStartsWithOne) {
        this.playListStartsWithOne.set(playListStartsWithOne);
    }

    public final BooleanProperty playListStartsWithOneProperty() {
        return this.playListStartsWithOne.property();
    }

    @Convert(converter=FileAttributeConverter.class)
    @XmlJavaTypeAdapter(value=FileXmlAdapter.class)
    @JsonSerialize(using=FileToStringSerializer.class)
    @JsonDeserialize(using=FileToStringDeserializer.class)
    public File getHVMEC() {
        return this.hvmec.get();
    }

    public void setHVMEC(File hVMEC) {
        this.hvmec.set(hVMEC);
    }

    public final ObjectProperty<File> hvmecProperty() {
        return this.hvmec.property();
    }

    @Convert(converter=FileAttributeConverter.class)
    @XmlJavaTypeAdapter(value=FileXmlAdapter.class)
    @JsonSerialize(using=FileToStringSerializer.class)
    @JsonDeserialize(using=FileToStringDeserializer.class)
    public File getDemos() {
        return this.demos.get();
    }

    public void setDemos(File demos) {
        this.demos.set(demos);
    }

    public final ObjectProperty<File> demosProperty() {
        return this.demos.property();
    }

    @Convert(converter=FileAttributeConverter.class)
    @XmlJavaTypeAdapter(value=FileXmlAdapter.class)
    @JsonSerialize(using=FileToStringSerializer.class)
    @JsonDeserialize(using=FileToStringDeserializer.class)
    public File getMags() {
        return this.mags.get();
    }

    public void setMags(File mags) {
        this.mags.set(mags);
    }

    public final ObjectProperty<File> magsProperty() {
        return this.mags.property();
    }

    @Convert(converter=FileAttributeConverter.class)
    @XmlJavaTypeAdapter(value=FileXmlAdapter.class)
    @JsonSerialize(using=FileToStringSerializer.class)
    @JsonDeserialize(using=FileToStringDeserializer.class)
    public File getCgsc() {
        return this.cgsc.get();
    }

    public void setCgsc(File cgsc) {
        this.cgsc.set(cgsc);
    }

    public final ObjectProperty<File> cgscProperty() {
        return this.cgsc.property();
    }

    @Override
    @Convert(converter=FileAttributeConverter.class)
    @XmlJavaTypeAdapter(value=FileXmlAdapter.class)
    @JsonSerialize(using=FileToStringSerializer.class)
    @JsonDeserialize(using=FileToStringDeserializer.class)
    public File getHvsc() {
        return this.hvsc.get();
    }

    @Override
    public void setHvsc(File hvsc) {
        this.hvsc.set(hvsc);
    }

    public final ObjectProperty<File> hvscProperty() {
        return this.hvsc.property();
    }

    @Convert(converter=FileAttributeConverter.class)
    @XmlJavaTypeAdapter(value=FileXmlAdapter.class)
    @JsonSerialize(using=FileToStringSerializer.class)
    @JsonDeserialize(using=FileToStringDeserializer.class)
    public File getGameBase64() {
        return this.gameBase64.get();
    }

    public void setGameBase64(File gameBase64) {
        this.gameBase64.set(gameBase64);
    }

    public final ObjectProperty<File> gameBase64Property() {
        return this.gameBase64.property();
    }

    public boolean isProxyEnable() {
        return this.proxyEnable.get();
    }

    public void setProxyEnable(boolean isProxyEnable) {
        this.proxyEnable.set(isProxyEnable);
    }

    public final BooleanProperty proxyEnableProperty() {
        return this.proxyEnable.property();
    }

    public String getProxyHostname() {
        return this.proxyHostname.get();
    }

    public void setProxyHostname(String hostname) {
        this.proxyHostname.set(hostname);
    }

    public final StringProperty proxyHostnameProperty() {
        return this.proxyHostname.property();
    }

    public int getProxyPort() {
        return this.proxyPort.get();
    }

    public void setProxyPort(int port) {
        this.proxyPort.set(port);
    }

    public final ObjectProperty<Integer> proxyPortProperty() {
        return this.proxyPort.property();
    }

    @Override
    @Convert(converter=FileAttributeConverter.class)
    @XmlJavaTypeAdapter(value=FileXmlAdapter.class)
    @JsonSerialize(using=FileToStringSerializer.class)
    @JsonDeserialize(using=FileToStringDeserializer.class)
    public File getLastDirectory() {
        return this.lastDirectory.get();
    }

    @Override
    public void setLastDirectory(File lastDirectory) {
        this.lastDirectory.set(lastDirectory);
    }

    public final ObjectProperty<File> lastDirectoryProperty() {
        return this.lastDirectory.property();
    }

    @Override
    @Convert(converter=FileAttributeConverter.class)
    @XmlJavaTypeAdapter(value=FileXmlAdapter.class)
    @JsonSerialize(using=FileToStringSerializer.class)
    @JsonDeserialize(using=FileToStringDeserializer.class)
    public File getTmpDir() {
        return this.tmpDir.get();
    }

    @Override
    public void setTmpDir(File tmpDir) {
        this.tmpDir.set(tmpDir);
    }

    public final ObjectProperty<File> tmpDirProperty() {
        return this.tmpDir.property();
    }

    public double getFrameX() {
        return this.frameX.get().doubleValue();
    }

    public void setFrameX(double frameX) {
        this.frameX.set(frameX);
    }

    public final DoubleProperty frameXProperty() {
        return this.frameX.property();
    }

    public double getFrameY() {
        return this.frameY.get().doubleValue();
    }

    public void setFrameY(double frameY) {
        this.frameY.set(frameY);
    }

    public final DoubleProperty frameYProperty() {
        return this.frameY.property();
    }

    public double getFrameWidth() {
        return this.frameWidth.get().doubleValue();
    }

    public void setFrameWidth(double frameWidth) {
        this.frameWidth.set(frameWidth);
    }

    public final DoubleProperty frameWidthProperty() {
        return this.frameWidth.property();
    }

    public double getFrameHeight() {
        return this.frameHeight.get().doubleValue();
    }

    public void setFrameHeight(double frameHeight) {
        this.frameHeight.set(frameHeight);
    }

    public final DoubleProperty frameHeightProperty() {
        return this.frameHeight.property();
    }

    public boolean isMinimized() {
        return this.minimized.get();
    }

    public void setMinimized(boolean isMinimized) {
        this.minimized.set(isMinimized);
    }

    public final BooleanProperty minimizedProperty() {
        return this.minimized.property();
    }

    public double getMinimizedX() {
        return this.minimizedX.get().doubleValue();
    }

    public void setMinimizedX(double minimizedX) {
        this.minimizedX.set(minimizedX);
    }

    public final DoubleProperty minimizedXProperty() {
        return this.minimizedX.property();
    }

    public double getMinimizedY() {
        return this.minimizedY.get().doubleValue();
    }

    public void setMinimizedY(double minimizedY) {
        this.minimizedY.set(minimizedY);
    }

    public final DoubleProperty minimizedYProperty() {
        return this.minimizedY.property();
    }

    public double getMinimizedWidth() {
        return this.minimizedWidth.get().doubleValue();
    }

    public void setMinimizedWidth(double minimizedWidth) {
        this.minimizedWidth.set(minimizedWidth);
    }

    public final DoubleProperty minimizedWidthProperty() {
        return this.minimizedWidth.property();
    }

    public double getMinimizedHeight() {
        return this.minimizedHeight.get().doubleValue();
    }

    public void setMinimizedHeight(double minimizedHeight) {
        this.minimizedHeight.set(minimizedHeight);
    }

    public final DoubleProperty minimizedHeightProperty() {
        return this.minimizedHeight.property();
    }

    public float getVideoScaling() {
        return this.videoScaling.get().floatValue();
    }

    public void setVideoScaling(float videoScaling) {
        this.videoScaling.set(Float.valueOf(videoScaling));
    }

    public final FloatProperty videoScalingProperty() {
        return this.videoScaling.property();
    }

    public boolean isShowMonitor() {
        return this.showMonitor.get();
    }

    public void setShowMonitor(boolean showMonitor) {
        this.showMonitor.set(showMonitor);
    }

    public final ObjectProperty<Boolean> showMonitorProperty() {
        return this.showMonitor.property();
    }

    @Override
    public boolean isPalEmulation() {
        return this.palEmulation.get();
    }

    @Override
    public void setPalEmulation(boolean isPalEmulation) {
        this.palEmulation.set(isPalEmulation);
    }

    public final BooleanProperty palEmulationProperty() {
        return this.palEmulation.property();
    }

    @Override
    public float getBrightness() {
        return this.brightness.get().floatValue();
    }

    @Override
    public void setBrightness(float brightness) {
        this.brightness.set(Float.valueOf(brightness));
    }

    public final FloatProperty brightnessProperty() {
        return this.brightness.property();
    }

    @Override
    public float getContrast() {
        return this.contrast.get().floatValue();
    }

    @Override
    public void setContrast(float contrast) {
        this.contrast.set(Float.valueOf(contrast));
    }

    public final FloatProperty contrastProperty() {
        return this.contrast.property();
    }

    @Override
    public float getGamma() {
        return this.gamma.get().floatValue();
    }

    @Override
    public void setGamma(float gamma) {
        this.gamma.set(Float.valueOf(gamma));
    }

    public final FloatProperty gammaProperty() {
        return this.gamma.property();
    }

    @Override
    public float getSaturation() {
        return this.saturation.get().floatValue();
    }

    @Override
    public void setSaturation(float saturation) {
        this.saturation.set(Float.valueOf(saturation));
    }

    public final FloatProperty saturationProperty() {
        return this.saturation.property();
    }

    @Override
    public float getPhaseShift() {
        return this.phaseShift.get().floatValue();
    }

    @Override
    public void setPhaseShift(float phaseShift) {
        this.phaseShift.set(Float.valueOf(phaseShift));
    }

    public final FloatProperty phaseShiftProperty() {
        return this.phaseShift.property();
    }

    @Override
    public float getOffset() {
        return this.offset.get().floatValue();
    }

    @Override
    public void setOffset(float offset) {
        this.offset.set(Float.valueOf(offset));
    }

    public final FloatProperty offsetProperty() {
        return this.offset.property();
    }

    @Override
    public float getTint() {
        return this.tint.get().floatValue();
    }

    @Override
    public void setTint(float tint) {
        this.tint.set(Float.valueOf(tint));
    }

    public final FloatProperty tintProperty() {
        return this.tint.property();
    }

    @Override
    public float getBlur() {
        return this.blur.get().floatValue();
    }

    @Override
    public void setBlur(float blur) {
        this.blur.set(Float.valueOf(blur));
    }

    public final FloatProperty blurProperty() {
        return this.blur.property();
    }

    @Override
    public float getBleed() {
        return this.bleed.get().floatValue();
    }

    @Override
    public void setBleed(float bleed) {
        this.bleed.set(Float.valueOf(bleed));
    }

    public final FloatProperty bleedProperty() {
        return this.bleed.property();
    }

    @Override
    public boolean isTurboTape() {
        return this.turboTape.get();
    }

    @Override
    public void setTurboTape(boolean turboTape) {
        this.turboTape.set(turboTape);
    }

    public final BooleanProperty turboTapeProperty() {
        return this.turboTape.property();
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

