/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.rtmp;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TimerTask;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import libsidutils.IOUtils;
import org.apache.catalina.Context;
import org.apache.juli.logging.Log;
import server.restful.common.IServletSystemProperties;
import server.restful.common.rtmp.PlayerWithStatus;
import server.restful.servlets.ConvertServlet;
import sidplay.Player;
import sidplay.filefilter.UUIDFileFilter;
import ui.common.ConvenienceResult;

public final class PlayerCleanupTimerTask
extends TimerTask {
    private static final Map<UUID, PlayerWithStatus> PLAYER_MAP = Collections.synchronizedMap(new HashMap());
    private static final UUIDFileFilter UUID_FILE_FILTER = new UUIDFileFilter();
    private final Log logger;
    private final File catalinaBaseFile;
    private int timerCounter;

    public PlayerCleanupTimerTask(Context context) {
        this.logger = context.getParent().getLogger();
        this.catalinaBaseFile = context.getCatalinaBase();
    }

    public static final void create(UUID uuid, Player player, File diskImage, ConvenienceResult convenienceResult, ConvertServlet.ConvertServletParameters servletParameters) {
        PLAYER_MAP.put(uuid, new PlayerWithStatus(player, diskImage, convenienceResult, servletParameters));
    }

    public static final void update(UUID uuid, Consumer<PlayerWithStatus> playerWithStatusConsumer) {
        Optional.ofNullable(PLAYER_MAP.get(uuid)).ifPresent(playerWithStatusConsumer);
    }

    public static final int count() {
        return PLAYER_MAP.size();
    }

    @Override
    public final void run() {
        Collection playerEntriesToRemove = PLAYER_MAP.entrySet().stream().filter(entrySet -> ((PlayerWithStatus)entrySet.getValue()).isInvalid()).collect(Collectors.toList());
        playerEntriesToRemove.forEach(this::quitPlayer);
        PLAYER_MAP.entrySet().removeAll(playerEntriesToRemove);
        if (this.timerCounter % IServletSystemProperties.ConvertServlet.RTMP_PRINT_PLAYER_PERIOD == 0) {
            PLAYER_MAP.entrySet().forEach(this::printPlayer);
        }
        if (this.timerCounter % IServletSystemProperties.ConvertServlet.CLEANUP_DIRECTORY_PERIOD == 0) {
            this.deleteOutdatedTempDirectories();
        }
        ++this.timerCounter;
    }

    private void quitPlayer(Map.Entry<UUID, PlayerWithStatus> entry) {
        this.logger.info((Object)String.format("CleanupPlayerTimerTask: AUTO-QUIT RTMP uuid=%s", entry.getKey()));
        entry.getValue().quitPlayer();
    }

    private void printPlayer(Map.Entry<UUID, PlayerWithStatus> entry) {
        this.logger.info((Object)String.format("CleanupPlayerTimerTask: RTMP is still running uuid=%s (valid until %s)", entry.getKey(), entry.getValue().getValidUntil()));
    }

    private void deleteOutdatedTempDirectories() {
        Arrays.asList(Optional.ofNullable(this.catalinaBaseFile.listFiles(UUID_FILE_FILTER)).orElse(new File[0])).stream().filter(File::isDirectory).forEach(dir -> {
            try {
                LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(dir.lastModified()), ZoneId.systemDefault());
                if (dateTime.plusSeconds(IServletSystemProperties.ConvertServlet.MAXIMUM_DURATION_TEMP_DIRECTORIES).isBefore(LocalDateTime.now())) {
                    this.logger.info((Object)String.format("CleanupPlayerTimerTask: Delete temp. directory: %s", dir));
                    IOUtils.deleteDirectory(dir);
                }
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage());
            }
        });
    }
}

