// https://minify-js.com/
const USB_INTERFACE=0,USB_PACKAGE_SIZE=512,WRITEBUFF_SIZE=USB_PACKAGE_SIZE,WRITEBUFF_SIZE_SYNC=2048,MAX_DEVCOUNT=4,READBUFF_SIZE=64,HW_BUFFBEG=8192,HW_BUFFSIZE=8192,HW_FILLRATIO=4096,VENDOR_ID=25985,HS4U_PRODUCT_ID=34176,HSUP_PRODUCT_ID=34177,HSUNO_PRODUCT_ID=34178,SHORTEST_DELAY=4,WState={OK:1,BUSY:2,ERROR:3},SysMode={UNDEF:0,SIDPLAY:1,VST:2},DevType={UNKNOWN:0,HS4U:1,HSUP:2,HSUNO:3};var initialized,error,sync,deviceCount,pkgCount,sysMode,lastRelaySwitch,devhandles=new Array(4),deviceTypes=new Array(4),writeBuffer=new Array(4),lastaccsids=new Array(4),buffChk=!0,bufferSize=WRITEBUFF_SIZE,playCursor=8192,circBuffCursor=8192;async function hardsid_usb_init(e,t,r){if(r!==SysMode.SIDPLAY)throw new Error("Only SIDPLAY mode currently supported!");if(!t)throw new Error("Only synchronous mode currently supported!");return bufferSize=(sync=t)?2048:WRITEBUFF_SIZE,initialized&&await hardsid_usb_close(),initialized=!0,error=!1,deviceCount=0,await addAllDevices(e),!error&&deviceCount>0&&(sync=!0,await hardsid_usb_setmode(0,r),sync=t),!1}async function hardsid_usb_close(){try{if(initialized){for(var e=0;e<deviceCount;e++){let t=devhandles[e];if(t===DevType.HSUP||deviceTypes[e]===DevType.HSUNO){for(;await hardsid_usb_delay(e,5e3)==WState.BUSY;);for(;await hardsid_usb_write_direct(e,240,6)==WState.BUSY;);for(;await hardsid_usb_delay(e,6e4)==WState.BUSY;);for(;await hardsid_usb_write_direct(e,240,7)==WState.BUSY;);for(;await hardsid_usb_flush(e)==WState.BUSY;);lastaccsids[e]=255}await t.releaseInterface(USB_INTERFACE),await t.close()}initialized=!1}}catch(e){console.log(e),e=!0}}function hardsid_usb_getdevcount(){return!initialized||error?0:deviceCount}function hardsid_usb_getsidcount(e){if(!initialized||error)return 0;switch(deviceTypes[e]){case DevType.HS4U:return 4;case DevType.HSUP:return 2;case DevType.HSUNO:return 1;default:return 0}}async function addAllDevices(e){try{return await openAllDevices(e),0!=deviceCount||(console.log("No devices"),error=!0,!1)}catch(e){return console.log("Error: "+e),e=!0,!1}}async function openAllDevices(e){if(device=void 0!==e?e:await navigator.usb.requestDevice({filters:[{vendorId:VENDOR_ID}]}),void 0!==device){console.log(`Product name: ${device.productName}, Product Id: ${device.productId.toString(16)}`);let e=getDevType(device);await device.open(),await device.selectConfiguration(1),await device.claimInterface(USB_INTERFACE),devhandles[deviceCount]=device,deviceTypes[deviceCount]=e,lastaccsids[deviceCount]=255,writeBuffer[deviceCount]=new Uint8Array,deviceCount++}}function getDevType(e){if(e.vendorId===VENDOR_ID)switch(e.productId){case HS4U_PRODUCT_ID:default:return DevType.HS4U;case HSUNO_PRODUCT_ID:return DevType.HSUNO;case HSUP_PRODUCT_ID:return DevType.HSUP}return DevType.UNKNOWN}async function hardsid_usb_readstate(e){if(!initialized||error||!sync)return WState.ERROR;let t=await devhandles[e].transferIn(1,READBUFF_SIZE);return"ok"!==t.status?(error=!0,WState.ERROR):(pkgCount=t.data.getUint8(24)|t.data.getUint8(25)<<8,playCursor=t.data.getUint8(26)|t.data.getUint8(27)<<8,circBuffCursor=t.data.getUint8(28)|t.data.getUint8(29)<<8,sysMode=t.data.getUint8(30)|t.data.getUint8(31)<<8,WState.OK)}async function hardsid_usb_sync(e){return initialized&&!error&&sync?await hardsid_usb_readstate(e)!=WState.OK?(error=!0,WState.ERROR):(playCursor<circBuffCursor?playCursor+HW_BUFFSIZE-circBuffCursor:playCursor>circBuffCursor?playCursor-circBuffCursor:HW_BUFFSIZE)<HW_FILLRATIO?WState.BUSY:WState.OK:WState.ERROR}async function hardsid_usb_write_internal(e){if(!initialized||error||0==writeBuffer[e].byteLength)return WState.ERROR;let t=parseInt((writeBuffer[e].byteLength-1)/USB_PACKAGE_SIZE+1,10)*USB_PACKAGE_SIZE;if(sync){for(var r=new Uint8Array(t),a=0;a<writeBuffer[e].byteLength;a++)r[a]=writeBuffer[e][a];writeBuffer[e]=new Uint8Array;let i=await devhandles[e].transferOut(2,r);if("ok"!==i.status||i.bytesWritten!=t)throw new Error("Sent error!")}else;return WState.OK}async function hardsid_usb_write_direct(e,t,r){if(!initialized||error)return WState.ERROR;if(sync&&writeBuffer[e].byteLength==bufferSize-2){let t=await hardsid_usb_sync(e);if(t!=WState.OK)return t}return writeBuffer[e]=concatenate(Uint8Array,writeBuffer[e],Uint8Array.of(255&r,255&t)),writeBuffer[e].byteLength==bufferSize?await hardsid_usb_write_internal(e):WState.OK}async function hardsid_usb_write(e,t,r){try{let a;switch(deviceTypes[e]){case DevType.HS4U:return await hardsid_usb_write_direct(e,t,r);case DevType.HSUP:if(0!=(192&t))return WState.ERROR;if(lastaccsids[e]!=(32&t)){for(lastaccsids[e]=32&t,a=0!=(32&t)?192:160;lastRelaySwitch>0&&(new Date).getMilliseconds()-lastRelaySwitch<250;);for(lastRelaySwitch=(new Date).getMilliseconds();await hardsid_usb_delay(e,4)==WState.BUSY;);for(;await hardsid_usb_write_direct(e,240,6)==WState.BUSY;);for(;await hardsid_usb_delay(e,6e4)==WState.BUSY;);for(;await hardsid_usb_write_direct(e,240,7)==WState.BUSY;);for(;await hardsid_usb_delay(e,3e4)==WState.BUSY;);for(;await hardsid_usb_write_direct(e,a,0)==WState.BUSY;);for(;await hardsid_usb_delay(e,3e4)==WState.BUSY;);for(;await hardsid_usb_write_direct(e,128,0)==WState.BUSY;);for(;await hardsid_usb_delay(e,3e4)==WState.BUSY;);for(;await hardsid_usb_write_direct(e,240,4)==WState.BUSY;);for(;await hardsid_usb_delay(e,6e4)==WState.BUSY;);for(;await hardsid_usb_write_direct(e,240,2)==WState.BUSY;);for(;await hardsid_usb_delay(e,10)==WState.BUSY;);for(;await hardsid_usb_flush(e)==WState.BUSY;);return await hardsid_usb_write_direct(e,31&t|128,r)}return await hardsid_usb_write_direct(e,31&t|128,r);case DevType.HSUNO:if(255==lastaccsids[e]){for(lastaccsids[e]=1;await hardsid_usb_delay(e,4)==WState.BUSY;);for(;await hardsid_usb_delay(e,5e3)==WState.BUSY;);for(;await hardsid_usb_write_direct(e,240,4)==WState.BUSY;);for(;await hardsid_usb_delay(e,6e4)==WState.BUSY;);for(;await hardsid_usb_write_direct(e,240,2)==WState.BUSY;);for(;await hardsid_usb_delay(e,10)==WState.BUSY;);for(;await hardsid_usb_flush(e)==WState.BUSY;);return await hardsid_usb_write_direct(e,31&t|128,r)}return await hardsid_usb_write_direct(e,31&t|128,r);default:return WState.ERROR}}catch(e){return console.log(e),e=!0,WState.ERROR}}async function hardsid_usb_delay(e,t){if(!initialized||error)return WState.ERROR;if(0==t);else{if(t<256)return await hardsid_usb_write_direct(e,238,255&t);if(0==(255&t))return await hardsid_usb_write_direct(e,239,t>>8);if(sync&&writeBuffer[e].byteLength==bufferSize-2){let t=await hardsid_usb_write_direct(e,255,255);if(t!=WState.OK)return t}else if(sync&&writeBuffer[e].byteLength==bufferSize-4){let t=await hardsid_usb_sync(e);if(t!=WState.OK)return t}await hardsid_usb_write_direct(e,239,t>>8),await hardsid_usb_write_direct(e,238,255&t)}return WState.OK}async function hardsid_usb_flush(e){if(!initialized||error)return WState.ERROR;if(writeBuffer[e].byteLength>0){if(sync&&buffChk){let t=await hardsid_usb_sync(e);if(t!=WState.OK)return t}writeBuffer[e].byteLength%bufferSize>0&&(writeBuffer[e]=concatenate(Uint8Array,writeBuffer[e],Uint8Array.of(255,255))),await hardsid_usb_write_internal(e)}return WState.OK}async function hardsid_usb_abortplay(e){if(writeBuffer[e]=new Uint8Array,initialized&&0!=deviceCount)if(await hardsid_usb_readstate(e)==WState.OK){if(0!=pkgCount)for(await hardsid_usb_write_direct(e,255,255),await hardsid_usb_write_direct(e,255,255),await hardsid_usb_write_internal(e);;){if(await hardsid_usb_readstate(e)!=WState.OK){error=!0;break}if(0==pkgCount)break}}else error=!0}async function hardsid_usb_setmode(e,t){if(t!==SysMode.SIDPLAY)throw new Error("Only SIDPLAY mode currently supported!");if(t===SysMode.VST)return error=!0,WState.ERROR;if(await hardsid_usb_readstate(e)!=WState.OK)return error=!0,WState.ERROR;if((15&sysMode)==t)return WState.OK;for(await hardsid_usb_abortplay(e),await hardsid_usb_write_direct(e,255,255),await hardsid_usb_write_direct(e,0,t),await hardsid_usb_write_internal(e);;){if(await hardsid_usb_readstate(e)!=WState.OK){error=!0;break}if(sysMode==(128|t))break}return error?WState.ERROR:WState.OK}async function hardsid_usb_reset(e,t,r){for(var a=0;a<32;a++){for(;await hardsid_usb_delay(e,4)==WState.BUSY;);for(;await hardsid_usb_write(e,t<<5|a,0)==WState.BUSY;);}for(;await hardsid_usb_delay(e,4)==WState.BUSY;);for(;await hardsid_usb_write(e,t<<5|24,r)==WState.BUSY;);for(;await hardsid_usb_delay(e,4)==WState.BUSY;);for(await hardsid_usb_sync(e);await hardsid_usb_flush(e)==WState.BUSY;);}function concatenate(e,...t){let r=0;for(const e of t)r+=e.length;const a=new e(r);let i=0;for(const e of t)a.set(e,i),i+=e.length;return a}