/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.segments.SegmentMemoryBlock;

public class AlignDirective
extends AsmDirective {
    private ExprNode argExpr;
    private SegmentMemoryBlock.Entry memEntry;

    public AlignDirective(ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.argExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return new AlignDirective(this.argExpr, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.argExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Value value;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        if (evaluationState.getPassNo() == 1) {
            this.memEntry = evaluationState.segmentMgr.getCurrentSegment().getCurrentMemoryBlock().createNewEntry();
        }
        if ((value = this.argExpr.evaluate(evaluationState)).isInvalid()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        int n = value.getInt(this.range);
        if (n <= 0) {
            throw new AsmErrorException("Alignment size must be positive.", this.range);
        }
        int n2 = evaluationState.segmentMgr.getMemoryPosition();
        if (n2 < 0) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        int n3 = n - n2 % n;
        if (n3 == n) {
            n3 = 0;
        }
        this.memEntry.fillEntry(new byte[n3], this.range);
        evaluationState.segmentMgr.increaseMemoryPosition(n3);
        if (evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

