/*
 * Decompiled with CFR 0.152.
 */
package sidblaster.d2xx;

import com.ftdi.FTD2XXException;
import com.ftdi.FTDevice;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import sidblaster.SIDType;
import sidblaster.d2xx.D2XXDevice;

public class D2XXManager {
    private List<FTDevice> devices = new ArrayList<FTDevice>();
    private static D2XXManager instance = null;

    public static D2XXManager getInstance() {
        if (instance == null) {
            instance = new D2XXManager();
        }
        return instance;
    }

    public List<FTDevice> createDeviceList() throws FTD2XXException {
        this.devices = FTDevice.getDevices(false).stream().filter(device -> this.isValidDeviceInfo((FTDevice)device)).sorted((d1, d2) -> d1.getDevSerialNumber().compareTo(d2.getDevSerialNumber())).collect(Collectors.toList());
        return this.devices;
    }

    public boolean isValidDeviceInfo(FTDevice device) {
        return device.getDevDescription().startsWith("SIDBlaster/USB");
    }

    public void cleanList() {
        this.devices.clear();
    }

    public int count() {
        return this.devices.size();
    }

    public void rescan() throws FTD2XXException {
        List newDevices = FTDevice.getDevices(false).stream().filter(device -> this.isValidDeviceInfo((FTDevice)device)).sorted((d1, d2) -> d1.getDevSerialNumber().compareTo(d2.getDevSerialNumber())).collect(Collectors.toList());
        this.devices.addAll(newDevices);
    }

    public FTDevice getDevice(int index) {
        return this.devices.get(index);
    }

    public void update(Subject subject) throws FTD2XXException {
        this.rescan();
    }

    public void displayDevicesInfo() {
        System.out.printf("===================================\n", new Object[0]);
        System.out.printf("Devices: %d\n", this.devices.size());
        System.out.printf("===================================\n", new Object[0]);
        for (FTDevice ftDevice : this.devices) {
            D2XXDevice.displayInfo(ftDevice);
            System.out.printf("===================================\n", new Object[0]);
        }
    }

    public String GetSerialNo(int index) {
        return this.devices.get(index).getDevSerialNumber();
    }

    public SIDType GetSIDType(int index) {
        return D2XXDevice.getSIDType(this.devices.get(index));
    }

    public void SetSIDType(int index, SIDType sidType) throws FTD2XXException, InterruptedException {
        D2XXDevice.setSIDType(this.devices.get(index), sidType);
    }

    public void SetSerialNo(int index, String serialNo) throws FTD2XXException, InterruptedException {
        D2XXDevice.setSerialNo(this.devices.get(index), serialNo);
    }
}

