/*
 * Decompiled with CFR 0.152.
 */
package ui.ultimate64;

import java.io.IOException;
import javax.sound.sampled.LineUnavailableException;
import sidplay.player.ObjectProperty;
import sidplay.player.State;

public abstract class StreamingPlayer {
    private static final int QUIT_MAX_WAIT_TIME = 1000;
    private ObjectProperty<State> stateProperty = new ObjectProperty<State>(State.class.getSimpleName(), State.QUIT);
    private Thread streamingThread;
    private Runnable streamingRunnable = () -> {
        try {
            this.open();
            this.stateProperty.set(State.START);
            this.stateProperty.set(State.PLAY);
            while (this.stateProperty.get() == State.PLAY) {
                this.play();
            }
        }
        catch (IOException | InterruptedException | LineUnavailableException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.close();
        }
    };

    protected abstract void open() throws IOException, LineUnavailableException, InterruptedException;

    protected abstract void play() throws IOException, InterruptedException;

    protected abstract void close();

    public void start() {
        if (this.streamingThread == null || !this.streamingThread.isAlive()) {
            this.streamingThread = new Thread(this.streamingRunnable, "Player");
            this.streamingThread.setPriority(10);
            this.streamingThread.start();
        }
    }

    public void stop() {
        try {
            while (this.streamingThread != null && this.streamingThread.isAlive()) {
                this.stateProperty.set(State.QUIT);
                this.streamingThread.join(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

