/*
 * Decompiled with CFR 0.152.
 */
package mpg;

import mpg.Common;
import mpg.Frame;
import mpg.Huffman;
import mpg.Interface;
import mpg.MPG123;
import mpg.MPGLib;

public class Layer3 {
    private Common common;
    private float[] ispow = new float[8207];
    private float[] aa_ca = new float[8];
    private float[] aa_cs = new float[8];
    private float[][] COS1 = new float[12][6];
    private float[][] win = new float[4][36];
    private float[][] win1 = new float[4][36];
    private float[] gainpow2 = new float[378];
    private float[] COS9 = new float[9];
    private float COS6_1;
    private float COS6_2;
    private float[] tfcos36 = new float[9];
    private float[] tfcos12 = new float[3];
    private int[][] longLimit = new int[9][23];
    private int[][] shortLimit = new int[9][14];
    private static bandInfoStruct[] bandInfo = new bandInfoStruct[]{new bandInfoStruct(new short[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 52, 62, 74, 90, 110, 134, 162, 196, 238, 288, 342, 418, 576}, new short[]{4, 4, 4, 4, 4, 4, 6, 6, 8, 8, 10, 12, 16, 20, 24, 28, 34, 42, 50, 54, 76, 158}, new short[]{0, 12, 24, 36, 48, 66, 90, 120, 156, 198, 252, 318, 408, 576}, new short[]{4, 4, 4, 4, 6, 8, 10, 12, 14, 18, 22, 30, 56}), new bandInfoStruct(new short[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 60, 72, 88, 106, 128, 156, 190, 230, 276, 330, 384, 576}, new short[]{4, 4, 4, 4, 4, 4, 6, 6, 6, 8, 10, 12, 16, 18, 22, 28, 34, 40, 46, 54, 54, 192}, new short[]{0, 12, 24, 36, 48, 66, 84, 114, 150, 192, 240, 300, 378, 576}, new short[]{4, 4, 4, 4, 6, 6, 10, 12, 14, 16, 20, 26, 66}), new bandInfoStruct(new short[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 54, 66, 82, 102, 126, 156, 194, 240, 296, 364, 448, 550, 576}, new short[]{4, 4, 4, 4, 4, 4, 6, 6, 8, 10, 12, 16, 20, 24, 30, 38, 46, 56, 68, 84, 102, 26}, new short[]{0, 12, 24, 36, 48, 66, 90, 126, 174, 234, 312, 414, 540, 576}, new short[]{4, 4, 4, 4, 6, 8, 12, 16, 20, 26, 34, 42, 12}), new bandInfoStruct(new short[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576}, new short[]{6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 20, 24, 28, 32, 38, 46, 52, 60, 68, 58, 54}, new short[]{0, 12, 24, 36, 54, 72, 96, 126, 168, 222, 300, 396, 522, 576}, new short[]{4, 4, 4, 6, 6, 8, 10, 14, 18, 26, 32, 42, 18}), new bandInfoStruct(new short[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 114, 136, 162, 194, 232, 278, 332, 394, 464, 540, 576}, new short[]{6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 18, 22, 26, 32, 38, 46, 54, 62, 70, 76, 36}, new short[]{0, 12, 24, 36, 54, 78, 108, 144, 186, 240, 312, 408, 540, 576}, new short[]{4, 4, 4, 6, 8, 10, 12, 14, 18, 24, 32, 44, 12}), new bandInfoStruct(new short[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576}, new short[]{6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 20, 24, 28, 32, 38, 46, 52, 60, 68, 58, 54}, new short[]{0, 12, 24, 36, 54, 78, 108, 144, 186, 240, 312, 402, 522, 576}, new short[]{4, 4, 4, 6, 8, 10, 12, 14, 18, 24, 30, 40, 18}), new bandInfoStruct(new short[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576}, new short[]{6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 20, 24, 28, 32, 38, 46, 52, 60, 68, 58, 54}, new short[]{0, 12, 24, 36, 54, 78, 108, 144, 186, 240, 312, 402, 522, 576}, new short[]{4, 4, 4, 6, 8, 10, 12, 14, 18, 24, 30, 40, 18}), new bandInfoStruct(new short[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576}, new short[]{6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 20, 24, 28, 32, 38, 46, 52, 60, 68, 58, 54}, new short[]{0, 12, 24, 36, 54, 78, 108, 144, 186, 240, 312, 402, 522, 576}, new short[]{4, 4, 4, 6, 8, 10, 12, 14, 18, 24, 30, 40, 18}), new bandInfoStruct(new short[]{0, 12, 24, 36, 48, 60, 72, 88, 108, 132, 160, 192, 232, 280, 336, 400, 476, 566, 568, 570, 572, 574, 576}, new short[]{12, 12, 12, 12, 12, 12, 16, 20, 24, 28, 32, 40, 48, 56, 64, 76, 90, 2, 2, 2, 2, 2}, new short[]{0, 24, 48, 72, 108, 156, 216, 288, 372, 480, 486, 492, 498, 576}, new short[]{8, 8, 8, 12, 16, 20, 24, 28, 36, 2, 2, 2, 26})};
    private int[][] mapbuf0 = new int[9][152];
    private int[][] mapbuf1 = new int[9][156];
    private int[][] mapbuf2 = new int[9][44];
    private int[][][] map = new int[9][3][];
    private int[][] mapend = new int[9][3];
    private int[] n_slen2 = new int[512];
    private int[] i_slen2 = new int[256];
    private float[] tan1_1 = new float[16];
    private float[] tan2_1 = new float[16];
    private float[] tan1_2 = new float[16];
    private float[] tan2_2 = new float[16];
    private float[][] pow1_1 = new float[2][16];
    private float[][] pow2_1 = new float[2][16];
    private float[][] pow1_2 = new float[2][16];
    private float[][] pow2_2 = new float[2][16];
    private static double[] Ci = new double[]{-0.6, -0.535, -0.33, -0.185, -0.095, -0.041, -0.0142, -0.0037};
    private static int[] len = new int[]{36, 36, 12, 36};
    private static final int[][] slen = new int[][]{{0, 0, 0, 0, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4}, {0, 1, 2, 3, 0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 2, 3}};
    private static final int[][][] stab = new int[][][]{new int[][]{{6, 5, 5, 5}, {6, 5, 7, 3}, {11, 10, 0, 0}, {7, 7, 7, 0}, {6, 6, 6, 3}, {8, 8, 5, 0}}, new int[][]{{9, 9, 9, 9}, {9, 9, 12, 6}, {18, 18, 0, 0}, {12, 12, 12, 0}, {12, 9, 9, 6}, {15, 12, 9, 0}}, new int[][]{{6, 9, 9, 9}, {6, 9, 12, 6}, {15, 18, 0, 0}, {6, 15, 12, 0}, {6, 12, 9, 6}, {6, 18, 9, 0}}};
    private static final int[] pretab1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 3, 3, 3, 2, 0};
    private static final int[] pretab2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private MPG123.III_sideinfo sideinfo = new MPG123.III_sideinfo();
    private float[][] hybridIn = new float[2][576];
    private float[][] hybridOut = new float[2][576];

    public Layer3(Common c) {
        this.common = c;
    }

    private int get1bit(MPGLib.mpstr_tag mp) {
        int rval = (mp.wordpointer[mp.wordpointerPos] & 0xFF) << mp.bitindex;
        ++mp.bitindex;
        mp.wordpointerPos += mp.bitindex >> 3;
        mp.bitindex &= 7;
        return (rval &= 0xFF) >> 7;
    }

    public void init_layer3(int down_sample_sblimit) {
        int n;
        int k;
        int j;
        int i;
        for (i = -256; i < 122; ++i) {
            this.gainpow2[i + 256] = (float)Math.pow(2.0, -0.25 * (double)(i + 210));
        }
        for (i = 0; i < 8207; ++i) {
            this.ispow[i] = (float)Math.pow(i, 1.3333333333333333);
        }
        for (i = 0; i < 8; ++i) {
            double sq = Math.sqrt(1.0 + Ci[i] * Ci[i]);
            this.aa_cs[i] = (float)(1.0 / sq);
            this.aa_ca[i] = (float)(Ci[i] / sq);
        }
        for (i = 0; i < 18; ++i) {
            float f = (float)(0.5 * Math.sin(0.04363323129985824 * (double)(2 * (i + 0) + 1)) / Math.cos(Math.PI * (double)(2 * (i + 0) + 19) / 72.0));
            this.win[1][i] = f;
            this.win[0][i] = f;
            float f2 = (float)(0.5 * Math.sin(0.04363323129985824 * (double)(2 * (i + 18) + 1)) / Math.cos(Math.PI * (double)(2 * (i + 18) + 19) / 72.0));
            this.win[3][i + 18] = f2;
            this.win[0][i + 18] = f2;
        }
        for (i = 0; i < 6; ++i) {
            this.win[1][i + 18] = (float)(0.5 / Math.cos(Math.PI * (double)(2 * (i + 18) + 19) / 72.0));
            this.win[3][i + 12] = (float)(0.5 / Math.cos(Math.PI * (double)(2 * (i + 12) + 19) / 72.0));
            this.win[1][i + 24] = (float)(0.5 * Math.sin(0.1308996938995747 * (double)(2 * i + 13)) / Math.cos(Math.PI * (double)(2 * (i + 24) + 19) / 72.0));
            this.win[3][i] = 0.0f;
            this.win[1][i + 30] = 0.0f;
            this.win[3][i + 6] = (float)(0.5 * Math.sin(0.1308996938995747 * (double)(2 * i + 1)) / Math.cos(Math.PI * (double)(2 * (i + 6) + 19) / 72.0));
        }
        for (i = 0; i < 9; ++i) {
            this.COS9[i] = (float)Math.cos(0.17453292519943295 * (double)i);
        }
        for (i = 0; i < 9; ++i) {
            this.tfcos36[i] = (float)(0.5 / Math.cos(Math.PI * (double)(i * 2 + 1) / 36.0));
        }
        for (i = 0; i < 3; ++i) {
            this.tfcos12[i] = (float)(0.5 / Math.cos(Math.PI * (double)(i * 2 + 1) / 12.0));
        }
        this.COS6_1 = (float)Math.cos(0.5235987755982988);
        this.COS6_2 = (float)Math.cos(1.0471975511965976);
        for (i = 0; i < 12; ++i) {
            this.win[2][i] = (float)(0.5 * Math.sin(0.1308996938995747 * (double)(2 * i + 1)) / Math.cos(Math.PI * (double)(2 * i + 7) / 24.0));
            for (int j2 = 0; j2 < 6; ++j2) {
                this.COS1[i][j2] = (float)Math.cos(0.1308996938995747 * (double)((2 * i + 7) * (2 * j2 + 1)));
            }
        }
        for (j = 0; j < 4; ++j) {
            int i2;
            for (i2 = 0; i2 < len[j]; i2 += 2) {
                this.win1[j][i2] = this.win[j][i2];
            }
            for (i2 = 1; i2 < len[j]; i2 += 2) {
                this.win1[j][i2] = -this.win[j][i2];
            }
        }
        for (i = 0; i < 16; ++i) {
            double t = Math.tan((double)i * Math.PI / 12.0);
            this.tan1_1[i] = (float)(t / (1.0 + t));
            this.tan2_1[i] = (float)(1.0 / (1.0 + t));
            this.tan1_2[i] = (float)(1.4142135623730951 * t / (1.0 + t));
            this.tan2_2[i] = (float)(1.4142135623730951 / (1.0 + t));
            for (int j3 = 0; j3 < 2; ++j3) {
                double base = Math.pow(2.0, -0.25 * ((double)j3 + 1.0));
                double p1 = 1.0;
                double p2 = 1.0;
                if (i > 0) {
                    if ((i & 1) != 0) {
                        p1 = Math.pow(base, ((double)i + 1.0) * 0.5);
                    } else {
                        p2 = Math.pow(base, (double)i * 0.5);
                    }
                }
                this.pow1_1[j3][i] = (float)p1;
                this.pow2_1[j3][i] = (float)p2;
                this.pow1_2[j3][i] = (float)(1.4142135623730951 * p1);
                this.pow2_2[j3][i] = (float)(1.4142135623730951 * p2);
            }
        }
        for (j = 0; j < 9; ++j) {
            int l;
            bandInfoStruct bi = bandInfo[j];
            this.map[j][0] = this.mapbuf0[j];
            int mp = 0;
            int bdf = 0;
            int i3 = 0;
            int cb = 0;
            while (cb < 8) {
                this.map[j][0][mp++] = bi.longDiff[bdf] >> 1;
                this.map[j][0][mp++] = i3;
                this.map[j][0][mp++] = 3;
                this.map[j][0][mp++] = cb++;
                i3 += bi.longDiff[bdf++];
            }
            bdf = 3;
            for (cb = 3; cb < 13; ++cb) {
                l = bi.shortDiff[bdf++] >> 1;
                int lwin = 0;
                while (lwin < 3) {
                    this.map[j][0][mp++] = l;
                    this.map[j][0][mp++] = i3 + lwin;
                    this.map[j][0][mp++] = lwin++;
                    this.map[j][0][mp++] = cb;
                }
                i3 += 6 * l;
            }
            this.mapend[j][0] = mp;
            this.map[j][1] = this.mapbuf1[j];
            mp = 0;
            bdf = 0;
            i3 = 0;
            for (cb = 0; cb < 13; ++cb) {
                l = bi.shortDiff[bdf++] >> 1;
                int lwin = 0;
                while (lwin < 3) {
                    this.map[j][1][mp++] = l;
                    this.map[j][1][mp++] = i3 + lwin;
                    this.map[j][1][mp++] = lwin++;
                    this.map[j][1][mp++] = cb;
                }
                i3 += 6 * l;
            }
            this.mapend[j][1] = mp;
            this.map[j][2] = this.mapbuf2[j];
            mp = 0;
            bdf = 0;
            cb = 0;
            while (cb < 22) {
                this.map[j][2][mp++] = bi.longDiff[bdf++] >> 1;
                this.map[j][2][mp++] = cb++;
            }
            this.mapend[j][2] = mp;
        }
        for (j = 0; j < 9; ++j) {
            int i4;
            for (i4 = 0; i4 < 23; ++i4) {
                this.longLimit[j][i4] = (Layer3.bandInfo[j].longIdx[i4] - 1 + 8) / 18 + 1;
                if (this.longLimit[j][i4] <= down_sample_sblimit) continue;
                this.longLimit[j][i4] = down_sample_sblimit;
            }
            for (i4 = 0; i4 < 14; ++i4) {
                this.shortLimit[j][i4] = (Layer3.bandInfo[j].shortIdx[i4] - 1) / 18 + 1;
                if (this.shortLimit[j][i4] <= down_sample_sblimit) continue;
                this.shortLimit[j][i4] = down_sample_sblimit;
            }
        }
        for (i = 0; i < 5; ++i) {
            for (int j4 = 0; j4 < 6; ++j4) {
                for (k = 0; k < 6; ++k) {
                    n = k + j4 * 6 + i * 36;
                    this.i_slen2[n] = i | j4 << 3 | k << 6 | 0x3000;
                }
            }
        }
        for (i = 0; i < 4; ++i) {
            for (int j5 = 0; j5 < 4; ++j5) {
                for (k = 0; k < 4; ++k) {
                    n = k + j5 * 4 + i * 16;
                    this.i_slen2[n + 180] = i | j5 << 3 | k << 6 | 0x4000;
                }
            }
        }
        for (i = 0; i < 4; ++i) {
            for (int j6 = 0; j6 < 3; ++j6) {
                int n2 = j6 + i * 3;
                this.i_slen2[n2 + 244] = i | j6 << 3 | 0x5000;
                this.n_slen2[n2 + 500] = i | j6 << 3 | 0x2000 | 0x8000;
            }
        }
        for (i = 0; i < 5; ++i) {
            for (int j7 = 0; j7 < 5; ++j7) {
                for (k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        int n3 = l + k * 4 + j7 * 16 + i * 80;
                        this.n_slen2[n3] = i | j7 << 3 | k << 6 | l << 9 | 0;
                    }
                }
            }
        }
        for (i = 0; i < 5; ++i) {
            for (int j8 = 0; j8 < 5; ++j8) {
                for (k = 0; k < 4; ++k) {
                    n = k + j8 * 4 + i * 20;
                    this.n_slen2[n + 400] = i | j8 << 3 | k << 6 | 0x1000;
                }
            }
        }
    }

    private void III_get_side_info_1(MPGLib.mpstr_tag mp, MPG123.III_sideinfo si, int stereo, int ms_stereo, int sfreq, int single) {
        int ch;
        int powdiff = single == 3 ? 4 : 0;
        si.main_data_begin = this.common.getbits(mp, 9);
        si.private_bits = stereo == 1 ? this.common.getbits_fast(mp, 5) : this.common.getbits_fast(mp, 3);
        for (ch = 0; ch < stereo; ++ch) {
            si.ch[ch].gr[0].scfsi = -1;
            si.ch[ch].gr[1].scfsi = this.common.getbits_fast(mp, 4);
        }
        for (int gr = 0; gr < 2; ++gr) {
            for (ch = 0; ch < stereo; ++ch) {
                int i;
                MPG123.gr_info_s gr_infos = si.ch[ch].gr[gr];
                gr_infos.part2_3_length = this.common.getbits(mp, 12);
                gr_infos.big_values = this.common.getbits_fast(mp, 9);
                if (gr_infos.big_values > 288) {
                    System.err.printf("big_values too large! %d\n", gr_infos.big_values);
                    gr_infos.big_values = 288;
                }
                int qss = this.common.getbits_fast(mp, 8);
                gr_infos.pow2gain = this.gainpow2;
                gr_infos.pow2gainPos = 256 - qss + powdiff;
                if (mp.pinfo != null) {
                    mp.pinfo.qss[gr][ch] = qss;
                }
                if (ms_stereo != 0) {
                    gr_infos.pow2gainPos += 2;
                }
                gr_infos.scalefac_compress = this.common.getbits_fast(mp, 4);
                if (this.get1bit(mp) != 0) {
                    gr_infos.block_type = this.common.getbits_fast(mp, 2);
                    gr_infos.mixed_block_flag = this.get1bit(mp);
                    gr_infos.table_select[0] = this.common.getbits_fast(mp, 5);
                    gr_infos.table_select[1] = this.common.getbits_fast(mp, 5);
                    gr_infos.table_select[2] = 0;
                    for (i = 0; i < 3; ++i) {
                        int sbg = this.common.getbits_fast(mp, 3) << 3;
                        gr_infos.full_gain[i] = gr_infos.pow2gain;
                        gr_infos.full_gainPos[i] = gr_infos.pow2gainPos + sbg;
                        if (mp.pinfo == null) continue;
                        mp.pinfo.sub_gain[gr][ch][i] = sbg / 8;
                    }
                    if (gr_infos.block_type == 0) {
                        System.err.printf("Blocktype == 0 and window-switching == 1 not allowed.\n", new Object[0]);
                    }
                    gr_infos.region1start = 18;
                    gr_infos.region2start = 288;
                } else {
                    for (i = 0; i < 3; ++i) {
                        gr_infos.table_select[i] = this.common.getbits_fast(mp, 5);
                    }
                    int r0c = this.common.getbits_fast(mp, 4);
                    int r1c = this.common.getbits_fast(mp, 3);
                    gr_infos.region1start = Layer3.bandInfo[sfreq].longIdx[r0c + 1] >> 1;
                    gr_infos.region2start = r0c + 1 + r1c + 1 < Layer3.bandInfo[sfreq].longIdx.length ? Layer3.bandInfo[sfreq].longIdx[r0c + 1 + r1c + 1] >> 1 : Layer3.bandInfo[sfreq].longDiff[r0c + 1 + r1c + 1 - Layer3.bandInfo[sfreq].longIdx.length] >> 1;
                    gr_infos.block_type = 0;
                    gr_infos.mixed_block_flag = 0;
                }
                gr_infos.preflag = this.get1bit(mp);
                gr_infos.scalefac_scale = this.get1bit(mp);
                gr_infos.count1table_select = this.get1bit(mp);
            }
        }
    }

    private void III_get_side_info_2(MPGLib.mpstr_tag mp, MPG123.III_sideinfo si, int stereo, int ms_stereo, int sfreq, int single) {
        int powdiff = single == 3 ? 4 : 0;
        si.main_data_begin = this.common.getbits(mp, 8);
        si.private_bits = stereo == 1 ? this.get1bit(mp) : this.common.getbits_fast(mp, 2);
        for (int ch = 0; ch < stereo; ++ch) {
            int i;
            MPG123.gr_info_s gr_infos = si.ch[ch].gr[0];
            gr_infos.part2_3_length = this.common.getbits(mp, 12);
            gr_infos.big_values = this.common.getbits_fast(mp, 9);
            if (gr_infos.big_values > 288) {
                System.err.printf("big_values too large! %d\n", gr_infos.big_values);
                gr_infos.big_values = 288;
            }
            int qss = this.common.getbits_fast(mp, 8);
            gr_infos.pow2gain = this.gainpow2;
            gr_infos.pow2gainPos = 256 - qss + powdiff;
            if (mp.pinfo != null) {
                mp.pinfo.qss[0][ch] = qss;
            }
            if (ms_stereo != 0) {
                gr_infos.pow2gainPos += 2;
            }
            gr_infos.scalefac_compress = this.common.getbits(mp, 9);
            if (this.get1bit(mp) != 0) {
                gr_infos.block_type = this.common.getbits_fast(mp, 2);
                gr_infos.mixed_block_flag = this.get1bit(mp);
                gr_infos.table_select[0] = this.common.getbits_fast(mp, 5);
                gr_infos.table_select[1] = this.common.getbits_fast(mp, 5);
                gr_infos.table_select[2] = 0;
                for (i = 0; i < 3; ++i) {
                    int sbg = this.common.getbits_fast(mp, 3) << 3;
                    gr_infos.full_gain[i] = gr_infos.pow2gain;
                    gr_infos.full_gainPos[i] = gr_infos.pow2gainPos + sbg;
                    if (mp.pinfo == null) continue;
                    mp.pinfo.sub_gain[0][ch][i] = sbg / 8;
                }
                if (gr_infos.block_type == 0) {
                    System.err.printf("Blocktype == 0 and window-switching == 1 not allowed.\n", new Object[0]);
                }
                gr_infos.region1start = gr_infos.block_type == 2 ? (sfreq == 8 ? 36 : 18) : (sfreq == 8 ? 54 : 27);
                gr_infos.region2start = 288;
            } else {
                for (i = 0; i < 3; ++i) {
                    gr_infos.table_select[i] = this.common.getbits_fast(mp, 5);
                }
                int r0c = this.common.getbits_fast(mp, 4);
                int r1c = this.common.getbits_fast(mp, 3);
                gr_infos.region1start = Layer3.bandInfo[sfreq].longIdx[r0c + 1] >> 1;
                gr_infos.region2start = Layer3.bandInfo[sfreq].longIdx[r0c + 1 + r1c + 1] >> 1;
                gr_infos.block_type = 0;
                gr_infos.mixed_block_flag = 0;
            }
            gr_infos.scalefac_scale = this.get1bit(mp);
            gr_infos.count1table_select = this.get1bit(mp);
        }
    }

    private int III_get_scale_factors_1(MPGLib.mpstr_tag mp, int[] scf, MPG123.gr_info_s gr_infos) {
        int numbits;
        int scfPos = 0;
        int num0 = slen[0][gr_infos.scalefac_compress];
        int num1 = slen[1][gr_infos.scalefac_compress];
        if (gr_infos.block_type == 2) {
            int i = 18;
            numbits = (num0 + num1) * 18;
            if (gr_infos.mixed_block_flag != 0) {
                for (i = 8; i != 0; --i) {
                    scf[scfPos++] = this.common.getbits_fast(mp, num0);
                }
                i = 9;
                numbits -= num0;
            }
            while (i != 0) {
                scf[scfPos++] = this.common.getbits_fast(mp, num0);
                --i;
            }
            for (i = 18; i != 0; --i) {
                scf[scfPos++] = this.common.getbits_fast(mp, num1);
            }
            scf[scfPos++] = 0;
            scf[scfPos++] = 0;
            scf[scfPos++] = 0;
        } else {
            int scfsi = gr_infos.scfsi;
            if (scfsi < 0) {
                int i;
                for (i = 11; i != 0; --i) {
                    scf[scfPos++] = this.common.getbits_fast(mp, num0);
                }
                for (i = 10; i != 0; --i) {
                    scf[scfPos++] = this.common.getbits_fast(mp, num1);
                }
                numbits = (num0 + num1) * 10 + num0;
            } else {
                int i;
                numbits = 0;
                if (0 == (scfsi & 8)) {
                    for (i = 6; i != 0; --i) {
                        scf[scfPos++] = this.common.getbits_fast(mp, num0);
                    }
                    numbits += num0 * 6;
                } else {
                    scfPos += 6;
                }
                if (0 == (scfsi & 4)) {
                    for (i = 5; i != 0; --i) {
                        scf[scfPos++] = this.common.getbits_fast(mp, num0);
                    }
                    numbits += num0 * 5;
                } else {
                    scfPos += 5;
                }
                if (0 == (scfsi & 2)) {
                    for (i = 5; i != 0; --i) {
                        scf[scfPos++] = this.common.getbits_fast(mp, num1);
                    }
                    numbits += num1 * 5;
                } else {
                    scfPos += 5;
                }
                if (0 == (scfsi & 1)) {
                    for (i = 5; i != 0; --i) {
                        scf[scfPos++] = this.common.getbits_fast(mp, num1);
                    }
                    numbits += num1 * 5;
                } else {
                    scfPos += 5;
                }
            }
            scf[scfPos++] = 0;
        }
        return numbits;
    }

    private int III_get_scale_factors_2(MPGLib.mpstr_tag mp, int[] scf, MPG123.gr_info_s gr_infos, int i_stereo) {
        int i;
        int scfPos = 0;
        int n = 0;
        int numbits = 0;
        int slen = i_stereo != 0 ? this.i_slen2[gr_infos.scalefac_compress >> 1] : this.n_slen2[gr_infos.scalefac_compress];
        gr_infos.preflag = slen >> 15 & 1;
        n = 0;
        if (gr_infos.block_type == 2) {
            ++n;
            if (gr_infos.mixed_block_flag != 0) {
                ++n;
            }
        }
        int[] pnt = stab[n][slen >> 12 & 7];
        for (i = 0; i < 4; ++i) {
            int j;
            int num = slen & 7;
            slen >>= 3;
            if (num != 0) {
                for (j = 0; j < pnt[i]; ++j) {
                    scf[scfPos++] = this.common.getbits_fast(mp, num);
                }
                numbits += pnt[i] * num;
                continue;
            }
            for (j = 0; j < pnt[i]; ++j) {
                scf[scfPos++] = 0;
            }
        }
        n = (n << 1) + 1;
        for (i = 0; i < n; ++i) {
            scf[scfPos++] = 0;
        }
        return numbits;
    }

    private int III_dequantize_sample(MPGLib.mpstr_tag mp, float[] xr, int[] scf, MPG123.gr_info_s gr_infos, int sfreq, int part2bits) {
        short a;
        int valPos;
        int x;
        int y;
        int valPos2;
        short[] val;
        int cb;
        int i;
        int scfPos = 0;
        int shift = 1 + gr_infos.scalefac_scale;
        float[] xrpnt = xr;
        int xrpntPos = 0;
        int[] l = new int[3];
        int part2remain = gr_infos.part2_3_length - part2bits;
        for (i = 576 - xrpntPos >> 1; i > 0; --i) {
            xrpnt[xrpntPos++] = 0.0f;
            xrpnt[xrpntPos++] = 0.0f;
        }
        xrpnt = xr;
        xrpntPos = 0;
        int bv = gr_infos.big_values;
        int region1 = gr_infos.region1start;
        int region2 = gr_infos.region2start;
        int l3 = 288 - bv >> 1;
        if (bv <= region1) {
            l[0] = bv;
            l[1] = 0;
            l[2] = 0;
        } else {
            l[0] = region1;
            if (bv <= region2) {
                l[1] = bv - l[0];
                l[2] = 0;
            } else {
                l[1] = region2 - l[0];
                l[2] = bv - region2;
            }
        }
        for (i = 0; i < 3; ++i) {
            if (l[i] >= 0) continue;
            System.err.printf("hip: Bogus region length (%d)\n", l[i]);
            l[i] = 0;
        }
        if (gr_infos.block_type == 2) {
            int me;
            int[] m;
            int[] max = new int[4];
            int step = 0;
            int lwin = 0;
            cb = 0;
            float v = 0.0f;
            int mPos = 0;
            if (gr_infos.mixed_block_flag != 0) {
                max[3] = -1;
                max[2] = 2;
                max[1] = 2;
                max[0] = 2;
                m = this.map[sfreq][0];
                mPos = 0;
                me = this.mapend[sfreq][0];
            } else {
                max[3] = -1;
                max[2] = -1;
                max[1] = -1;
                max[0] = -1;
                m = this.map[sfreq][1];
                mPos = 0;
                me = this.mapend[sfreq][1];
            }
            int mc = 0;
            for (i = 0; i < 2; ++i) {
                int lp = l[i];
                Huffman.newhuff[] h = Huffman.ht;
                int hPos = gr_infos.table_select[i];
                while (lp != 0) {
                    if (0 == mc) {
                        mc = m[mPos++];
                        xrpnt = xr;
                        xrpntPos = m[mPos++];
                        lwin = m[mPos++];
                        cb = m[mPos++];
                        if (lwin == 3) {
                            v = gr_infos.pow2gain[gr_infos.pow2gainPos + (scf[scfPos++] << shift)];
                            step = 1;
                        } else {
                            v = gr_infos.full_gain[lwin][gr_infos.full_gainPos[lwin] + (scf[scfPos++] << shift)];
                            step = 3;
                        }
                    }
                    val = h[hPos].table;
                    valPos2 = 0;
                    while ((y = val[valPos2++]) < 0) {
                        if (this.get1bit(mp) != 0) {
                            valPos2 -= y;
                        }
                        --part2remain;
                    }
                    x = y >> 4;
                    y &= 0xF;
                    if (x == 15) {
                        max[lwin] = cb;
                        part2remain -= h[hPos].linbits + 1;
                        xrpnt[xrpntPos] = this.get1bit(mp) != 0 ? -this.ispow[x] * v : this.ispow[x += this.common.getbits(mp, h[hPos].linbits)] * v;
                    } else if (x != 0) {
                        max[lwin] = cb;
                        xrpnt[xrpntPos] = this.get1bit(mp) != 0 ? -this.ispow[x] * v : this.ispow[x] * v;
                        --part2remain;
                    } else {
                        xrpnt[xrpntPos] = 0.0f;
                    }
                    xrpntPos += step;
                    if (y == 15) {
                        max[lwin] = cb;
                        part2remain -= h[hPos].linbits + 1;
                        xrpnt[xrpntPos] = this.get1bit(mp) != 0 ? -this.ispow[y] * v : this.ispow[y += this.common.getbits(mp, h[hPos].linbits)] * v;
                    } else if (y != 0) {
                        max[lwin] = cb;
                        xrpnt[xrpntPos] = this.get1bit(mp) != 0 ? -this.ispow[y] * v : this.ispow[y] * v;
                        --part2remain;
                    } else {
                        xrpnt[xrpntPos] = 0.0f;
                    }
                    xrpntPos += step;
                    --lp;
                    --mc;
                }
            }
            while (l3 != 0 && part2remain > 0) {
                Huffman.newhuff[] h = Huffman.htc;
                int hPos = gr_infos.count1table_select;
                short[] val2 = h[hPos].table;
                valPos = 0;
                while ((a = val2[valPos++]) < 0) {
                    if (--part2remain < 0) {
                        ++part2remain;
                        a = 0;
                        break;
                    }
                    if (this.get1bit(mp) == 0) continue;
                    valPos -= a;
                }
                for (i = 0; i < 4; ++i) {
                    if (0 == (i & 1)) {
                        if (0 == mc) {
                            mc = m[mPos++];
                            xrpnt = xr;
                            xrpntPos = m[mPos++];
                            lwin = m[mPos++];
                            cb = m[mPos++];
                            if (lwin == 3) {
                                v = gr_infos.pow2gain[gr_infos.pow2gainPos + (scf[scfPos++] << shift)];
                                step = 1;
                            } else {
                                v = gr_infos.full_gain[lwin][gr_infos.full_gainPos[lwin] + (scf[scfPos++] << shift)];
                                step = 3;
                            }
                        }
                        --mc;
                    }
                    if ((a & 8 >> i) != 0) {
                        max[lwin] = cb;
                        if (--part2remain < 0) {
                            ++part2remain;
                            break;
                        }
                        xrpnt[xrpntPos] = this.get1bit(mp) != 0 ? -v : v;
                    } else {
                        xrpnt[xrpntPos] = 0.0f;
                    }
                    xrpntPos += step;
                }
                --l3;
            }
            while (mPos < me) {
                if (0 == mc) {
                    mc = m[mPos++];
                    xrpnt = xr;
                    xrpntPos = m[mPos++];
                    step = m[mPos++] == 3 ? 1 : 3;
                    ++mPos;
                }
                --mc;
                xrpnt[xrpntPos] = 0.0f;
                xrpnt[xrpntPos += step] = 0.0f;
                xrpntPos += step;
            }
            gr_infos.maxband[0] = max[0] + 1;
            gr_infos.maxband[1] = max[1] + 1;
            gr_infos.maxband[2] = max[2] + 1;
            gr_infos.maxbandl = max[3] + 1;
            int rmax = max[0] > max[1] ? max[0] : max[1];
            rmax = (rmax > max[2] ? rmax : max[2]) + 1;
            gr_infos.maxb = rmax != 0 ? this.shortLimit[sfreq][rmax] : this.longLimit[sfreq][max[3] + 1];
        } else {
            int i2;
            int[] pretab = gr_infos.preflag != 0 ? pretab1 : pretab2;
            int pretabPos = 0;
            int max = -1;
            cb = 0;
            int[] m = this.map[sfreq][2];
            int mPos = 0;
            float v = 0.0f;
            int mc = 0;
            for (i2 = 0; i2 < 3; ++i2) {
                int lp = l[i2];
                Huffman.newhuff[] h = Huffman.ht;
                int hPos = gr_infos.table_select[i2];
                while (lp != 0) {
                    if (0 == mc) {
                        mc = m[mPos++];
                        v = gr_infos.pow2gain[gr_infos.pow2gainPos + (scf[scfPos++] + pretab[pretabPos++] << shift)];
                        cb = m[mPos++];
                    }
                    val = h[hPos].table;
                    valPos2 = 0;
                    while ((y = val[valPos2++]) < 0) {
                        if (this.get1bit(mp) != 0) {
                            valPos2 -= y;
                        }
                        --part2remain;
                    }
                    x = y >> 4;
                    y &= 0xF;
                    if (x == 15) {
                        max = cb;
                        part2remain -= h[hPos].linbits + 1;
                        xrpnt[xrpntPos++] = this.get1bit(mp) != 0 ? -this.ispow[x] * v : this.ispow[x += this.common.getbits(mp, h[hPos].linbits)] * v;
                    } else if (x != 0) {
                        max = cb;
                        xrpnt[xrpntPos++] = this.get1bit(mp) != 0 ? -this.ispow[x] * v : this.ispow[x] * v;
                        --part2remain;
                    } else {
                        xrpnt[xrpntPos++] = 0.0f;
                    }
                    if (y == 15) {
                        max = cb;
                        part2remain -= h[hPos].linbits + 1;
                        xrpnt[xrpntPos++] = this.get1bit(mp) != 0 ? -this.ispow[y] * v : this.ispow[y += this.common.getbits(mp, h[hPos].linbits)] * v;
                    } else if (y != 0) {
                        max = cb;
                        xrpnt[xrpntPos++] = this.get1bit(mp) != 0 ? -this.ispow[y] * v : this.ispow[y] * v;
                        --part2remain;
                    } else {
                        xrpnt[xrpntPos++] = 0.0f;
                    }
                    --lp;
                    --mc;
                }
            }
            while (l3 != 0 && part2remain > 0) {
                Huffman.newhuff[] h = Huffman.htc;
                int hPos = gr_infos.count1table_select;
                short[] val3 = h[hPos].table;
                valPos = 0;
                while ((a = val3[valPos++]) < 0) {
                    if (--part2remain < 0) {
                        ++part2remain;
                        a = 0;
                        break;
                    }
                    if (this.get1bit(mp) == 0) continue;
                    valPos -= a;
                }
                for (i2 = 0; i2 < 4; ++i2) {
                    if (0 == (i2 & 1)) {
                        if (0 == mc) {
                            mc = m[mPos++];
                            cb = m[mPos++];
                            v = gr_infos.pow2gain[gr_infos.pow2gainPos + (scf[scfPos++] + pretab[pretabPos++] << shift)];
                        }
                        --mc;
                    }
                    if ((a & 8 >> i2) != 0) {
                        max = cb;
                        if (--part2remain < 0) {
                            ++part2remain;
                            break;
                        }
                        if (this.get1bit(mp) != 0) {
                            xrpnt[xrpntPos++] = -v;
                            continue;
                        }
                        xrpnt[xrpntPos++] = v;
                        continue;
                    }
                    xrpnt[xrpntPos++] = 0.0f;
                }
                --l3;
            }
            for (i2 = 576 - xrpntPos >> 1; i2 != 0; --i2) {
                xrpnt[xrpntPos++] = 0.0f;
                xrpnt[xrpntPos++] = 0.0f;
            }
            gr_infos.maxbandl = max + 1;
            gr_infos.maxb = this.longLimit[sfreq][gr_infos.maxbandl];
        }
        while (part2remain > 16) {
            this.common.getbits(mp, 16);
            part2remain -= 16;
        }
        if (part2remain > 0) {
            this.common.getbits(mp, part2remain);
        } else if (part2remain < 0) {
            System.err.printf("hip: Can't rewind stream by %d bits!\n", -part2remain);
            return 1;
        }
        return 0;
    }

    private void III_i_stereo(float[][] xr_buf, int[] scalefac, MPG123.gr_info_s gr_infos, int sfreq, int ms_stereo, int lsf) {
        block22: {
            float v;
            float t2;
            float t1;
            int is_p;
            int sb;
            int sfb;
            float[] tabl2;
            float[] tabl1;
            bandInfoStruct bi;
            float[][] xr;
            block21: {
                int sfb2;
                float v2;
                float t22;
                float t12;
                xr = xr_buf;
                bi = bandInfo[sfreq];
                if (lsf != 0) {
                    int p = gr_infos.scalefac_compress & 1;
                    if (ms_stereo != 0) {
                        tabl1 = this.pow1_2[p];
                        tabl2 = this.pow2_2[p];
                    } else {
                        tabl1 = this.pow1_1[p];
                        tabl2 = this.pow2_1[p];
                    }
                } else if (ms_stereo != 0) {
                    tabl1 = this.tan1_2;
                    tabl2 = this.tan2_2;
                } else {
                    tabl1 = this.tan1_1;
                    tabl2 = this.tan2_1;
                }
                if (gr_infos.block_type != 2) break block21;
                boolean do_l = false;
                if (gr_infos.mixed_block_flag != 0) {
                    do_l = true;
                }
                for (int lwin = 0; lwin < 3; ++lwin) {
                    int idx;
                    int sb2;
                    int is_p2;
                    int sfb3 = gr_infos.maxband[lwin];
                    if (sfb3 > 3) {
                        do_l = false;
                    }
                    while (sfb3 < 12) {
                        is_p2 = scalefac[sfb3 * 3 + lwin - gr_infos.mixed_block_flag];
                        if (is_p2 != 7) {
                            sb2 = bi.shortDiff[sfb3];
                            idx = bi.shortIdx[sfb3] + lwin;
                            t12 = tabl1[is_p2];
                            t22 = tabl2[is_p2];
                            while (sb2 > 0) {
                                v2 = xr[0][idx];
                                xr[0][idx] = v2 * t12;
                                xr[1][idx] = v2 * t22;
                                --sb2;
                                idx += 3;
                            }
                        }
                        ++sfb3;
                    }
                    is_p2 = scalefac[33 + lwin - gr_infos.mixed_block_flag];
                    sb2 = bi.shortDiff[12];
                    idx = bi.shortIdx[12] + lwin;
                    if (is_p2 == 7) continue;
                    t12 = tabl1[is_p2];
                    t22 = tabl2[is_p2];
                    while (sb2 > 0) {
                        v2 = xr[0][idx];
                        xr[0][idx] = v2 * t12;
                        xr[1][idx] = v2 * t22;
                        --sb2;
                        idx += 3;
                    }
                }
                if (!do_l) break block22;
                int idx = bi.longIdx[sfb2];
                for (sfb2 = gr_infos.maxbandl; sfb2 < 8; ++sfb2) {
                    int sb3 = bi.longDiff[sfb2];
                    int is_p3 = scalefac[sfb2];
                    if (is_p3 != 7) {
                        t12 = tabl1[is_p3];
                        t22 = tabl2[is_p3];
                        while (sb3 > 0) {
                            v2 = xr[0][idx];
                            xr[0][idx] = v2 * t12;
                            xr[1][idx] = v2 * t22;
                            --sb3;
                            ++idx;
                        }
                        continue;
                    }
                    idx += sb3;
                }
                break block22;
            }
            int idx = bi.longIdx[sfb];
            for (sfb = gr_infos.maxbandl; sfb < 21; ++sfb) {
                sb = bi.longDiff[sfb];
                is_p = scalefac[sfb];
                if (is_p != 7) {
                    t1 = tabl1[is_p];
                    t2 = tabl2[is_p];
                    while (sb > 0) {
                        v = xr[0][idx];
                        xr[0][idx] = v * t1;
                        xr[1][idx] = v * t2;
                        --sb;
                        ++idx;
                    }
                    continue;
                }
                idx += sb;
            }
            is_p = scalefac[20];
            if (is_p != 7) {
                t1 = tabl1[is_p];
                t2 = tabl2[is_p];
                sb = bi.longDiff[21];
                while (sb > 0) {
                    v = xr[0][idx];
                    xr[0][idx] = v * t1;
                    xr[1][idx] = v * t2;
                    --sb;
                    ++idx;
                }
            }
        }
    }

    private void III_antialias(float[] xr, MPG123.gr_info_s gr_infos) {
        int sblim;
        if (gr_infos.block_type == 2) {
            if (0 == gr_infos.mixed_block_flag) {
                return;
            }
            sblim = 1;
        } else {
            sblim = gr_infos.maxb - 1;
        }
        float[] xr1 = xr;
        int xr1Pos = 18;
        int sb = sblim;
        while (sb != 0) {
            float[] cs = this.aa_cs;
            float[] ca = this.aa_ca;
            int caPos = 0;
            int csPos = 0;
            float[] xr2 = xr1;
            int xr2Pos = xr1Pos;
            for (int ss = 7; ss >= 0; --ss) {
                float bu = xr2[--xr2Pos];
                float bd = xr1[xr1Pos];
                xr2[xr2Pos] = bu * cs[csPos] - bd * ca[caPos];
                xr1[xr1Pos++] = bd * cs[csPos++] + bu * ca[caPos++];
            }
            --sb;
            xr1Pos += 10;
        }
    }

    private void dct36(float[] inbuf, int inbufPos, float[] o1, int o1Pos, float[] o2, int o2Pos, float[] wintab, float[] tsbuf, int tsPos) {
        float[] in = inbuf;
        int inPos = inbufPos;
        int n = inPos + 17;
        in[n] = in[n] + in[inPos + 16];
        int n2 = inPos + 16;
        in[n2] = in[n2] + in[inPos + 15];
        int n3 = inPos + 15;
        in[n3] = in[n3] + in[inPos + 14];
        int n4 = inPos + 14;
        in[n4] = in[n4] + in[inPos + 13];
        int n5 = inPos + 13;
        in[n5] = in[n5] + in[inPos + 12];
        int n6 = inPos + 12;
        in[n6] = in[n6] + in[inPos + 11];
        int n7 = inPos + 11;
        in[n7] = in[n7] + in[inPos + 10];
        int n8 = inPos + 10;
        in[n8] = in[n8] + in[inPos + 9];
        int n9 = inPos + 9;
        in[n9] = in[n9] + in[inPos + 8];
        int n10 = inPos + 8;
        in[n10] = in[n10] + in[inPos + 7];
        int n11 = inPos + 7;
        in[n11] = in[n11] + in[inPos + 6];
        int n12 = inPos + 6;
        in[n12] = in[n12] + in[inPos + 5];
        int n13 = inPos + 5;
        in[n13] = in[n13] + in[inPos + 4];
        int n14 = inPos + 4;
        in[n14] = in[n14] + in[inPos + 3];
        int n15 = inPos + 3;
        in[n15] = in[n15] + in[inPos + 2];
        int n16 = inPos + 2;
        in[n16] = in[n16] + in[inPos + 1];
        int n17 = inPos + 1;
        in[n17] = in[n17] + in[inPos + 0];
        int n18 = inPos + 17;
        in[n18] = in[n18] + in[inPos + 15];
        int n19 = inPos + 15;
        in[n19] = in[n19] + in[inPos + 13];
        int n20 = inPos + 13;
        in[n20] = in[n20] + in[inPos + 11];
        int n21 = inPos + 11;
        in[n21] = in[n21] + in[inPos + 9];
        int n22 = inPos + 9;
        in[n22] = in[n22] + in[inPos + 7];
        int n23 = inPos + 7;
        in[n23] = in[n23] + in[inPos + 5];
        int n24 = inPos + 5;
        in[n24] = in[n24] + in[inPos + 3];
        int n25 = inPos + 3;
        in[n25] = in[n25] + in[inPos + 1];
        float[] c = this.COS9;
        float[] out2 = o2;
        int out2Pos = o2Pos;
        float[] w = wintab;
        float[] out1 = o1;
        int out1Pos = o1Pos;
        float[] ts = tsbuf;
        float ta33 = in[inPos + 6 + 0] * c[3];
        float ta66 = in[inPos + 12 + 0] * c[6];
        float tb33 = in[inPos + 6 + 1] * c[3];
        float tb66 = in[inPos + 12 + 1] * c[6];
        float tmp1a = in[inPos + 2 + 0] * c[1] + ta33 + in[inPos + 10 + 0] * c[5] + in[inPos + 14 + 0] * c[7];
        float tmp1b = in[inPos + 2 + 1] * c[1] + tb33 + in[inPos + 10 + 1] * c[5] + in[inPos + 14 + 1] * c[7];
        float tmp2a = in[inPos + 0 + 0] + in[inPos + 4 + 0] * c[2] + in[inPos + 8 + 0] * c[4] + ta66 + in[inPos + 16 + 0] * c[8];
        float tmp2b = in[inPos + 0 + 1] + in[inPos + 4 + 1] * c[2] + in[inPos + 8 + 1] * c[4] + tb66 + in[inPos + 16 + 1] * c[8];
        float sum0 = tmp1a + tmp2a;
        float sum1 = (tmp1b + tmp2b) * this.tfcos36[0];
        float tmp = sum0 + sum1;
        out2[out2Pos + 9 + 0] = tmp * w[27];
        out2[out2Pos + 8 - 0] = tmp * w[26];
        ts[tsPos + 256] = out1[out1Pos + 8 - 0] + (sum0 -= sum1) * w[8];
        ts[tsPos + 288] = out1[out1Pos + 9 + 0] + sum0 * w[9];
        sum0 = tmp2a - tmp1a;
        sum1 = (tmp2b - tmp1b) * this.tfcos36[8];
        tmp = sum0 + sum1;
        out2[out2Pos + 9 + 8] = tmp * w[35];
        out2[out2Pos + 8 - 8] = tmp * w[18];
        ts[tsPos + 0] = out1[out1Pos + 8 - 8] + (sum0 -= sum1) * w[0];
        ts[tsPos + 544] = out1[out1Pos + 9 + 8] + sum0 * w[17];
        tmp1a = (in[inPos + 2 + 0] - in[inPos + 10 + 0] - in[inPos + 14 + 0]) * c[3];
        tmp1b = (in[inPos + 2 + 1] - in[inPos + 10 + 1] - in[inPos + 14 + 1]) * c[3];
        tmp2a = (in[inPos + 4 + 0] - in[inPos + 8 + 0] - in[inPos + 16 + 0]) * c[6] - in[inPos + 12 + 0] + in[inPos + 0 + 0];
        tmp2b = (in[inPos + 4 + 1] - in[inPos + 8 + 1] - in[inPos + 16 + 1]) * c[6] - in[inPos + 12 + 1] + in[inPos + 0 + 1];
        sum0 = tmp1a + tmp2a;
        sum1 = (tmp1b + tmp2b) * this.tfcos36[1];
        tmp = sum0 + sum1;
        out2[out2Pos + 9 + 1] = tmp * w[28];
        out2[out2Pos + 8 - 1] = tmp * w[25];
        ts[tsPos + 224] = out1[out1Pos + 8 - 1] + (sum0 -= sum1) * w[7];
        ts[tsPos + 320] = out1[out1Pos + 9 + 1] + sum0 * w[10];
        sum0 = tmp2a - tmp1a;
        sum1 = (tmp2b - tmp1b) * this.tfcos36[7];
        tmp = sum0 + sum1;
        out2[out2Pos + 9 + 7] = tmp * w[34];
        out2[out2Pos + 8 - 7] = tmp * w[19];
        ts[tsPos + 32] = out1[out1Pos + 8 - 7] + (sum0 -= sum1) * w[1];
        ts[tsPos + 512] = out1[out1Pos + 9 + 7] + sum0 * w[16];
        tmp1a = in[inPos + 2 + 0] * c[5] - ta33 - in[inPos + 10 + 0] * c[7] + in[inPos + 14 + 0] * c[1];
        tmp1b = in[inPos + 2 + 1] * c[5] - tb33 - in[inPos + 10 + 1] * c[7] + in[inPos + 14 + 1] * c[1];
        tmp2a = in[inPos + 0 + 0] - in[inPos + 4 + 0] * c[8] - in[inPos + 8 + 0] * c[2] + ta66 + in[inPos + 16 + 0] * c[4];
        tmp2b = in[inPos + 0 + 1] - in[inPos + 4 + 1] * c[8] - in[inPos + 8 + 1] * c[2] + tb66 + in[inPos + 16 + 1] * c[4];
        sum0 = tmp1a + tmp2a;
        sum1 = (tmp1b + tmp2b) * this.tfcos36[2];
        tmp = sum0 + sum1;
        out2[out2Pos + 9 + 2] = tmp * w[29];
        out2[out2Pos + 8 - 2] = tmp * w[24];
        ts[tsPos + 192] = out1[out1Pos + 8 - 2] + (sum0 -= sum1) * w[6];
        ts[tsPos + 352] = out1[out1Pos + 9 + 2] + sum0 * w[11];
        sum0 = tmp2a - tmp1a;
        sum1 = (tmp2b - tmp1b) * this.tfcos36[6];
        tmp = sum0 + sum1;
        out2[out2Pos + 9 + 6] = tmp * w[33];
        out2[out2Pos + 8 - 6] = tmp * w[20];
        ts[tsPos + 64] = out1[out1Pos + 8 - 6] + (sum0 -= sum1) * w[2];
        ts[tsPos + 480] = out1[out1Pos + 9 + 6] + sum0 * w[15];
        tmp1a = in[inPos + 2 + 0] * c[7] - ta33 + in[inPos + 10 + 0] * c[1] - in[inPos + 14 + 0] * c[5];
        tmp1b = in[inPos + 2 + 1] * c[7] - tb33 + in[inPos + 10 + 1] * c[1] - in[inPos + 14 + 1] * c[5];
        tmp2a = in[inPos + 0 + 0] - in[inPos + 4 + 0] * c[4] + in[inPos + 8 + 0] * c[8] + ta66 - in[inPos + 16 + 0] * c[2];
        tmp2b = in[inPos + 0 + 1] - in[inPos + 4 + 1] * c[4] + in[inPos + 8 + 1] * c[8] + tb66 - in[inPos + 16 + 1] * c[2];
        sum0 = tmp1a + tmp2a;
        sum1 = (tmp1b + tmp2b) * this.tfcos36[3];
        tmp = sum0 + sum1;
        out2[out2Pos + 9 + 3] = tmp * w[30];
        out2[out2Pos + 8 - 3] = tmp * w[23];
        ts[tsPos + 160] = out1[out1Pos + 8 - 3] + (sum0 -= sum1) * w[5];
        ts[tsPos + 384] = out1[out1Pos + 9 + 3] + sum0 * w[12];
        sum0 = tmp2a - tmp1a;
        sum1 = (tmp2b - tmp1b) * this.tfcos36[5];
        tmp = sum0 + sum1;
        out2[out2Pos + 9 + 5] = tmp * w[32];
        out2[out2Pos + 8 - 5] = tmp * w[21];
        ts[tsPos + 96] = out1[out1Pos + 8 - 5] + (sum0 -= sum1) * w[3];
        ts[tsPos + 448] = out1[out1Pos + 9 + 5] + sum0 * w[14];
        float sum02 = in[inPos + 0 + 0] - in[inPos + 4 + 0] + in[inPos + 8 + 0] - in[inPos + 12 + 0] + in[inPos + 16 + 0];
        float sum12 = (in[inPos + 0 + 1] - in[inPos + 4 + 1] + in[inPos + 8 + 1] - in[inPos + 12 + 1] + in[inPos + 16 + 1]) * this.tfcos36[4];
        float tmp2 = sum02 + sum12;
        out2[out2Pos + 9 + 4] = tmp2 * w[31];
        out2[out2Pos + 8 - 4] = tmp2 * w[22];
        ts[tsPos + 128] = out1[out1Pos + 8 - 4] + (sum02 -= sum12) * w[4];
        ts[tsPos + 416] = out1[out1Pos + 9 + 4] + sum02 * w[13];
    }

    private void dct12(float[] in, int inbufPos, float[] rawout1, int rawout1Pos, float[] rawout2, int rawout2Pos, float[] wi, float[] ts, int tsPos) {
        float[] out1 = rawout1;
        int out1Pos = rawout1Pos;
        ts[tsPos + 0] = out1[out1Pos + 0];
        ts[tsPos + 32] = out1[out1Pos + 1];
        ts[tsPos + 64] = out1[out1Pos + 2];
        ts[tsPos + 96] = out1[out1Pos + 3];
        ts[tsPos + 128] = out1[out1Pos + 4];
        ts[tsPos + 160] = out1[out1Pos + 5];
        float in5 = in[inbufPos + 15];
        float in4 = in[inbufPos + 12];
        in5 += in4;
        float in3 = in[inbufPos + 9];
        in4 += in3;
        float in2 = in[inbufPos + 6];
        in3 += in2;
        float in1 = in[inbufPos + 3];
        in2 += in1;
        float in0 = in[inbufPos + 0];
        in5 += in3;
        in3 += (in1 += in0);
        in2 *= this.COS6_1;
        in3 *= this.COS6_1;
        float tmp1 = in0 - in4;
        float tmp2 = (in1 - in5) * this.tfcos12[1];
        float tmp0 = tmp1 + tmp2;
        ts[tsPos + 512] = out1[out1Pos + 17 - 1] + tmp0 * wi[10];
        ts[tsPos + 416] = out1[out1Pos + 12 + 1] + tmp0 * wi[7];
        ts[tsPos + 224] = out1[out1Pos + 6 + 1] + (tmp1 -= tmp2) * wi[1];
        ts[tsPos + 320] = out1[out1Pos + 11 - 1] + tmp1 * wi[4];
        in0 += in4 * this.COS6_2;
        in4 = in0 + in2;
        in0 -= in2;
        in1 += in5 * this.COS6_2;
        in5 = (in1 + in3) * this.tfcos12[0];
        in1 = (in1 - in3) * this.tfcos12[2];
        in3 = in4 + in5;
        in4 -= in5;
        in2 = in0 + in1;
        ts[tsPos + 544] = out1[out1Pos + 17 - 0] + in2 * wi[11];
        ts[tsPos + 384] = out1[out1Pos + 12 + 0] + in2 * wi[6];
        ts[tsPos + 448] = out1[out1Pos + 12 + 2] + in3 * wi[8];
        ts[tsPos + 480] = out1[out1Pos + 17 - 2] + in3 * wi[9];
        ts[tsPos + 192] = out1[out1Pos + 6 + 0] + (in0 -= in1) * wi[0];
        ts[tsPos + 352] = out1[out1Pos + 11 - 0] + in0 * wi[5];
        ts[tsPos + 256] = out1[out1Pos + 6 + 2] + in4 * wi[2];
        ts[tsPos + 288] = out1[out1Pos + 11 - 2] + in4 * wi[3];
        float[] out2 = rawout2;
        int out2Pos = rawout2Pos;
        in5 = in[++inbufPos + 15];
        in4 = in[inbufPos + 12];
        in5 += in4;
        in3 = in[inbufPos + 9];
        in4 += in3;
        in2 = in[inbufPos + 6];
        in3 += in2;
        in1 = in[inbufPos + 3];
        in2 += in1;
        in0 = in[inbufPos + 0];
        in5 += in3;
        in3 += (in1 += in0);
        in2 *= this.COS6_1;
        in3 *= this.COS6_1;
        tmp1 = in0 - in4;
        tmp2 = (in1 - in5) * this.tfcos12[1];
        tmp0 = tmp1 + tmp2;
        out2[out2Pos + 5 - 1] = tmp0 * wi[10];
        out2[out2Pos + 0 + 1] = tmp0 * wi[7];
        int n = tsPos + 416;
        ts[n] = ts[n] + (tmp1 -= tmp2) * wi[1];
        int n2 = tsPos + 512;
        ts[n2] = ts[n2] + tmp1 * wi[4];
        in0 += in4 * this.COS6_2;
        in4 = in0 + in2;
        in0 -= in2;
        in1 += in5 * this.COS6_2;
        in5 = (in1 + in3) * this.tfcos12[0];
        in1 = (in1 - in3) * this.tfcos12[2];
        in3 = in4 + in5;
        in4 -= in5;
        in2 = in0 + in1;
        in0 -= in1;
        out2[out2Pos + 5 - 0] = in2 * wi[11];
        out2[out2Pos + 0 + 0] = in2 * wi[6];
        out2[out2Pos + 0 + 2] = in3 * wi[8];
        out2[out2Pos + 5 - 2] = in3 * wi[9];
        int n3 = tsPos + 384;
        ts[n3] = ts[n3] + in0 * wi[0];
        int n4 = tsPos + 544;
        ts[n4] = ts[n4] + in0 * wi[5];
        int n5 = tsPos + 448;
        ts[n5] = ts[n5] + in4 * wi[2];
        int n6 = tsPos + 480;
        ts[n6] = ts[n6] + in4 * wi[3];
        ++inbufPos;
        out2 = rawout2;
        out2Pos = rawout2Pos;
        out2[out2Pos + 17] = 0.0f;
        out2[out2Pos + 16] = 0.0f;
        out2[out2Pos + 15] = 0.0f;
        out2[out2Pos + 14] = 0.0f;
        out2[out2Pos + 13] = 0.0f;
        out2[out2Pos + 12] = 0.0f;
        in5 = in[inbufPos + 15];
        in4 = in[inbufPos + 12];
        in5 += in4;
        in3 = in[inbufPos + 9];
        in4 += in3;
        in2 = in[inbufPos + 6];
        in3 += in2;
        in1 = in[inbufPos + 3];
        in2 += in1;
        in0 = in[inbufPos + 0];
        in5 += in3;
        in3 += (in1 += in0);
        in2 *= this.COS6_1;
        in3 *= this.COS6_1;
        tmp1 = in0 - in4;
        tmp2 = (in1 - in5) * this.tfcos12[1];
        tmp0 = tmp1 + tmp2;
        out2[out2Pos + 11 - 1] = tmp0 * wi[10];
        out2[out2Pos + 6 + 1] = tmp0 * wi[7];
        int n7 = out2Pos + 0 + 1;
        out2[n7] = out2[n7] + (tmp1 -= tmp2) * wi[1];
        int n8 = out2Pos + 5 - 1;
        out2[n8] = out2[n8] + tmp1 * wi[4];
        in0 += in4 * this.COS6_2;
        in4 = in0 + in2;
        in0 -= in2;
        in1 += in5 * this.COS6_2;
        in5 = (in1 + in3) * this.tfcos12[0];
        in1 = (in1 - in3) * this.tfcos12[2];
        in3 = in4 + in5;
        in4 -= in5;
        in2 = in0 + in1;
        in0 -= in1;
        out2[out2Pos + 11 - 0] = in2 * wi[11];
        out2[out2Pos + 6 + 0] = in2 * wi[6];
        out2[out2Pos + 6 + 2] = in3 * wi[8];
        out2[out2Pos + 11 - 2] = in3 * wi[9];
        int n9 = out2Pos + 0 + 0;
        out2[n9] = out2[n9] + in0 * wi[0];
        int n10 = out2Pos + 5 - 0;
        out2[n10] = out2[n10] + in0 * wi[5];
        int n11 = out2Pos + 0 + 2;
        out2[n11] = out2[n11] + in4 * wi[2];
        int n12 = out2Pos + 5 - 2;
        out2[n12] = out2[n12] + in4 * wi[3];
    }

    private void III_hybrid(MPGLib.mpstr_tag mp, float[] fsIn, float[] tsOut, int ch, MPG123.gr_info_s gr_infos) {
        int bt;
        float[] tspnt = tsOut;
        int tspntPos = 0;
        float[][][] block = mp.hybrid_block;
        int[] blc = mp.hybrid_blc;
        int sb = 0;
        int b = blc[ch];
        float[] rawout1 = block[b][ch];
        int rawout1Pos = 0;
        b = -b + 1;
        float[] rawout2 = block[b][ch];
        int rawout2Pos = 0;
        blc[ch] = b;
        if (gr_infos.mixed_block_flag != 0) {
            sb = 2;
            this.dct36(fsIn, 0, rawout1, rawout1Pos, rawout2, rawout2Pos, this.win[0], tspnt, tspntPos + 0);
            this.dct36(fsIn, 18, rawout1, rawout1Pos + 18, rawout2, rawout2Pos + 18, this.win1[0], tspnt, tspntPos + 1);
            rawout1Pos += 36;
            rawout2Pos += 36;
            tspntPos += 2;
        }
        if ((bt = gr_infos.block_type) == 2) {
            while (sb < gr_infos.maxb) {
                this.dct12(fsIn, sb * 18, rawout1, rawout1Pos, rawout2, rawout2Pos, this.win[2], tspnt, tspntPos + 0);
                this.dct12(fsIn, (sb + 1) * 18, rawout1, rawout1Pos + 18, rawout2, rawout2Pos + 18, this.win1[2], tspnt, tspntPos + 1);
                sb += 2;
                tspntPos += 2;
                rawout1Pos += 36;
                rawout2Pos += 36;
            }
        } else {
            while (sb < gr_infos.maxb) {
                this.dct36(fsIn, sb * 18, rawout1, rawout1Pos, rawout2, rawout2Pos, this.win[bt], tspnt, tspntPos + 0);
                this.dct36(fsIn, (sb + 1) * 18, rawout1, rawout1Pos + 18, rawout2, rawout2Pos + 18, this.win1[bt], tspnt, tspntPos + 1);
                sb += 2;
                tspntPos += 2;
                rawout1Pos += 36;
                rawout2Pos += 36;
            }
        }
        while (sb < 32) {
            for (int i = 0; i < 18; ++i) {
                tspnt[tspntPos + i * 32] = rawout1[rawout1Pos++];
                rawout2[rawout2Pos++] = 0.0f;
            }
            ++sb;
            ++tspntPos;
        }
    }

    public int layer3_audiodata_precedesframes(MPGLib.mpstr_tag mp) {
        int audioDataInFrame = mp.bsize - 4 - mp.ssize;
        int framesToBacktrack = (this.sideinfo.main_data_begin + audioDataInFrame - 1) / audioDataInFrame;
        return framesToBacktrack;
    }

    public int do_layer3_sideinfo(MPGLib.mpstr_tag mp) {
        int granules;
        Frame fr = mp.fr;
        int stereo = fr.stereo;
        int single = fr.single;
        int sfreq = fr.sampling_frequency;
        if (stereo == 1) {
            single = 0;
        }
        int ms_stereo = fr.mode == 1 ? fr.mode_ext & 2 : 0;
        if (fr.lsf != 0) {
            granules = 1;
            this.III_get_side_info_2(mp, this.sideinfo, stereo, ms_stereo, sfreq, single);
        } else {
            granules = 2;
            this.III_get_side_info_1(mp, this.sideinfo, stereo, ms_stereo, sfreq, single);
        }
        int databits = 0;
        for (int gr = 0; gr < granules; ++gr) {
            for (int ch = 0; ch < stereo; ++ch) {
                MPG123.gr_info_s gr_infos = this.sideinfo.ch[ch].gr[gr];
                databits += gr_infos.part2_3_length;
            }
        }
        return databits - 8 * this.sideinfo.main_data_begin;
    }

    public int do_layer3(MPGLib.mpstr_tag mp, float[] pcm_sample, MPGLib.ProcessedBytes pcm_point, Interface.ISynth synth) {
        int i_stereo;
        int ms_stereo;
        int stereo1;
        int clip = 0;
        int[][] scalefacs = new int[2][39];
        Frame fr = mp.fr;
        int stereo = fr.stereo;
        int single = fr.single;
        int sfreq = fr.sampling_frequency;
        if (this.common.set_pointer(mp, this.sideinfo.main_data_begin) == -1) {
            return 0;
        }
        if (stereo == 1) {
            stereo1 = 1;
            single = 0;
        } else {
            stereo1 = single >= 0 ? 1 : 2;
        }
        if (fr.mode == 1) {
            ms_stereo = fr.mode_ext & 2;
            i_stereo = fr.mode_ext & 1;
        } else {
            i_stereo = 0;
            ms_stereo = 0;
        }
        int granules = fr.lsf != 0 ? 1 : 2;
        for (int gr = 0; gr < granules; ++gr) {
            int ss;
            int ch;
            int i;
            MPG123.gr_info_s gr_infos = this.sideinfo.ch[0].gr[gr];
            int part2bits = fr.lsf != 0 ? this.III_get_scale_factors_2(mp, scalefacs[0], gr_infos, 0) : this.III_get_scale_factors_1(mp, scalefacs[0], gr_infos);
            if (mp.pinfo != null) {
                mp.pinfo.sfbits[gr][0] = part2bits;
                for (i = 0; i < 39; ++i) {
                    mp.pinfo.sfb_s[gr][0][i] = scalefacs[0][i];
                }
            }
            if (this.III_dequantize_sample(mp, this.hybridIn[0], scalefacs[0], gr_infos, sfreq, part2bits) != 0) {
                return clip;
            }
            if (stereo == 2) {
                gr_infos = this.sideinfo.ch[1].gr[gr];
                part2bits = fr.lsf != 0 ? this.III_get_scale_factors_2(mp, scalefacs[1], gr_infos, i_stereo) : this.III_get_scale_factors_1(mp, scalefacs[1], gr_infos);
                if (mp.pinfo != null) {
                    mp.pinfo.sfbits[gr][1] = part2bits;
                    for (i = 0; i < 39; ++i) {
                        mp.pinfo.sfb_s[gr][1][i] = scalefacs[1][i];
                    }
                }
                if (this.III_dequantize_sample(mp, this.hybridIn[1], scalefacs[1], gr_infos, sfreq, part2bits) != 0) {
                    return clip;
                }
                if (ms_stereo != 0) {
                    for (i = 0; i < 576; ++i) {
                        float tmp0 = this.hybridIn[0][i];
                        float tmp1 = this.hybridIn[1][i];
                        this.hybridIn[1][i] = tmp0 - tmp1;
                        this.hybridIn[0][i] = tmp0 + tmp1;
                    }
                }
                if (i_stereo != 0) {
                    this.III_i_stereo(this.hybridIn, scalefacs[1], gr_infos, sfreq, ms_stereo, fr.lsf);
                }
                if (ms_stereo != 0 || i_stereo != 0 || single == 3) {
                    if (gr_infos.maxb > this.sideinfo.ch[0].gr[gr].maxb) {
                        this.sideinfo.ch[0].gr[gr].maxb = gr_infos.maxb;
                    } else {
                        gr_infos.maxb = this.sideinfo.ch[0].gr[gr].maxb;
                    }
                }
                switch (single) {
                    case 3: {
                        float[] in0 = this.hybridIn[0];
                        float[] in1 = this.hybridIn[1];
                        int in0Pos = 0;
                        int in1Pos = 0;
                        i = 0;
                        while (i < 18 * gr_infos.maxb) {
                            in0[in0Pos] = in0[in0Pos] + in1[in1Pos++];
                            ++i;
                            ++in0Pos;
                        }
                        break;
                    }
                    case 1: {
                        float[] in0 = this.hybridIn[0];
                        float[] in1 = this.hybridIn[1];
                        int in0Pos = 0;
                        int in1Pos = 0;
                        for (i = 0; i < 18 * gr_infos.maxb; ++i) {
                            in0[in0Pos++] = in1[in1Pos++];
                        }
                        break;
                    }
                }
            }
            if (mp.pinfo != null) {
                int sb;
                mp.pinfo.bitrate = Common.tabsel_123[fr.lsf][fr.lay - 1][fr.bitrate_index];
                mp.pinfo.sampfreq = Common.freqs[sfreq];
                mp.pinfo.emph = fr.emphasis;
                mp.pinfo.crc = fr.error_protection ? 1 : 0;
                mp.pinfo.padding = fr.padding;
                mp.pinfo.stereo = fr.stereo;
                mp.pinfo.js = fr.mode == 1 ? 1 : 0;
                mp.pinfo.ms_stereo = ms_stereo;
                mp.pinfo.i_stereo = i_stereo;
                mp.pinfo.maindata = this.sideinfo.main_data_begin;
                for (ch = 0; ch < stereo1; ++ch) {
                    MPG123.gr_info_s gr_infos2 = this.sideinfo.ch[ch].gr[gr];
                    mp.pinfo.big_values[gr][ch] = gr_infos2.big_values;
                    mp.pinfo.scalefac_scale[gr][ch] = gr_infos2.scalefac_scale;
                    mp.pinfo.mixed[gr][ch] = gr_infos2.mixed_block_flag;
                    mp.pinfo.mpg123blocktype[gr][ch] = gr_infos2.block_type;
                    mp.pinfo.mainbits[gr][ch] = gr_infos2.part2_3_length;
                    mp.pinfo.preflag[gr][ch] = gr_infos2.preflag;
                    if (gr != 1) continue;
                    mp.pinfo.scfsi[ch] = gr_infos2.scfsi;
                }
                for (ch = 0; ch < stereo1; ++ch) {
                    float ifqstep;
                    MPG123.gr_info_s gr_infos3 = this.sideinfo.ch[ch].gr[gr];
                    float f = ifqstep = mp.pinfo.scalefac_scale[gr][ch] == 0 ? 0.5f : 1.0f;
                    if (2 == gr_infos3.block_type) {
                        for (int i2 = 0; i2 < 3; ++i2) {
                            for (sb = 0; sb < 12; ++sb) {
                                int j = 3 * sb + i2;
                                mp.pinfo.sfb_s[gr][ch][j] = (double)(-ifqstep) * mp.pinfo.sfb_s[gr][ch][j - gr_infos3.mixed_block_flag];
                                double[] dArray = mp.pinfo.sfb_s[gr][ch];
                                int n = j;
                                dArray[n] = dArray[n] - (double)(2 * mp.pinfo.sub_gain[gr][ch][i2]);
                            }
                            mp.pinfo.sfb_s[gr][ch][3 * sb + i2] = -2 * mp.pinfo.sub_gain[gr][ch][i2];
                        }
                        continue;
                    }
                    sb = 0;
                    while (sb < 21) {
                        mp.pinfo.sfb[gr][ch][sb] = mp.pinfo.sfb_s[gr][ch][sb];
                        if (gr_infos3.preflag != 0) {
                            double[] dArray = mp.pinfo.sfb[gr][ch];
                            int n = sb;
                            dArray[n] = dArray[n] + (double)pretab1[sb];
                        }
                        double[] dArray = mp.pinfo.sfb[gr][ch];
                        int n = sb++;
                        dArray[n] = dArray[n] * (double)(-ifqstep);
                    }
                    mp.pinfo.sfb[gr][ch][21] = 0.0;
                }
                for (ch = 0; ch < stereo1; ++ch) {
                    int j = 0;
                    for (sb = 0; sb < 32; ++sb) {
                        ss = 0;
                        while (ss < 18) {
                            mp.pinfo.mpg123xr[gr][ch][j] = this.hybridIn[ch][sb * 18 + ss];
                            ++ss;
                            ++j;
                        }
                    }
                }
            }
            for (ch = 0; ch < stereo1; ++ch) {
                gr_infos = this.sideinfo.ch[ch].gr[gr];
                this.III_antialias(this.hybridIn[ch], gr_infos);
                this.III_hybrid(mp, this.hybridIn[ch], this.hybridOut[ch], ch, gr_infos);
            }
            for (ss = 0; ss < 18; ++ss) {
                if (single >= 0) {
                    clip += synth.synth_1to1_mono_ptr(mp, this.hybridOut[0], ss * 32, pcm_sample, pcm_point);
                    continue;
                }
                MPGLib.ProcessedBytes p1 = new MPGLib.ProcessedBytes();
                p1.pb = pcm_point.pb;
                clip += synth.synth_1to1_ptr(mp, this.hybridOut[0], ss * 32, 0, pcm_sample, p1);
                clip += synth.synth_1to1_ptr(mp, this.hybridOut[1], ss * 32, 1, pcm_sample, pcm_point);
            }
        }
        return clip;
    }

    private static class bandInfoStruct {
        short[] longIdx = new short[23];
        short[] longDiff = new short[22];
        short[] shortIdx = new short[14];
        short[] shortDiff = new short[13];

        public bandInfoStruct(short[] lIdx, short[] lDiff, short[] sIdx, short[] sDiff) {
            this.longIdx = lIdx;
            this.longDiff = lDiff;
            this.shortIdx = sIdx;
            this.shortDiff = sDiff;
        }
    }
}

