/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini.converter;

import java.beans.Introspector;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class BeanToStringConverter {
    private BeanToStringConverter() {
    }

    public static String toString(Object bean) {
        return BeanToStringConverter.defaultIfThrows(b -> Arrays.asList(Introspector.getBeanInfo(b.getClass(), Object.class).getPropertyDescriptors()).stream().filter(descriptor -> Objects.nonNull(descriptor.getReadMethod())).map(BeanToStringConverter.defaultIfThrows(descriptor -> new AbstractMap.SimpleImmutableEntry<String, Object>(descriptor.getName(), descriptor.getReadMethod().invoke(b, new Object[0])), descriptor -> new AbstractMap.SimpleImmutableEntry<String, String>(descriptor.getName(), "<bean value could not be determined>"))).map(AbstractMap.SimpleImmutableEntry::toString).collect(Collectors.joining("\n")), b -> "<bean introspection failed>").apply(bean);
    }

    private static <T, R> Function<T, R> defaultIfThrows(FunctionThatThrows<T, R> delegate, Function<T, R> defaultValueSupplier) {
        return x -> {
            try {
                return delegate.apply(x);
            }
            catch (Throwable throwable) {
                return defaultValueSupplier.apply(x);
            }
        };
    }

    @FunctionalInterface
    private static interface FunctionThatThrows<T, R> {
        public R apply(T var1) throws Throwable;
    }
}

