/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.io.DecoratingInputStream;

@ThreadSafe
public class LockInputStream
extends DecoratingInputStream {
    private final Lock lock;

    protected LockInputStream(Lock lock) {
        this.lock = Objects.requireNonNull(lock);
    }

    public LockInputStream(Lock lock, @WillCloseWhenClosed InputStream in) {
        this(lock);
        this.in = Objects.requireNonNull(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int read() throws IOException {
        this.lock.lock();
        try {
            int n = this.in.read();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int read(byte[] b, int off, int len) throws IOException {
        this.lock.lock();
        try {
            int n = this.in.read(b, off, len);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public long skip(long n) throws IOException {
        this.lock.lock();
        try {
            long l = this.in.skip(n);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int available() throws IOException {
        this.lock.lock();
        try {
            int n = this.in.available();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void mark(int readlimit) {
        this.lock.lock();
        try {
            this.in.mark(readlimit);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void reset() throws IOException {
        this.lock.lock();
        try {
            this.in.reset();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public boolean markSupported() {
        this.lock.lock();
        try {
            boolean bl = this.in.markSupported();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DischargesObligation
    @GuardedBy(value="lock")
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.in.close();
        }
        finally {
            this.lock.unlock();
        }
    }
}

