/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class PSidHeader {
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final int SIZE = 124;
    public static final int DATA_OFFSET_FIELD = 6;
    byte[] id = new byte[4];
    short version;
    short data;
    short load;
    short init;
    short play;
    short songs;
    short start;
    int speed;
    byte[] name = new byte[32];
    byte[] author = new byte[32];
    byte[] released = new byte[32];
    short flags;
    byte relocStartPage;
    byte relocPages;
    byte sidChip2MiddleNybbles;
    byte sidChip3MiddleNybbles;
    short[] furtherFlags;

    public PSidHeader(byte[] header) {
        ByteBuffer buffer = ByteBuffer.wrap(header);
        buffer.get(this.id);
        this.version = buffer.getShort();
        this.data = buffer.getShort();
        this.load = buffer.getShort();
        this.init = buffer.getShort();
        this.play = buffer.getShort();
        this.songs = buffer.getShort();
        this.start = buffer.getShort();
        this.speed = buffer.getInt();
        buffer.get(this.name);
        buffer.get(this.author);
        buffer.get(this.released);
        if (this.version >= 2) {
            this.flags = buffer.getShort();
            this.relocStartPage = buffer.get();
            this.relocPages = buffer.get();
        }
        if (this.version == 78) {
            this.furtherFlags = new short[this.data - 124 >> 1];
            for (int i = 0; i < this.furtherFlags.length; ++i) {
                this.furtherFlags[i] = buffer.getShort();
            }
        } else {
            if (this.version >= 3) {
                this.sidChip2MiddleNybbles = buffer.get();
            }
            if (this.version >= 4) {
                this.sidChip3MiddleNybbles = buffer.get();
            }
        }
    }

    PSidHeader() {
    }

    public byte[] getArray() {
        ByteBuffer buffer = ByteBuffer.allocate(this.version == 78 ? (int)this.data : 124);
        buffer.put(this.id);
        buffer.putShort(this.version);
        buffer.putShort(this.data);
        buffer.putShort(this.load);
        buffer.putShort(this.init);
        buffer.putShort(this.play);
        buffer.putShort(this.songs);
        buffer.putShort(this.start);
        buffer.putInt(this.speed);
        buffer.put(this.name);
        buffer.put(this.author);
        buffer.put(this.released);
        if (this.version >= 2) {
            buffer.putShort(this.flags);
            buffer.put(this.relocStartPage);
            buffer.put(this.relocPages);
        }
        if (this.version == 78) {
            for (int i = 0; i < this.furtherFlags.length; ++i) {
                buffer.putShort(this.furtherFlags[i]);
            }
        } else {
            if (this.version >= 3) {
                buffer.put(this.sidChip2MiddleNybbles);
            }
            if (this.version >= 4) {
                buffer.put(this.sidChip3MiddleNybbles);
            }
        }
        return buffer.array();
    }

    static String getString(byte[] info) {
        StringBuilder result = new StringBuilder();
        String infoString = new String(info, ISO_8859_1);
        for (char ch : infoString.toCharArray()) {
            if (ch == '\u0000') break;
            result.append(ch);
        }
        return result.length() == 0 ? "<?>" : result.toString();
    }

    public String getName() {
        return PSidHeader.getString(this.name);
    }

    public String getAuthor() {
        return PSidHeader.getString(this.author);
    }

    public String getReleased() {
        return PSidHeader.getString(this.released);
    }
}

