/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.fingerprinting.spectrogram;

import java.util.ArrayList;
import libsidutils.fingerprinting.spectrogram.Window;
import org.jtransforms.fft.FloatFFT_1D;

public class Spectrogram {
    public final ArrayList<float[]> stft;
    public final float[] freq;
    public final float[] time;
    private final FloatFFT_1D fft;
    private final float[] fftData;

    public Spectrogram(short[] data, int windowsType, int windowSize, int overlap, float fs) {
        int dataLen = data.length;
        int stepSize = windowSize - overlap;
        this.stft = new ArrayList();
        this.freq = new float[windowSize / 2];
        this.time = new float[dataLen / stepSize];
        this.fft = new FloatFFT_1D((long)windowSize);
        this.fftData = new float[windowSize * 2];
        Window window = new Window(windowsType, windowSize);
        for (int i = 0; i < dataLen && i + windowSize <= data.length; i += stepSize) {
            float[] win;
            try {
                win = window.window(data, i);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.calcFFT(win);
            this.addSTFT();
        }
        this.calcFreq(fs);
        this.calcTime(fs, stepSize);
    }

    private void calcFFT(float[] win) {
        for (int i = 0; i < win.length; ++i) {
            this.fftData[i * 2] = win[i];
            this.fftData[i * 2 + 1] = 0.0f;
        }
        this.fft.complexForward(this.fftData);
    }

    private void addSTFT() {
        float[] half = new float[this.fftData.length / 2];
        System.arraycopy(this.fftData, 0, half, 0, this.fftData.length / 2);
        this.stft.add(half);
    }

    private void calcFreq(float fs) {
        for (int i = 0; i < this.freq.length; ++i) {
            this.freq[i] = fs * (float)i / (float)this.freq.length;
        }
    }

    private void calcTime(float fs, int stepSize) {
        for (int i = 0; i < this.time.length; ++i) {
            this.time[i] = (float)(stepSize * i) / fs;
        }
    }
}

