/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.File;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.access.TBIO;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TFile;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsAccessOptions;

@Immutable
public final class TFileOutputStream
extends DecoratingOutputStream {
    @CreatesObligation
    public TFileOutputStream(String path) throws IOException {
        this(path, false);
    }

    @CreatesObligation
    public TFileOutputStream(String path, boolean append) throws IOException {
        this((File)new TFile(path), append);
    }

    @CreatesObligation
    public TFileOutputStream(String path, FsAccessOption ... options) throws IOException {
        this((File)new TFile(path), options);
    }

    @CreatesObligation
    public TFileOutputStream(File file) throws IOException {
        this(file, false);
    }

    @CreatesObligation
    public TFileOutputStream(File file, boolean append) throws IOException {
        this(file, (BitField<FsAccessOption>)FsAccessOptions.NONE.set((Enum)FsAccessOption.APPEND, append));
    }

    @CreatesObligation
    public TFileOutputStream(File file, FsAccessOption ... options) throws IOException {
        this(file, (BitField<FsAccessOption>)FsAccessOptions.of((FsAccessOption[])options));
    }

    @CreatesObligation
    public TFileOutputStream(File file, BitField<FsAccessOption> options) throws IOException {
        super(TBIO.output((BitField<FsAccessOption>)TConfig.current().getAccessPreferences().or(options), file, null).stream(null));
    }
}

