/*
 * Decompiled with CFR 0.152.
 */
package builder.netsiddev;

import builder.netsiddev.NetSIDClient;
import builder.netsiddev.commands.Mute;
import builder.netsiddev.commands.SetClocking;
import builder.netsiddev.commands.TrySetSidModel;
import java.util.List;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.common.SIDEmu;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;

public class NetSIDDev
extends SIDEmu {
    private byte sidNum;
    private NetSIDClient client;
    private ChipModel chipModel;

    public NetSIDDev(NetSIDClient connection, int sidNum, ChipModel model) {
        this.client = connection;
        this.sidNum = (byte)sidNum;
        this.chipModel = model;
    }

    @Override
    public void reset(byte volume) {
    }

    @Override
    public byte read(int addr) {
        return this.client.read(this.sidNum, (byte)addr);
    }

    @Override
    public void write(int addr, byte data) {
        super.write(addr, data);
        this.client.write(this.sidNum, (byte)addr, data);
    }

    @Override
    public void clock() {
    }

    @Override
    public void setChipModel(ChipModel model) {
    }

    @Override
    public void setClockFrequency(double cpuFrequency) {
        this.client.addAndSend(new SetClocking(cpuFrequency));
    }

    @Override
    public void input(int input) {
    }

    @Override
    public void setDigiBoost(boolean digiBoost) {
    }

    @Override
    public void setVoiceMute(int voice, boolean mute) {
        if (this.client.getVersion() >= 3 || voice < 3) {
            this.client.addAndSend(new Mute(this.sidNum, (byte)voice, mute));
        }
    }

    @Override
    public void setFilter(IConfig config, int sidNum) {
        IEmulationSection emulationSection = config.getEmulationSection();
        String filterName = emulationSection.getFilterName(sidNum, Engine.NETSID, Emulation.DEFAULT, this.chipModel);
        if (filterName != null) {
            this.client.addAndSend(new TrySetSidModel((byte)sidNum, this.chipModel, filterName));
        }
    }

    @Override
    public void setFilterEnable(IEmulationSection emulation, int sidNum) {
        System.err.println("Filter enable unsupported by network SID client");
    }

    public static String credits() {
        String credit = "Network SID Client:\n";
        credit = credit + "\tCopyright (\u00a9) 2017 Ken H\u00e4ndel\n";
        credit = credit + "\thttp://sourceforge.net/projects/jsidplay2/\n";
        return credit;
    }

    public static class FakeStereo
    extends NetSIDDev {
        private final IEmulationSection emulationSection;
        private final int prevNum;
        private final List<NetSIDDev> sids;

        public FakeStereo(NetSIDClient connection, int sidNum, ChipModel model, IConfig config, List<NetSIDDev> sids) {
            super(connection, sidNum, model);
            this.emulationSection = config.getEmulationSection();
            this.prevNum = sidNum - 1;
            this.sids = sids;
        }

        @Override
        public byte read(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).read(addr);
            }
            return super.read(addr);
        }

        @Override
        public byte readInternalRegister(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).readInternalRegister(addr);
            }
            return super.readInternalRegister(addr);
        }

        @Override
        public void write(int addr, byte data) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                this.sids.get(this.prevNum).write(addr, data);
                super.write(addr, data);
            } else {
                super.write(addr, data);
                this.sids.get(this.prevNum).write(addr, data);
            }
        }
    }
}

