/*
 * Decompiled with CFR 0.152.
 */
package ui.diskcollection;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import ui.common.comparator.FileComparator;

public class DiskCollectionTreeItem
extends TreeItem<File> {
    private File rootFile;
    private FileFilter fileFilter;
    private boolean hasLoadedChildren;
    private boolean isLeaf;

    public DiskCollectionTreeItem(File file, File rootFile, FileFilter fileFilter) {
        super((Object)file);
        this.rootFile = rootFile;
        this.isLeaf = file.isFile();
        this.fileFilter = fileFilter;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public ObservableList<TreeItem<File>> getChildren() {
        if (!this.hasLoadedChildren) {
            this.loadChildren();
        }
        return super.getChildren();
    }

    private void loadChildren() {
        this.hasLoadedChildren = true;
        ArrayList children = new ArrayList();
        Arrays.stream(Optional.ofNullable(((File)this.getValue()).listFiles(this.fileFilter)).orElse(new File[0])).sorted(new FileComparator()).forEach(file -> children.add(new DiskCollectionTreeItem((File)file, this.rootFile, this.fileFilter)));
        super.getChildren().setAll(children);
    }
}

