/*
 * Decompiled with CFR 0.152.
 */
package server.netsiddev;

import builder.resid.resample.Resampler;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import libsidplay.common.CPUClock;
import libsidplay.common.SIDChip;
import libsidplay.common.SamplingMethod;
import server.netsiddev.AudioDevice;
import server.netsiddev.AudioDeviceCompare;
import server.netsiddev.SIDDeviceSettings;
import server.netsiddev.SIDWrite;
import sidplay.audio.AudioConfig;
import sidplay.audio.JavaSound;
import sidplay.fingerprinting.WhatsSidSupport;

public class AudioGeneratorThread
extends Thread {
    private static final Random RANDOM = new Random();
    private final AtomicLong playbackClock = new AtomicLong(0L);
    private final BlockingQueue<SIDWrite> sidCommandQueue;
    private boolean digiBoostEnabled = false;
    private SIDChip[] sids;
    private Resampler resamplerL;
    private Resampler resamplerR;
    private CPUClock sidClocking;
    private SamplingMethod sidSampling;
    private final AudioConfig audioConfig;
    private int oldRandomValue;
    private int[] sidLevel;
    private int deviceIndex;
    private int[] sidPositionL;
    private int[] sidPositionR;
    private int[] audioBufferPos;
    private IntBuffer[] delayedSamples;
    private long[] fadeInClocks;
    private long[] fadeOutClocks;
    private long[] fadeInStep;
    private long[] fadeOutStep;
    private long[] fadeInVal;
    private long[] fadeOutVal;
    private Mixer.Info mixerInfo;
    private boolean deviceChanged = false;
    private final AtomicBoolean audioWait = new AtomicBoolean(true);
    private final AtomicBoolean quicklyDiscardAudio = new AtomicBoolean(false);
    private JavaSound driver = new JavaSound();
    private int captureTime;
    private boolean whatsSidEnabled;
    private double minimumRelativeConfidence;
    private WhatsSidSupport whatsSidSupport;

    protected int triangularDithering() {
        int prevValue = this.oldRandomValue;
        this.oldRandomValue = RANDOM.nextInt() & 1;
        return this.oldRandomValue - prevValue;
    }

    public AudioGeneratorThread(AudioConfig config) {
        this.setPriority(10);
        this.sidCommandQueue = new LinkedBlockingQueue<SIDWrite>();
        this.audioConfig = config;
        SIDDeviceSettings settings = SIDDeviceSettings.getInstance();
        this.deviceIndex = settings.getDeviceIndex();
        this.digiBoostEnabled = settings.getDigiBoostEnabled();
        this.audioConfig.setAudioBufferSize(settings.getAudioBufferSize());
        this.audioConfig.setBufferFrames(settings.getAudioBufferSize());
        this.captureTime = settings.getWhatsSidCaptureTime();
        this.whatsSidEnabled = settings.isWhatsSidEnable();
        this.minimumRelativeConfidence = settings.getWhatsSidMinimumRelativeConfidence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.initDriver();
            int audioLength = 10000;
            int[] outAudioBuffer = new int[20000];
            BlockingQueue<SIDWrite> blockingQueue = this.sidCommandQueue;
            synchronized (blockingQueue) {
                this.sidCommandQueue.wait();
                this.audioWait.set(false);
            }
            this.refreshParams();
            while (!AudioGeneratorThread.interrupted()) {
                int piece;
                SIDWrite write = (SIDWrite)this.sidCommandQueue.poll();
                if (write == null) {
                    long predictedExhaustionTime = System.currentTimeMillis() + (long)this.driver.getRemainingPlayTime();
                    while (!this.quicklyDiscardAudio.get() && System.currentTimeMillis() < predictedExhaustionTime && (write = this.sidCommandQueue.poll(1L, TimeUnit.MILLISECONDS)) == null) {
                    }
                    this.quicklyDiscardAudio.getAndSet(false);
                    if (write == null) {
                        Object object = this.audioWait;
                        synchronized (object) {
                            this.audioWait.set(true);
                            this.audioWait.notify();
                        }
                        this.driver.flush();
                        this.driver.pause();
                        object = this.sidCommandQueue;
                        synchronized (object) {
                            this.sidCommandQueue.wait();
                            this.audioWait.set(false);
                            continue;
                        }
                    }
                }
                for (int cycles = write.getCycles(); cycles != 0; cycles -= piece) {
                    piece = Math.min(cycles, 10000);
                    for (int sidNum = 0; sidNum < this.sids.length; ++sidNum) {
                        int sid = sidNum;
                        this.audioBufferPos[sid] = 0;
                        this.sids[sidNum].clock(piece, sample -> {
                            Object[] objectArray = this.delayedSamples;
                            synchronized (this.delayedSamples) {
                                IntBuffer delayedSamples = this.delayedSamples[sid];
                                if (!delayedSamples.put(sample).hasRemaining()) {
                                    ((Buffer)delayedSamples).flip();
                                }
                                sample = delayedSamples.get(delayedSamples.position());
                                // ** MonitorExit[var4_4 /* !! */ ] (shouldn't be in output)
                                objectArray = this.fadeInClocks;
                                synchronized (this.fadeInClocks) {
                                    if (this.fadeInClocks[sid] > 0L) {
                                        int n = sid;
                                        this.fadeInClocks[n] = this.fadeInClocks[n] - 1L;
                                        int n2 = sid;
                                        this.fadeInVal[n2] = this.fadeInVal[n2] - 1L;
                                        if (this.fadeInVal[n2] == 0L) {
                                            this.fadeInVal[sid] = this.fadeInStep[sid];
                                            int n3 = sid;
                                            this.sidLevel[n3] = this.sidLevel[n3] + 1;
                                        }
                                    } else if (this.fadeOutClocks[sid] > 0L) {
                                        int n = sid;
                                        this.fadeOutClocks[n] = this.fadeOutClocks[n] - 1L;
                                        int n4 = sid;
                                        this.fadeOutVal[n4] = this.fadeOutVal[n4] - 1L;
                                        if (this.fadeOutVal[n4] == 0L) {
                                            this.fadeOutVal[sid] = this.fadeOutStep[sid];
                                            int n5 = sid;
                                            this.sidLevel[n5] = this.sidLevel[n5] - 1;
                                        }
                                    }
                                    // ** MonitorExit[var4_4 /* !! */ ] (shouldn't be in output)
                                    sample = sample * this.sidLevel[sid] >> 10;
                                    int n = this.audioBufferPos[sid] << 1 | 0;
                                    outAudioBuffer[n] = outAudioBuffer[n] + (sample * this.sidPositionL[sid] >> 10);
                                    int n6 = sid;
                                    int n7 = this.audioBufferPos[n6];
                                    this.audioBufferPos[n6] = n7 + 1;
                                    int n8 = n7 << 1 | 1;
                                    outAudioBuffer[n8] = outAudioBuffer[n8] + (sample * this.sidPositionR[sid] >> 10);
                                    return;
                                }
                            }
                        });
                    }
                    ByteBuffer output = this.driver.buffer();
                    for (int i = 0; i < piece; ++i) {
                        int dithering = this.triangularDithering();
                        int value = outAudioBuffer[i << 1 | 0];
                        if (this.resamplerL.input(value)) {
                            value = this.resamplerL.output() + dithering;
                            if (value > Short.MAX_VALUE) {
                                value = Short.MAX_VALUE;
                            }
                            if (value < Short.MIN_VALUE) {
                                value = Short.MIN_VALUE;
                            }
                            output.putShort((short)value);
                        }
                        if (this.resamplerR.input(value = outAudioBuffer[i << 1 | 1])) {
                            value = this.resamplerR.output() + dithering;
                            if (value > Short.MAX_VALUE) {
                                value = Short.MAX_VALUE;
                            }
                            if (value < Short.MIN_VALUE) {
                                value = Short.MIN_VALUE;
                            }
                            output.putShort((short)value);
                        }
                        if (this.whatsSidEnabled) {
                            this.whatsSidSupport.output(outAudioBuffer[i << 1 | 0], outAudioBuffer[i << 1 | 1]);
                        }
                        outAudioBuffer[i << 1 | 0] = 0;
                        outAudioBuffer[i << 1 | 1] = 0;
                        if (output.hasRemaining()) continue;
                        this.driver.write();
                        ((Buffer)output).clear();
                    }
                    this.playbackClock.addAndGet(piece);
                }
                if (write.isEnd()) {
                    ByteBuffer output = this.driver.buffer();
                    if (output.position() != 0) {
                        while (output.hasRemaining()) {
                            output.putShort((short)0);
                            output.putShort((short)0);
                        }
                        this.driver.write();
                    }
                    break;
                }
                if (!write.isPureDelay()) {
                    this.sids[write.getChip()].write(write.getRegister(), write.getValue());
                }
                if (!this.deviceChanged) continue;
                this.initDriver();
                this.deviceChanged = false;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        finally {
            this.driver.close();
        }
    }

    public void reset(int sidNumber, byte volume) {
        this.sids[sidNumber].reset();
        this.sids[sidNumber].write(24, volume);
    }

    public void reopen() {
        this.deviceChanged = true;
        if (this.whatsSidEnabled) {
            this.whatsSidSupport.reset();
        }
    }

    private void initDriver() throws LineUnavailableException {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = new JavaSound();
        Vector<AudioDevice> audioDevices = new Vector<AudioDevice>();
        AudioDeviceCompare cmp = new AudioDeviceCompare();
        int theDeviceIndex = 0;
        for (Mixer.Info deviceInfo : JavaSound.getDeviceInfos()) {
            AudioDevice audioDeviceItem = new AudioDevice(theDeviceIndex, deviceInfo);
            audioDevices.add(audioDeviceItem);
            if (theDeviceIndex == 0) {
                cmp.setPrimaryDeviceName(deviceInfo.getName());
            }
            if (this.mixerInfo == null) {
                if (audioDeviceItem.getIndex() == this.deviceIndex) {
                    this.mixerInfo = deviceInfo;
                }
            } else if (this.mixerInfo.getName() == deviceInfo.getName()) {
                this.mixerInfo = deviceInfo;
            }
            ++theDeviceIndex;
        }
        Collections.sort(audioDevices, cmp);
        this.driver.open(this.audioConfig, this.mixerInfo);
    }

    public void mute(int sidNumber, int voiceNo, boolean mute) {
        this.sids[sidNumber].mute(voiceNo, mute);
    }

    public void changeDevice(Mixer.Info deviceInfo) {
        this.mixerInfo = deviceInfo;
        this.deviceChanged = true;
    }

    public void setAudioBufferSize(Integer audioBufferSize) {
        this.audioConfig.setAudioBufferSize(audioBufferSize);
        this.audioConfig.setBufferFrames(audioBufferSize);
        this.deviceChanged = true;
    }

    public void setClocking(CPUClock clock) {
        this.sidClocking = clock;
        this.refreshParams();
    }

    public void setSampling(SamplingMethod samplingMethod) {
        this.sidSampling = samplingMethod;
        this.refreshParams();
    }

    private void refreshParams() {
        for (SIDChip sid : this.sids) {
            sid.setClockFrequency(this.sidClocking.getCpuFrequency());
        }
        this.resamplerL = Resampler.createResampler(this.sidClocking.getCpuFrequency(), this.sidSampling, this.audioConfig.getFrameRate(), 20000.0);
        this.resamplerR = Resampler.createResampler(this.sidClocking.getCpuFrequency(), this.sidSampling, this.audioConfig.getFrameRate(), 20000.0);
    }

    public void setPosition(int sidNumber, int position) {
        if (this.sids.length > 1) {
            float leftFraction = position <= 0 ? 1.0f : (float)(100 - position) / 100.0f;
            float rightFraction = position >= 0 ? 1.0f : (float)(100 + position) / 100.0f;
            this.sidPositionL[sidNumber] = (int)(1024.0f * leftFraction);
            this.sidPositionR[sidNumber] = (int)(1024.0f * rightFraction);
        } else {
            this.sidPositionL[sidNumber] = 1024;
            this.sidPositionR[sidNumber] = 1024;
        }
    }

    public void setLevelAdjustment(int sid, int level) {
        this.sidLevel[sid] = (int)(1024.0 * Math.pow(10.0, (double)level / 100.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelay(int sid, int delay) {
        IntBuffer[] intBufferArray = this.delayedSamples;
        synchronized (this.delayedSamples) {
            int delayedSamples = (int)(this.sidClocking.getCpuFrequency() / 1000.0 * (double)delay);
            this.delayedSamples[sid] = ByteBuffer.allocateDirect(4 * (delayedSamples + 1)).order(ByteOrder.nativeOrder()).asIntBuffer().put(new int[delayedSamples + 1]);
            ((Buffer)this.delayedSamples[sid]).flip();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFadeIn(float fadeIn) {
        long[] lArray = this.fadeInClocks;
        synchronized (this.fadeInClocks) {
            for (int sid = 0; sid < this.sids.length; ++sid) {
                this.fadeInClocks[sid] = (long)((double)fadeIn * this.sidClocking.getCpuFrequency());
                this.fadeInStep[sid] = this.sidLevel[sid] != 0 ? this.fadeInClocks[sid] / (long)this.sidLevel[sid] : 0L;
                this.fadeInVal[sid] = this.fadeInStep[sid];
                this.sidLevel[sid] = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFadeOut(float fadeOut) {
        long[] lArray = this.fadeInClocks;
        synchronized (this.fadeInClocks) {
            for (int sid = 0; sid < this.sids.length; ++sid) {
                this.fadeOutClocks[sid] = (long)((double)fadeOut * this.sidClocking.getCpuFrequency());
                this.fadeOutStep[sid] = this.sidLevel[sid] != 0 ? this.fadeOutClocks[sid] / (long)this.sidLevel[sid] : 0L;
                this.fadeOutVal[sid] = this.fadeOutStep[sid];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public BlockingQueue<SIDWrite> getSidCommandQueue() {
        return this.sidCommandQueue;
    }

    public JavaSound getDriver() {
        return this.driver;
    }

    public long getPlaybackClock() {
        return this.playbackClock.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureDraining() {
        BlockingQueue<SIDWrite> blockingQueue = this.sidCommandQueue;
        synchronized (blockingQueue) {
            this.sidCommandQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureQuickDraining() {
        BlockingQueue<SIDWrite> blockingQueue = this.sidCommandQueue;
        synchronized (blockingQueue) {
            this.quicklyDiscardAudio.getAndSet(true);
            this.sidCommandQueue.notify();
        }
    }

    public boolean isWaitingForCommands() {
        return this.audioWait.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilQueueReady(long timeout) {
        boolean isQueueReady = this.audioWait.get();
        if (!isQueueReady) {
            this.ensureQuickDraining();
            try {
                AtomicBoolean atomicBoolean = this.audioWait;
                synchronized (atomicBoolean) {
                    this.audioWait.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            isQueueReady = this.audioWait.get();
        }
        return isQueueReady;
    }

    public void setSidArray(SIDChip[] sid) {
        this.sids = sid;
        this.sidClocking = CPUClock.PAL;
        this.sidSampling = SamplingMethod.DECIMATE;
        this.sidLevel = new int[sid.length];
        this.sidPositionL = new int[sid.length];
        this.sidPositionR = new int[sid.length];
        this.delayedSamples = new IntBuffer[sid.length];
        this.fadeInClocks = new long[sid.length];
        this.fadeOutClocks = new long[sid.length];
        this.fadeInStep = new long[sid.length];
        this.fadeOutStep = new long[sid.length];
        this.fadeInVal = new long[sid.length];
        this.fadeOutVal = new long[sid.length];
        this.audioBufferPos = new int[sid.length];
        for (int i = 0; i < sid.length; ++i) {
            this.setLevelAdjustment(i, 0);
            if (sid.length > 1) {
                this.setPosition(i, -100 + 200 * i / (sid.length - 1));
            } else {
                this.setPosition(i, 0);
            }
            this.setDelay(i, 0);
        }
        this.whatsSidSupport = new WhatsSidSupport(this.sidClocking.getCpuFrequency(), this.captureTime, this.minimumRelativeConfidence);
    }

    public void setSID(int sidNumber, SIDChip sidConfig) {
        this.sids[sidNumber] = sidConfig;
        this.setDigiBoost(this.digiBoostEnabled);
    }

    public void setDigiBoost(boolean selected) {
        this.digiBoostEnabled = selected;
        for (SIDChip sidChip : this.sids) {
            if (sidChip == null) continue;
            sidChip.setDigiBoost(this.digiBoostEnabled);
        }
    }

    public WhatsSidSupport getWhatsSidSupport() {
        return this.whatsSidSupport;
    }
}

