/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio.siddump;

import libsidutils.siddump.SIDDumpConfiguration;

public class Channel {
    public static final String[] NOTE_NAME = new String[]{"C-0", "C#0", "D-0", "D#0", "E-0", "F-0", "F#0", "G-0", "G#0", "A-0", "A#0", "B-0", "C-1", "C#1", "D-1", "D#1", "E-1", "F-1", "F#1", "G-1", "G#1", "A-1", "A#1", "B-1", "C-2", "C#2", "D-2", "D#2", "E-2", "F-2", "F#2", "G-2", "G#2", "A-2", "A#2", "B-2", "C-3", "C#3", "D-3", "D#3", "E-3", "F-3", "F#3", "G-3", "G#3", "A-3", "A#3", "B-3", "C-4", "C#4", "D-4", "D#4", "E-4", "F-4", "F#4", "G-4", "G#4", "A-4", "A#4", "B-4", "C-5", "C#5", "D-5", "D#5", "E-5", "F-5", "F#5", "G-5", "G#5", "A-5", "A#5", "B-5", "C-6", "C#6", "D-6", "D#6", "E-6", "F-6", "F#6", "G-6", "G#6", "A-6", "A#6", "B-6", "C-7", "C#7", "D-7", "D#7", "E-7", "F-7", "F#7", "G-7", "G#7", "A-7", "A#7", "B-7"};
    private int freq;
    private int pulse;
    private int adsr;
    private int wave;
    private int note;

    public int getFreq() {
        return this.freq;
    }

    public int getPulse() {
        return this.pulse;
    }

    public int getAdsr() {
        return this.adsr;
    }

    public int getWave() {
        return this.wave;
    }

    public int getNote() {
        return this.note;
    }

    public void setNote(int note) {
        this.note = note;
    }

    public void read(int channel, byte[] registers) {
        this.freq = registers[SIDDumpConfiguration.SIDDumpReg.FREQ_LO_1.getRegister() + 7 * channel] & 0xFF | (registers[SIDDumpConfiguration.SIDDumpReg.FREQ_HI_1.getRegister() + 7 * channel] & 0xFF) << 8;
        this.pulse = (registers[SIDDumpConfiguration.SIDDumpReg.PULSE_LO_1.getRegister() + 7 * channel] & 0xFF | (registers[SIDDumpConfiguration.SIDDumpReg.PULSE_HI_1.getRegister() + 7 * channel] & 0xFF) << 8) & 0xFFF;
        this.wave = registers[SIDDumpConfiguration.SIDDumpReg.WAVEFORM_1.getRegister() + 7 * channel] & 0xFF;
        this.adsr = registers[SIDDumpConfiguration.SIDDumpReg.SUSTAIN_RELEASE_1.getRegister() + 7 * channel] & 0xFF | (registers[SIDDumpConfiguration.SIDDumpReg.ATTACK_DECAY_1.getRegister() + 7 * channel] & 0xFF) << 8;
    }

    public void assign(Channel channel) {
        this.adsr = channel.adsr;
        this.freq = channel.freq;
        this.note = channel.note;
        this.pulse = channel.pulse;
        this.wave = channel.wave;
    }

    public String getNote(boolean prevChannelNote) {
        if (prevChannelNote) {
            return String.format("(%s %02X)", NOTE_NAME[this.note], this.note | 0x80);
        }
        return String.format(" %s %02X ", NOTE_NAME[this.note], this.note | 0x80);
    }
}

