/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.sidmapping;

import builder.jexsid.JExSIDMapping;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.FileRequestPathServletParameters;
import sidplay.ini.IniConfig;

@WebServlet(name="ExSIDMappingServlet", displayName="ExSIDMappingServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/exsid-mapping/*"}, description="Get ExSID(+) SID hardware mapping information")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class ExSIDMappingServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.ExSIDMappingServlet.MAX_EXSIDMAPPING_IN_PARALLEL, new DefaultThreadFactory("/exsidmapping"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.ExSIDMappingServlet.EXSIDMAPPING_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block4: {
                    try {
                        ExSIDMappingServletParameters servletParameters = new ExSIDMappingServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        File file = servletParameters.fetchFile(ExSIDMappingServlet.this.configuration, ExSIDMappingServlet.this.directoryProperties, parser, ExSIDMappingServlet.this.hasAdminAccess(request));
                        if (file == null || servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        IEmulationSection emulationSection = servletParameters.emulationSection;
                        SidTune tune = SidTune.load(file);
                        Map<Integer, String> result = JExSIDMapping.mapping(emulationSection, tune);
                        if (!this.isComplete()) {
                            ExSIDMappingServlet.this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, result);
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(ExSIDMappingServlet.this.getServletContext(), t, this.parentThread);
                        if (this.isComplete()) break block4;
                        response.setStatus(500);
                        ExSIDMappingServlet.this.setOutput(response, t);
                    }
                }
            }
        });
    }

    @Parameters(resourceBundle="server.restful.servlets.sidmapping.ExSIDMappingServletParameters")
    public static class ExSIDMappingServletParameters
    extends FileRequestPathServletParameters {
        @ParametersDelegate
        private IEmulationSection emulationSection = new IniConfig().getEmulationSection();
    }
}

