/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.preprocessor.directives;

import java.io.IOException;
import kickass.common.diagnostics.AsmError;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.preprocessor.PreProcessor;
import kickass.parsing.preprocessor.directives.IPreProcessorDirective;
import kickass.parsing.preprocessor.directives.PpdUtil;
import kickass.state.EvaluationState;

public class PpdImport
implements IPreProcessorDirective {
    private PreProcessor preprocessor;

    public PpdImport(PreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    @Override
    public void executeDirective(IToken iToken, TokenStreamList tokenStreamList) throws IOException {
        EvaluationState evaluationState = this.preprocessor.getState();
        if (!PpdUtil.ensureNoOfArguments(iToken, 1, tokenStreamList, evaluationState)) {
            return;
        }
        IToken iToken2 = tokenStreamList.get(0);
        if (iToken2.getType() != TokenType.StringQuote) {
            evaluationState.diagnosticMgr.add(new AsmError("Filename string expected", iToken2.getSourceRange()));
            return;
        }
        boolean bl = evaluationState.preprocessorMgr.isInPassiveState();
        if (bl) {
            return;
        }
        String string = iToken2.getStringValue();
        this.preprocessor.importFile(string, iToken2.getSourceRange());
    }
}

