/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.EventScheduler;
import libsidplay.config.IAudioSection;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;
import sidplay.audio.wav.WAVHeader;

public abstract class JWAVDriver
implements AudioDriver {
    protected OutputStream out;
    protected WAVHeader wavHeader;
    private ByteBuffer sampleBuffer;

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        AudioConfig cfg = new AudioConfig(audioSection);
        this.wavHeader = new WAVHeader(cfg.getChannels(), cfg.getFrameRate());
        this.out = this.getOut(recordingFilename);
        this.out.write(this.wavHeader.getBytes());
        this.sampleBuffer = ByteBuffer.allocate(cfg.getChunkFrames() * 2 * cfg.getChannels()).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void write() throws InterruptedException {
        try {
            this.out.write(this.sampleBuffer.array(), 0, this.sampleBuffer.position());
            this.wavHeader.advance(this.sampleBuffer.position());
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing WAV audio stream", e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    @Override
    public boolean isRecording() {
        return true;
    }

    @Override
    public String getExtension() {
        return ".wav";
    }

    protected abstract OutputStream getOut(String var1) throws IOException;

    public static class JWAVStreamDriver
    extends JWAVDriver {
        public JWAVStreamDriver(OutputStream out) {
            this.out = out;
        }

        @Override
        protected OutputStream getOut(String recordingFilename) {
            this.wavHeader.setLength(Integer.MAX_VALUE);
            this.wavHeader.setDataChunkLen(Integer.MAX_VALUE);
            return this.out;
        }
    }

    public static class JWAVFileDriver
    extends JWAVDriver {
        private RandomAccessFile file;

        @Override
        protected OutputStream getOut(String recordingFilename) throws IOException {
            System.out.println("Recording, file=" + recordingFilename);
            this.file = new RandomAccessFile(recordingFilename, "rw");
            return new FileOutputStream(this.file.getFD());
        }

        @Override
        public void close() {
            super.close();
            if (this.out != null && this.file != null) {
                try {
                    this.file.seek(0L);
                    this.out.write(this.wavHeader.getBytes());
                    this.out.close();
                    this.file.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing WAV audio stream", e);
                }
                finally {
                    this.out = null;
                    this.file = null;
                }
            }
        }
    }
}

