/*
 * Decompiled with CFR 0.152.
 */
package javax.usb;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.usb.UsbException;
import javax.usb.UsbServices;

public final class UsbHostManager {
    public static final String JAVAX_USB_PROPERTIES_FILE = "javax.usb.properties";
    public static final String JAVAX_USB_USBSERVICES_PROPERTY = "javax.usb.services";
    private static final String PROPERTIES_FILE_NOT_FOUND = "Properties file javax.usb.properties not found.";
    private static final String PROPERTIES_FILE_IOEXCEPTION_READING = "IOException while reading properties file javax.usb.properties";
    private static final String PROPERTIES_FILE_IOEXCEPTION_CLOSING = "IOException while closing properties file javax.usb.properties";
    private static boolean propertiesLoaded = false;
    private static Properties properties = new Properties();
    private static Object propertiesLock = new Object();
    private static UsbServices usbServices = null;
    private static Object servicesLock = new Object();

    private UsbHostManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsbServices getUsbServices() throws UsbException, SecurityException {
        Object object = servicesLock;
        synchronized (object) {
            if (null == usbServices) {
                usbServices = UsbHostManager.createUsbServices();
            }
        }
        return usbServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties() throws UsbException, SecurityException {
        Object object = propertiesLock;
        synchronized (object) {
            if (!propertiesLoaded) {
                UsbHostManager.setupProperties();
            }
        }
        return (Properties)properties.clone();
    }

    private static UsbServices createUsbServices() throws UsbException, SecurityException {
        String string = UsbHostManager.getProperties().getProperty(JAVAX_USB_USBSERVICES_PROPERTY);
        if (null == string) {
            throw new UsbException(UsbHostManager.USBSERVICES_PROPERTY_NOT_DEFINED());
        }
        try {
            return (UsbServices)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UsbException(UsbHostManager.USBSERVICES_CLASSNOTFOUNDEXCEPTION(string) + " : " + classNotFoundException.getMessage());
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new UsbException(UsbHostManager.USBSERVICES_EXCEPTIONININITIALIZERERROR(string) + " : " + exceptionInInitializerError.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new UsbException(UsbHostManager.USBSERVICES_INSTANTIATIONEXCEPTION(string) + " : " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UsbException(UsbHostManager.USBSERVICES_ILLEGALACCESSEXCEPTION(string) + " : " + illegalAccessException.getMessage());
        }
        catch (ClassCastException classCastException) {
            throw new UsbException(UsbHostManager.USBSERVICES_CLASSCASTEXCEPTION(string) + " : " + classCastException.getMessage());
        }
    }

    private static void setupProperties() throws UsbException, SecurityException {
        InputStream inputStream = null;
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("file.separator");
        if (null != string && null != string2) {
            try {
                inputStream = new FileInputStream(string + string2 + "lib" + string2 + JAVAX_USB_PROPERTIES_FILE);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (null == inputStream) {
            inputStream = UsbHostManager.class.getClassLoader().getResourceAsStream(JAVAX_USB_PROPERTIES_FILE);
        }
        if (null == inputStream) {
            throw new UsbException(PROPERTIES_FILE_NOT_FOUND);
        }
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new UsbException("IOException while reading properties file javax.usb.properties : " + iOException.getMessage());
        }
        propertiesLoaded = true;
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException while closing properties file javax.usb.properties : " + iOException.getMessage());
        }
    }

    private static final String USBSERVICES_PROPERTY_NOT_DEFINED() {
        return "The property javax.usb.services is not defined as the implementation class of UsbServices";
    }

    private static final String USBSERVICES_CLASSNOTFOUNDEXCEPTION(String string) {
        return "The UsbServices implementation class " + string + " was not found";
    }

    private static final String USBSERVICES_EXCEPTIONININITIALIZERERROR(String string) {
        return "an Exception occurred during initialization of the UsbServices Class " + string;
    }

    private static final String USBSERVICES_INSTANTIATIONEXCEPTION(String string) {
        return "An Exception occurred during instantiation of the UsbServices implementation " + string;
    }

    private static final String USBSERVICES_ILLEGALACCESSEXCEPTION(String string) {
        return "An IllegalAccessException occurred while creating the UsbServices implementation " + string;
    }

    private static final String USBSERVICES_CLASSCASTEXCEPTION(String string) {
        return "The class " + string + " does not implement UsbServices";
    }
}

