/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.oscilloscope;

import client.teavm.common.oscilloscope.Gauge;
import java.nio.ByteBuffer;
import java.util.function.Function;
import java.util.function.Supplier;
import libsidplay.common.SIDEmu;

public class FilterGauge
extends Gauge {
    private Function<String, String> localizer;

    public FilterGauge(int width, int height, Function<String, String> localizer, Supplier<ByteBuffer> initGaugeBuffer) {
        super(width, height, initGaugeBuffer);
        this.localizer = localizer;
    }

    public Gauge sample(SIDEmu sidemu) {
        int fc = sidemu.readInternalRegister(21) & 7;
        this.accumulate((float)(fc |= (sidemu.readInternalRegister(22) & 0xFF) << 3) / 2047.0f);
        return this;
    }

    @Override
    public void draw(SIDEmu sidemu) {
        if (sidemu != null) {
            byte vol = sidemu.readInternalRegister(24);
            this.text = this.createText(vol);
        }
        super.draw(sidemu);
    }

    private String createText(byte vol) {
        StringBuilder result = new StringBuilder();
        result.append(this.localizer.apply("FILTER"));
        result.append(" ");
        if ((vol & 0x10) != 0) {
            result.append("L");
        } else {
            result.append(" ");
        }
        if ((vol & 0x20) != 0) {
            result.append("B");
        } else {
            result.append(" ");
        }
        if ((vol & 0x40) != 0) {
            result.append("H");
        } else {
            result.append(" ");
        }
        return result.toString();
    }
}

