/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.nonasm.util.functions.Func2;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;

public class ParameterMapTailParser<NODE>
implements ITailParser<NODE> {
    private Func2<ParameterMap, SourceRange, NODE> nodeCreator;

    public ParameterMapTailParser(Func2<ParameterMap, SourceRange, NODE> func2) {
        this.nodeCreator = func2;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        tokenStreamList.skipWsAndNl();
        IToken iToken2 = tokenStreamList.expectType(TokenType.SquareBracketRange, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        ParameterMap parameterMap = ExprParser.parseParametersMap(iToken2.getChildStream(), evaluationState, iToken2.getSourceRange());
        if (parameterMap == null) {
            return null;
        }
        tokenStreamList.skipWsAndNl();
        tokenStreamList.next().expectEos(evaluationState);
        return this.nodeCreator.apply(parameterMap, sourceRange);
    }
}

