/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common;

import builder.jexsid.JExSIDMapping;
import builder.jhardsid.JHardSIDMapping;
import builder.jsidblaster.JSIDBlasterMapping;
import builder.jusbsid.JUSBSIDMapping;
import builder.resid.ReSIDBuilder;
import client.teavm.common.IExportedApi;
import client.teavm.common.IImportedApi;
import client.teavm.common.ILogger;
import client.teavm.common.MainArgs;
import client.teavm.common.audio.AudioDriverTeaVM;
import client.teavm.common.config.ConfigurationTeaVM;
import client.teavm.common.oscilloscope.Oscilloscope;
import client.teavm.common.video.PALEmulationTeaVM;
import com.fasterxml.jackson.databind.EnumNamingStrategies;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import libsidplay.C64;
import libsidplay.HardwareEnsemble;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.Mixer;
import libsidplay.common.SIDEmu;
import libsidplay.common.SamplingMethod;
import libsidplay.common.SamplingRate;
import libsidplay.common.SidReads;
import libsidplay.common.StereoMode;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.c1541.DiskImage;
import libsidplay.components.c1541.FloppyType;
import libsidplay.components.cart.CartridgeType;
import libsidplay.components.keyboard.KeyTableEntry;
import libsidplay.components.mos6510.MOS6510;
import libsidplay.config.IAudioSection;
import libsidplay.config.IC1541Section;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;
import libsidplay.config.IPrinterSection;
import libsidplay.config.ISidPlay2Section;
import libsidplay.config.ISidPlay2SystemProperties;
import libsidplay.config.IWhatsSidSection;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.CBMCodeUtils;
import libsidutils.IOUtils;
import libsidutils.prg2tap.PRG2TAP;
import libsidutils.prg2tap.PRG2TAPProgram;
import libsidutils.siddatabase.TimeConverter;
import libsidutils.sidid.SidIdInfo;
import libsidutils.status.Status;
import sidplay.consoleplayer.ConsoleIO;
import sidplay.player.PSid64DetectedTuneInfo;
import sidplay.player.PSid64Detection;
import sidplay.player.PlayList;
import sidplay.player.Timer;
import ui.entities.collection.HVSCEntry;

public final class ExportedApi
implements IExportedApi,
ILogger {
    private static final Logger LOG_IMPL = Logger.getLogger(ExportedApi.class.getName());
    private static final int RAM_COMMAND = 631;
    private static final int RAM_COMMAND_LEN = 198;
    private static final int MAX_COMMAND_LEN = 16;
    private static final int RAM_COMMAND_SCREEN_ADDRESS = 1264;
    private static final String RUN = "RUN\r";
    private static final String SYS = "SYS%d\r";
    private static final String LOAD = "LOAD\r";
    private static final String HEADING = "Java SIDPlay2 - Music Player & C64 SID Chip Emulator";
    private static final String HVSC_ENTRY = "HVSCEntry";
    private static final Function<String, String> RESOURCE_BUNDLE = key -> EnumNamingStrategies.CamelCaseStrategy.INSTANCE.convertEnumToExternalName(key);
    private final IImportedApi importedApi;
    private final ILogger LOG;
    private final MainArgs mainArgs;
    private final IConfig config;
    private final ISidPlay2Section sidplay2Section;
    private final IAudioSection audioSection;
    private final IEmulationSection emulationSection;
    private final IC1541Section c1541Section;
    private final IPrinterSection printerSection;
    private final IWhatsSidSection whatsSidSection;
    private EventScheduler context;
    private SidTune tune;
    private HVSCEntry hvscEntry;
    private PlayList playList;
    private HardwareEnsemble hardwareEnsemble;
    private C64 c64;
    private ReSIDBuilder sidBuilder;
    private AudioDriverTeaVM audioDriver;
    private Timer timer;
    private Status status;
    private String command;
    private Collection<String> playerIds;
    private String playerId;
    private Engine[] engines = new Engine[ISidPlay2SystemProperties.MAX_SIDS];
    private Emulation[] emulations = new Emulation[ISidPlay2SystemProperties.MAX_SIDS];
    private ChipModel[] chipModels = new ChipModel[ISidPlay2SystemProperties.MAX_SIDS];
    private String[] filterNames = new String[ISidPlay2SystemProperties.MAX_SIDS];
    private int autodetectPSID64Counter;
    private boolean psid64Detected;
    private Oscilloscope oscilloscope;
    private int bufferSize;

    public ExportedApi(IImportedApi importedApi, String[] args) {
        this.importedApi = importedApi;
        this.LOG = this;
        this.mainArgs = new MainArgs(this.LOG, args);
        this.config = new ConfigurationTeaVM();
        this.sidplay2Section = this.config.getSidplay2Section();
        this.audioSection = this.config.getAudioSection();
        this.emulationSection = this.config.getEmulationSection();
        this.c1541Section = this.config.getC1541Section();
        this.printerSection = this.config.getPrinterSection();
        this.whatsSidSection = this.config.getWhatsSidSection();
    }

    @Override
    public void open(byte[] sidContents, String sidContentsName, int song, int nthFrame, boolean addSidListener, byte[] cartContents, String cartContentsName, String command, double songLength, boolean sfxSoundExpander, int sfxSoundExpanderType) {
        try {
            this.command = command;
            this.doLog(this.sidplay2Section, this.audioSection, this.emulationSection, this.c1541Section);
            if (sidContents != null || sidContentsName != null && this.getBuiltIn(sidContentsName) != null) {
                if (sidContents == null) {
                    sidContents = this.getBuiltIn(sidContentsName);
                    sidContentsName = sidContentsName + ".prg";
                }
                this.LOG.fine("Load Tune, length=" + sidContents.length);
                this.LOG.fine("Tune name: " + sidContentsName);
                this.tune = SidTune.load(sidContentsName, new ByteArrayInputStream(sidContents));
                this.tune.getInfo().setSelectedSong(song == 0 ? null : Integer.valueOf(song));
                this.LOG.fine("Song: " + this.tune.getInfo().getSelectedSong());
                this.LOG.fine("SongLength: " + songLength);
                this.playerIds = this.tune.identify(SID_ID_CFG_BIN);
                this.playerId = this.playerIds.stream().collect(Collectors.joining(","));
                this.hvscEntry = new HVSCEntry(() -> songLength, sidContentsName, "", sidContents.length, 0L, this.tune, this.playerId);
            } else {
                this.LOG.fine("RESET");
                this.tune = SidTune.RESET;
            }
            this.LOG.fine("nthFrame: " + nthFrame);
            this.LOG.fine("addSidListener: " + addSidListener);
            this.LOG.fine("sfxSoundExpander: " + sfxSoundExpander);
            this.LOG.fine("sfxSoundExpanderType: " + sfxSoundExpanderType);
            if (cartContentsName != null) {
                this.LOG.fine("Cart, length=: " + cartContents.length);
                this.LOG.fine("Cart name: : " + cartContentsName);
            }
            this.doLog(this.emulationSection, this.tune);
            this.importedApi.initControlBuffer();
            this.hardwareEnsemble = new HardwareEnsemble(this.config, MOS6510::new, CHAR_ROM, BASIC_ROM, KERNAL_ROM, JIFFY_DOS_C64_ROM, JIFFY_DOS_C1541_ROM, C1541_ROM, C1541_II_ROM, MPS803_ROM);
            CPUClock cpuClock = CPUClock.getCPUClock(this.emulationSection, this.tune);
            this.hardwareEnsemble.setClock(cpuClock);
            this.hardwareEnsemble.getPrinter().setPaper(this.importedApi::processPrinter);
            this.c64 = this.hardwareEnsemble.getC64();
            this.c64.getVIC().setPalEmulation(nthFrame > 0 ? new PALEmulationTeaVM(this.importedApi, nthFrame, cpuClock, COMBINED_LINES_EVEN, COMBINED_LINES_ODD, LINE_PALETTE_EVEN, LINE_PALETTE_ODD) : null);
            this.context = this.c64.getEventScheduler();
            if (sfxSoundExpander) {
                this.insertCart(CartridgeType.SOUNDEXPANDER, sfxSoundExpanderType);
            } else if (cartContents != null) {
                this.insertCart(cartContents, cartContentsName);
            }
            this.hardwareEnsemble.reset();
            this.sidBuilder = new ReSIDBuilder(this.context, this.config, cpuClock, this.c64.getCartridge());
            this.context.schedule(Event.of("Auto-start", event -> {
                if (this.tune != SidTune.RESET) {
                    Integer driverAddress = this.tune.placeProgramInMemory(this.c64.getRAM(), PSID_DRIVER_BIN);
                    if (driverAddress != null) {
                        this.c64.setPlayAddr(this.tune.getInfo().getPlayAddr());
                        this.c64.getCPU().forcedJump(driverAddress);
                    } else {
                        int loadAddr = this.tune.getInfo().getLoadAddr();
                        String string = loadAddr == 2049 ? RUN : (this.command = loadAddr >= 2049 ? String.format(SYS, loadAddr) : null);
                    }
                }
                if (this.command != null) {
                    if (this.command.startsWith(LOAD)) {
                        this.hardwareEnsemble.getDatasette().control(Datasette.Control.START);
                    }
                    this.typeInCommand(this.command);
                }
                this.context.schedule(Event.of("PSID64 Detection", event2 -> this.autodetectPSID64()), (long)cpuClock.getCpuFrequency());
            }), SidTune.getInitDelay(this.tune));
            boolean usb = Stream.of(Engine.EMULATION, Engine.NETSID).noneMatch(this.emulationSection.getEngine()::equals);
            this.audioDriver = new AudioDriverTeaVM(this.importedApi, AUD_LOOKUP_TABLE, this.sidBuilder, usb, nthFrame);
            this.audioDriver.open(this.audioSection, null, cpuClock, this.context);
            this.sidBuilder.setAudioDriver(this.audioDriver);
            this.updateSids(this.emulationSection);
            if (nthFrame > 0) {
                this.c64.configureVICs(vic -> vic.setVideoDriver(this.audioDriver));
            }
            if (this.emulationSection.getEngine() != Engine.EMULATION || addSidListener) {
                this.c64.setSIDListener(this.audioDriver);
            }
            this.timer = new Timer(this.sidplay2Section, this.context, () -> songLength){

                @Override
                public void start() {
                }

                @Override
                public void end() {
                    if (ExportedApi.this.tune != SidTune.RESET) {
                        ExportedApi.this.bufferSize = 0;
                        try {
                            ExportedApi.this.audioDriver.write();
                        }
                        catch (InterruptedException e) {
                            ExportedApi.this.LOG.severe(String.format("Error during writeRemaining: %s!", e.getMessage()));
                        }
                        finally {
                            ExportedApi.this.importedApi.processTimerEnd(ExportedApi.this.timer.getEnd());
                        }
                    }
                }

                @Override
                public void fadeInStart(double fadeIn) {
                    if (ExportedApi.this.tune != SidTune.RESET) {
                        ExportedApi.this.sidBuilder.fadeIn(fadeIn);
                    }
                }

                @Override
                public void fadeOutStart(double fadeOut) {
                    if (ExportedApi.this.tune != SidTune.RESET) {
                        ExportedApi.this.sidBuilder.fadeOut(fadeOut);
                    }
                }
            };
            this.timer.setStart(0.0);
            this.timer.setDefaultLength(this.sidplay2Section.getDefaultPlayLength());
            this.timer.reset(this.tune);
            this.playList = new PlayList(this.sidplay2Section, this.tune, true);
            this.status = new Status(this.hardwareEnsemble, this.tune, this.sidBuilder, this.audioDriver, tune -> null, () -> songLength, () -> this.psid64Detected, RESOURCE_BUNDLE);
            if (this.whatsSidSection.isEnable()) {
                int matchStartTimeInSeconds = this.whatsSidSection.getMatchStartTime();
                if (songLength > 0.0 && songLength < (double)matchStartTimeInSeconds) {
                    matchStartTimeInSeconds = Math.min((int)(songLength * 0.9), matchStartTimeInSeconds);
                }
                this.context.schedule(Event.of("WhatsSID?", event -> {
                    this.importedApi.whatsSid(this.sidBuilder.getWhatsSidSupport().createWAV());
                    int matchRetryTimeInSeconds = this.whatsSidSection.getMatchRetryTime();
                    this.context.schedule((Event)event, (long)((double)matchRetryTimeInSeconds * this.context.getCyclesPerSecond()));
                }), (long)((double)matchStartTimeInSeconds * this.context.getCyclesPerSecond()));
                this.sidBuilder.getWhatsSidSupport().reset();
            }
            this.sidBuilder.start();
            this.bufferSize = this.audioSection.getBufferSize();
            if (this.tune != SidTune.RESET) {
                ConsoleIO consoleIO = new ConsoleIO(this.config, sidContentsName, key -> key.equals("HEADING") ? HEADING : EnumNamingStrategies.CamelCaseStrategy.INSTANCE.convertEnumToExternalName(key));
                consoleIO.menu(this.tune, this.playList, this.timer, this.mainArgs.getVerbose(), this.mainArgs.isQuiet(), false, System.out);
            }
        }
        catch (Exception e) {
            this.LOG.severe(e.getMessage());
            this.LOG.severe(String.format("Cannot open tune '%s'.", sidContentsName != null ? sidContentsName : "RESET"));
        }
    }

    @Override
    public void clock() {
        try {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.context.clock();
            }
        }
        catch (Exception e) {
            this.LOG.severe(e.getMessage());
            this.LOG.severe(String.format("Cannot clock.", new Object[0]));
        }
    }

    @Override
    public void defaultPlayLength(double defaultPlayLength) {
        this.LOG.fine(String.format("defaultPlayLength: %f", defaultPlayLength));
        this.sidplay2Section.setDefaultPlayLength(defaultPlayLength);
        if (this.isOpen()) {
            this.timer.setDefaultLength(defaultPlayLength);
            this.timer.updateEnd(this.tune);
        }
    }

    @Override
    public void loop(boolean loop) {
        this.LOG.fine(String.format("loop: %b", loop));
        this.sidplay2Section.setLoop(loop);
    }

    @Override
    public void single(boolean single) {
        this.LOG.fine(String.format("single: %b", single));
        this.sidplay2Section.setSingle(single);
    }

    @Override
    public void palEmulationEnable(boolean palEmulationEnable) {
        this.LOG.fine(String.format("palEmulationEnable: %b", palEmulationEnable));
        this.sidplay2Section.setPalEmulation(palEmulationEnable);
        if (this.isOpen()) {
            Optional.ofNullable(this.c64.getVIC().getPalEmulation()).ifPresent(palEmu -> palEmu.setPalEmulationEnable(palEmulationEnable));
        }
    }

    @Override
    public void turboTape(boolean turboTape) {
        this.LOG.fine(String.format("turboTape: %b", turboTape));
        this.sidplay2Section.setTurboTape(turboTape);
    }

    @Override
    public void fade(double fadeInTime, double fadeOutTime) {
        this.LOG.fine(String.format("fadeInTime: %f, fadeOutTime: %f", fadeInTime, fadeOutTime));
        this.sidplay2Section.setFadeInTime(fadeInTime);
        this.sidplay2Section.setFadeOutTime(fadeOutTime);
    }

    @Override
    public void samplingRate(SamplingRate samplingRate) {
        this.LOG.fine(String.format("samplingRate: %s", new Object[]{samplingRate}));
        this.audioSection.setSamplingRate(samplingRate);
    }

    @Override
    public void sampling(SamplingMethod sampling) {
        this.LOG.fine(String.format("samplingMethod: %s", new Object[]{sampling}));
        this.audioSection.setSampling(sampling);
    }

    @Override
    public void volumeLevels(float mainVolume, float secondVolume, float thirdVolume, float mainBalance, float secondBalance, float thirdBalance, int mainDelay, int secondDelay, int thirdDelay) {
        this.LOG.fine(String.format("mainVolume: %f, secondVolume: %f, thirdVolume: %f", Float.valueOf(mainVolume), Float.valueOf(secondVolume), Float.valueOf(thirdVolume)));
        this.LOG.fine(String.format("mainBalance: %f, secondBalance: %f, thirdBalance: %f", Float.valueOf(mainBalance), Float.valueOf(secondBalance), Float.valueOf(thirdBalance)));
        this.LOG.fine(String.format("mainDelay: %d, secondDelay: %d, thirdDelay: %d", mainDelay, secondDelay, thirdDelay));
        this.audioSection.setVolume(0, mainVolume);
        this.audioSection.setVolume(1, secondVolume);
        this.audioSection.setVolume(2, thirdVolume);
        this.audioSection.setBalance(0, mainBalance);
        this.audioSection.setBalance(1, secondBalance);
        this.audioSection.setBalance(2, thirdBalance);
        this.audioSection.setDelay(0, mainDelay);
        this.audioSection.setDelay(1, secondDelay);
        this.audioSection.setDelay(2, thirdDelay);
        if (this.isOpen()) {
            this.sidBuilder.setVolume(0, mainVolume);
            this.sidBuilder.setVolume(1, secondVolume);
            this.sidBuilder.setVolume(2, thirdVolume);
            this.sidBuilder.setBalance(0, mainBalance);
            this.sidBuilder.setBalance(1, secondBalance);
            this.sidBuilder.setBalance(2, thirdBalance);
            this.sidBuilder.setDelay(0, mainDelay);
            this.sidBuilder.setDelay(1, secondDelay);
            this.sidBuilder.setDelay(2, thirdDelay);
        }
    }

    @Override
    public void bufferSize(int bufferSize) {
        this.LOG.fine(String.format("bufferSize: %s", bufferSize));
        this.audioSection.setBufferSize(bufferSize);
    }

    @Override
    public void audioBufferSize(int audioBufferSize) {
        this.LOG.fine(String.format("audioBufferSize: %s", audioBufferSize));
        this.audioSection.setAudioBufferSize(audioBufferSize);
    }

    @Override
    public void delay(boolean delayBypass, int delay, int delayWetLevel, int delayDryLevel, int delayFeedbackLevel) {
        this.LOG.fine(String.format("delayBypass: %b, delay: %d, delayWetLevel: %d, delayDryLevel: %d, delayFeedbackLevel: %d", delayBypass, delay, delayWetLevel, delayDryLevel, delayFeedbackLevel));
        this.audioSection.setDelayBypass(delayBypass);
        this.audioSection.setDelay(delay);
        this.audioSection.setDelayWetLevel(delayWetLevel);
        this.audioSection.setDelayDryLevel(delayDryLevel);
        this.audioSection.setDelayFeedbackLevel(delayFeedbackLevel);
    }

    @Override
    public void reverb(boolean reverbBypass, float reverbComb1Delay, float reverbComb2Delay, float reverbComb3Delay, float reverbComb4Delay, float reverbAllPass1Delay, float reverbAllPass2Delay, float reverbSustainDelay, float reverbDryWetMix) {
        this.LOG.fine(String.format("reverbBypass: %b, reverbComb1Delay: %f, reverbComb2Delay: %f, reverbComb3Delay: %f, reverbComb4Delay: %f", reverbBypass, Float.valueOf(reverbComb1Delay), Float.valueOf(reverbComb2Delay), Float.valueOf(reverbComb3Delay), Float.valueOf(reverbComb4Delay)));
        this.LOG.fine(String.format("reverbAllPass1Delay: %f, reverbAllPass2Delay: %f, reverbSustainDelay: %f, reverbDryWetMix: %f", Float.valueOf(reverbAllPass1Delay), Float.valueOf(reverbAllPass2Delay), Float.valueOf(reverbSustainDelay), Float.valueOf(reverbDryWetMix)));
        this.audioSection.setReverbBypass(reverbBypass);
        this.audioSection.setReverbComb1Delay(reverbComb1Delay);
        this.audioSection.setReverbComb2Delay(reverbComb2Delay);
        this.audioSection.setReverbComb3Delay(reverbComb3Delay);
        this.audioSection.setReverbComb4Delay(reverbComb4Delay);
        this.audioSection.setReverbAllPass1Delay(reverbAllPass1Delay);
        this.audioSection.setReverbAllPass2Delay(reverbAllPass2Delay);
        this.audioSection.setReverbSustainDelay(reverbSustainDelay);
        this.audioSection.setReverbDryWetMix(reverbDryWetMix);
    }

    @Override
    public void engine(Engine engine) {
        this.LOG.fine(String.format("engine: %s", new Object[]{engine}));
        this.emulationSection.setEngine(engine);
    }

    @Override
    public void defaultEmulation(Emulation emulation) {
        this.LOG.fine(String.format("defaultEmulation: %s", new Object[]{emulation}));
        this.emulationSection.setDefaultEmulation(emulation);
        if (this.isOpen()) {
            this.updateSids(this.emulationSection);
        }
    }

    @Override
    public void userEmulation(Emulation userEmulation, Emulation stereoEmulation, Emulation thirdEmulation) {
        this.LOG.fine(String.format("userEmulation: %s, stereoEmulation: %s, thirdEmulation: %s", new Object[]{userEmulation, stereoEmulation, thirdEmulation}));
        this.emulationSection.setForcedEmulation(0, userEmulation);
        this.emulationSection.setForcedEmulation(1, stereoEmulation);
        this.emulationSection.setForcedEmulation(2, thirdEmulation);
        if (this.isOpen()) {
            this.updateSids(this.emulationSection);
        }
    }

    @Override
    public void defaultClockSpeed(CPUClock defaultClockSpeed) {
        this.LOG.fine(String.format("defaultClockSpeed: %s", new Object[]{defaultClockSpeed}));
        this.emulationSection.setDefaultClockSpeed(defaultClockSpeed);
    }

    @Override
    public void userClockSpeed(CPUClock userClockSpeed) {
        this.LOG.fine(String.format("userClockSpeed: %s", new Object[]{userClockSpeed}));
        this.emulationSection.setUserClockSpeed(userClockSpeed);
    }

    @Override
    public void defaultChipModel(ChipModel chipModel) {
        this.LOG.fine(String.format("defaultChipModel: %s", new Object[]{chipModel}));
        this.emulationSection.setDefaultSidModel(chipModel);
        if (this.isOpen()) {
            this.updateSids(this.emulationSection);
        }
    }

    @Override
    public void userChipModel(ChipModel userSidModel, ChipModel stereoSidModel, ChipModel thirdSIDModel) {
        this.LOG.fine(String.format("userSidModel: %s, stereoSidModel: %s, thirdSIDModel: %s", new Object[]{userSidModel, stereoSidModel, thirdSIDModel}));
        this.emulationSection.setForcedSidModel(0, userSidModel);
        this.emulationSection.setForcedSidModel(1, stereoSidModel);
        this.emulationSection.setForcedSidModel(2, thirdSIDModel);
        if (this.isOpen()) {
            this.updateSids(this.emulationSection);
        }
    }

    @Override
    public String hardSidMapping(int chipCount, int hardsid6581, int hardsid8580) {
        this.LOG.fine(String.format("hardSidMapping, chipCount: %d, hardsid6581: %d, hardsid8580: %d", chipCount, hardsid6581 + 1, hardsid8580 + 1));
        this.emulationSection.setHardsid6581(hardsid6581);
        this.emulationSection.setHardsid8580(hardsid8580);
        if (this.isOpen()) {
            return this.mapToString(JHardSIDMapping.mapping(this.emulationSection, this.tune, chipCount));
        }
        return null;
    }

    @Override
    public String exSidMapping() {
        this.LOG.fine("exSidMapping");
        if (this.isOpen()) {
            return this.mapToString(JExSIDMapping.mapping(this.emulationSection, this.tune));
        }
        return null;
    }

    @Override
    public String sidBlasterMapping() {
        this.LOG.fine("sidBlasterMapping");
        if (this.isOpen()) {
            return this.mapToString(JSIDBlasterMapping.mapping(this.emulationSection, this.tune));
        }
        return null;
    }

    @Override
    public String usbSidMapping() {
        this.LOG.fine("usbSidMapping");
        if (this.isOpen()) {
            return this.mapToString(JUSBSIDMapping.mapping(this.emulationSection, this.tune));
        }
        return null;
    }

    @Override
    public void filterEnable(int sidNum, boolean filterEnable) {
        this.LOG.fine(String.format("filterEnable %d, %b", sidNum, filterEnable));
        this.emulationSection.setFilterEnable(sidNum, filterEnable);
        if (this.isOpen()) {
            this.updateSids(this.emulationSection);
        }
    }

    @Override
    public void filterName(Emulation emulation, ChipModel chipModel, int sidNum, String filterName) {
        this.LOG.fine(String.format("filterName %s, %s, %s", new Object[]{emulation, chipModel, this.getFilterName(sidNum, filterName)}));
        this.emulationSection.setFilterName(sidNum, Engine.EMULATION, emulation, chipModel, filterName);
        if (this.isOpen()) {
            this.updateSids(this.emulationSection);
        }
    }

    @Override
    public void digiBoosted8580(boolean boost) {
        this.LOG.fine(String.format("digiBoosted8580: %b", boost));
        this.emulationSection.setDigiBoosted8580(boost);
        if (this.isOpen()) {
            this.c64.configureSIDs((num, sid) -> sid.setDigiBoost(boost));
        }
    }

    @Override
    public void stereo(StereoMode stereoMode, int dualSidBase, int thirdSIDBase, boolean fakeStereo, SidReads sidToRead) {
        this.LOG.fine(String.format("stereoMode: %s, dualSidBase: %d, thirdSIDBase: %d", new Object[]{stereoMode, dualSidBase, thirdSIDBase}));
        this.LOG.fine(String.format("fakeStereo: %b, sidToRead: %s", new Object[]{fakeStereo, sidToRead}));
        this.emulationSection.setStereoMode(stereoMode);
        this.emulationSection.setDualSidBase(dualSidBase);
        this.emulationSection.setThirdSIDBase(thirdSIDBase);
        this.emulationSection.setFakeStereo(fakeStereo);
        this.emulationSection.setSidToRead(sidToRead);
        if (this.isOpen()) {
            this.updateSids(this.emulationSection);
        }
    }

    @Override
    public void mute(int sidNum, int voice, boolean value) {
        this.LOG.fine(String.format("mute SID%d, voice%d: %b", sidNum, voice, value));
        this.emulationSection.setMuteVoice(sidNum, voice, value);
        if (this.isOpen()) {
            this.c64.configureSID(sidNum, sid -> sid.setVoiceMute(voice, value));
        }
    }

    @Override
    public void detectPSID64ChipModel(boolean detectPSID64ChipModel) {
        this.LOG.fine("detectPSID64ChipModel: " + detectPSID64ChipModel);
        this.emulationSection.setDetectPSID64ChipModel(detectPSID64ChipModel);
    }

    @Override
    public void turnDriveOn(boolean driveOn) {
        this.LOG.fine(String.format("turnDriveOn: %b", driveOn));
        this.c1541Section.setDriveOn(driveOn);
        if (this.isOpen()) {
            this.hardwareEnsemble.enableFloppyDiskDrives(driveOn);
        }
    }

    @Override
    public void parallelCable(boolean parallelCable) {
        this.LOG.fine(String.format("parallelCable: %b", parallelCable));
        this.c1541Section.setParallelCable(parallelCable);
    }

    @Override
    public void jiffyDosInstalled(boolean jiffyDosInstalled) {
        this.LOG.fine(String.format("jiffyDosInstalled: %b", jiffyDosInstalled));
        this.c1541Section.setJiffyDosInstalled(jiffyDosInstalled);
    }

    @Override
    public void ramExpansion(boolean ramExpansion0, boolean ramExpansion1, boolean ramExpansion2, boolean ramExpansion3, boolean ramExpansion4) {
        this.LOG.fine(String.format("ramExpansion, ramExpansion0X2000: %b, ramExpansion0X4000: %b, ramExpansion0X6000: %b, ramExpansion0X8000: %b, ramExpansion0XA000: %b", ramExpansion0, ramExpansion1, ramExpansion2, ramExpansion3, ramExpansion4));
        this.c1541Section.setRamExpansionEnabled0(ramExpansion0);
        this.c1541Section.setRamExpansionEnabled1(ramExpansion1);
        this.c1541Section.setRamExpansionEnabled2(ramExpansion2);
        this.c1541Section.setRamExpansionEnabled3(ramExpansion3);
        this.c1541Section.setRamExpansionEnabled4(ramExpansion4);
    }

    @Override
    public void floppyType(FloppyType floppyType) {
        this.LOG.fine(String.format("floppyType: %s", new Object[]{floppyType}));
        this.c1541Section.setFloppyType(floppyType);
    }

    @Override
    public void printerOn(boolean printerOn) {
        this.LOG.fine(String.format("printerOn: %b", printerOn));
        this.printerSection.setPrinterOn(printerOn);
    }

    @Override
    public void whatsSID(boolean enable, int captureTime, int matchStartTime, int matchRetryTime, float minimumRelativeConfidence) {
        this.LOG.fine(String.format("whatsSID enable: %b, captureTime: %d, matchStartTime: %d, matchRetryTime: %d, minimumRelativeConfidence: %f", enable, captureTime, matchStartTime, matchRetryTime, Float.valueOf(minimumRelativeConfidence)));
        this.whatsSidSection.setEnable(enable);
        this.whatsSidSection.setCaptureTime(captureTime);
        this.whatsSidSection.setMatchStartTime(matchStartTime);
        this.whatsSidSection.setMatchRetryTime(matchRetryTime);
        this.whatsSidSection.setMinimumRelativeConfidence(minimumRelativeConfidence);
    }

    @Override
    public void typeInCommand(String multiLineCommand) {
        this.LOG.fine(String.format("typeInCommand: %s", multiLineCommand));
        if (this.isOpen()) {
            String command;
            if (multiLineCommand.length() > 16) {
                int indexOf;
                int n = 0;
                String[] lines = multiLineCommand.split("\r");
                String[] stringArray = lines;
                int n2 = stringArray.length;
                if (n < n2) {
                    String line = stringArray[n];
                    byte[] screenRam = CBMCodeUtils.petsciiToScreenRam(line);
                    System.arraycopy(screenRam, 0, this.c64.getRAM(), 1264, screenRam.length);
                }
                command = (indexOf = multiLineCommand.indexOf(13)) != -1 ? multiLineCommand.substring(indexOf) : "\r";
            } else {
                command = multiLineCommand;
            }
            int length = Math.min(command.length(), 16);
            System.arraycopy(command.getBytes(StandardCharsets.US_ASCII), 0, this.c64.getRAM(), 631, length);
            this.c64.getRAM()[198] = (byte)length;
        }
    }

    @Override
    public void typeKey(KeyTableEntry key) {
        this.LOG.fine(String.format("typeKey: %s", new Object[]{key}));
        if (this.isOpen()) {
            if (key == KeyTableEntry.RESTORE) {
                this.c64.getKeyboard().restore();
            } else {
                this.c64.getKeyboard().keyPressed(key);
                this.context.schedule(Event.of("Wait Until Virtual Keyboard Released", event2 -> this.context.scheduleThreadSafeKeyEvent(Event.of("Virtual Keyboard Released", event3 -> this.c64.getKeyboard().keyReleased(key)))), this.c64.getClock().getCyclesPerFrame() << 2);
            }
        }
    }

    @Override
    public void pressKey(KeyTableEntry key) {
        this.LOG.fine(String.format("pressKey: %s", new Object[]{key}));
        if (this.isOpen()) {
            this.context.scheduleThreadSafeKeyEvent(Event.of("Wait Until Virtual Keyboard Pressed", event2 -> {
                if (key == KeyTableEntry.RESTORE) {
                    this.c64.getKeyboard().restore();
                } else {
                    this.c64.getKeyboard().keyPressed(key);
                }
            }));
        }
    }

    @Override
    public void releaseKey(KeyTableEntry key) {
        this.LOG.fine(String.format("releaseKey: %s", new Object[]{key}));
        if (this.isOpen()) {
            this.context.scheduleThreadSafeKeyEvent(Event.of("Wait Until Virtual Keyboard Released", event2 -> this.c64.getKeyboard().keyReleased(key)));
        }
    }

    @Override
    public void joystick(int number, int value) {
        this.LOG.fine(String.format("joystick P%d: %d", number + 1, value));
        if (this.isOpen()) {
            this.c64.setJoystick(number, () -> (byte)(0xFF ^ value));
            this.context.schedule(Event.of("Wait Until Virtual Joystick Released", event -> this.context.scheduleThreadSafeKeyEvent(Event.of("Virtual Joystick Released", event2 -> this.c64.setJoystick(number, null)))), this.c64.getClock().getCyclesPerFrame() << 2);
        }
    }

    @Override
    public void fastForward() {
        this.LOG.fine("fastForward");
        if (this.isOpen() && this.sidBuilder instanceof Mixer) {
            this.sidBuilder.fastForward();
        }
    }

    @Override
    public void normalSpeed() {
        this.LOG.fine("normalSpeed");
        if (this.isOpen() && this.sidBuilder instanceof Mixer) {
            this.sidBuilder.normalSpeed();
        }
    }

    @Override
    public String tuneInfo() {
        this.LOG.fine("tuneInfo");
        if (this.isOpen()) {
            return this.listToString(this.createTuneInfo());
        }
        return null;
    }

    @Override
    public String activeSettings() {
        this.LOG.fine("activeSettings");
        if (this.isOpen()) {
            return this.listToString(this.createActiveSettings());
        }
        return null;
    }

    @Override
    public String playerInfo() {
        this.LOG.fine("playerInfo");
        if (this.isOpen()) {
            return this.mapOfListToString(this.createPlayerInfo());
        }
        return null;
    }

    @Override
    public String playList() {
        this.LOG.fine("playList");
        if (this.isOpen()) {
            HashMap<String, Constable> mapping = new HashMap<String, Constable>();
            mapping.put("current", Integer.valueOf(this.playList.getCurrent()));
            mapping.put("length", Integer.valueOf(this.playList.getLength()));
            mapping.put("hasPrevious", Boolean.valueOf(this.playList.hasPrevious()));
            mapping.put("hasNext", Boolean.valueOf(this.playList.hasNext()));
            mapping.put("previous", Integer.valueOf(this.playList.getPrevious()));
            mapping.put("next", Integer.valueOf(this.playList.getNext()));
            return this.mapToString(mapping);
        }
        return null;
    }

    @Override
    public String status() {
        this.LOG.finest("status");
        if (this.isOpen()) {
            return this.getStatusLine(this.status);
        }
        return null;
    }

    @Override
    public void insertDisk(byte[] diskContents, String diskContentsName) {
        try {
            this.LOG.fine(String.format("insertDisk: %s(%d)", diskContentsName, diskContents.length));
            if (this.isOpen()) {
                File d64File = this.createReadOnlyFile(diskContents, diskContentsName);
                this.c1541Section.setDriveOn(true);
                this.hardwareEnsemble.enableFloppyDiskDrives(true);
                DiskImage disk = this.hardwareEnsemble.getFloppies()[0].getDiskController().insertDisk(d64File);
                disk.setExtendImagePolicy(() -> true);
                this.installHack(d64File);
            }
        }
        catch (IOException e) {
            this.LOG.severe(e.getMessage());
            this.LOG.severe(String.format("Cannot insert media file '%s'.", diskContentsName));
        }
    }

    @Override
    public void ejectDisk() {
        try {
            this.LOG.fine("ejectDisk");
            if (this.isOpen()) {
                this.hardwareEnsemble.getFloppies()[0].getDiskController().ejectDisk();
            }
        }
        catch (IOException e) {
            this.LOG.severe(e.getMessage());
            this.LOG.severe("Cannot eject disk.");
        }
    }

    @Override
    public void insertTape(byte[] tapeContents, String tapeContentsName) {
        try {
            this.LOG.fine(String.format("insertTape: %s(%d)", tapeContentsName, tapeContents.length));
            if (this.isOpen()) {
                if (!tapeContentsName.toLowerCase(Locale.US).endsWith(".tap")) {
                    SidTune prg = SidTune.load(tapeContentsName, new ByteArrayInputStream(tapeContents));
                    PRG2TAPProgram program = new PRG2TAPProgram(prg, IOUtils.getFilenameWithoutSuffix(tapeContentsName), PSID_DRIVER_BIN);
                    PRG2TAP prg2tap = new PRG2TAP();
                    prg2tap.setTurboTape(this.sidplay2Section.isTurboTape());
                    prg2tap.open();
                    prg2tap.addBin(program, TURBO_HEADER_ROM, TURBO_DATA_ROM, SLOW_HEADER_ROM);
                    prg2tap.close();
                    File convertedTapeFile = this.createReadOnlyFile(prg2tap.getResult(), tapeContentsName + ".tap");
                    this.hardwareEnsemble.getDatasette().insertTape(convertedTapeFile);
                } else {
                    File tapeFile = this.createReadOnlyFile(tapeContents, tapeContentsName);
                    this.hardwareEnsemble.getDatasette().insertTape(tapeFile);
                }
            }
        }
        catch (IOException | SidTuneError e) {
            this.LOG.severe(e.getMessage());
            this.LOG.severe(String.format("Cannot insert media file '%s'.", tapeContentsName));
        }
    }

    @Override
    public void ejectTape() {
        try {
            this.LOG.fine("ejectTape");
            if (this.isOpen()) {
                this.hardwareEnsemble.getDatasette().ejectTape();
            }
        }
        catch (IOException e) {
            this.LOG.severe(e.getMessage());
            this.LOG.severe("Cannot eject tape.");
        }
    }

    @Override
    public void controlDatasette(Datasette.Control control) {
        this.LOG.fine(String.format("controlDatasette: %s", new Object[]{control}));
        if (this.isOpen()) {
            this.hardwareEnsemble.getDatasette().control(control);
        }
    }

    @Override
    public void insertREUfile(byte[] cartContents, String cartContentsName) {
        try {
            this.LOG.fine(String.format("insertREU file: %s(%d)", cartContentsName, cartContents.length));
            if (this.isOpen()) {
                File cartFile = this.createReadOnlyFile(cartContents, cartContentsName);
                this.c64.setCartridge(CartridgeType.REU, cartFile);
                this.LOG.fine("REU: image attached: " + cartContentsName);
            }
        }
        catch (IOException e) {
            this.LOG.severe(e.getMessage());
            this.LOG.severe(String.format("Cannot insert media file '%s'.", cartContentsName));
        }
    }

    @Override
    public void insertREU(int sizeKb) {
        try {
            this.LOG.fine(String.format("insertREU: %d", sizeKb));
            if (this.isOpen()) {
                if (sizeKb > 0) {
                    this.c64.setCartridge(CartridgeType.REU, sizeKb);
                    this.LOG.fine(String.format("REU: image attached: sizeKb=%d", sizeKb));
                } else if (this.c64.getCartridge().getClass().getSimpleName().equals("REU")) {
                    this.c64.ejectCartridge();
                    this.LOG.fine("REU: image detached");
                }
            }
        }
        catch (IOException e) {
            this.LOG.severe(e.getMessage());
            this.LOG.severe(String.format("Cannot insert media sizeKb=%d.", sizeKb));
        }
    }

    @Override
    public void freezeCartridge() {
        this.LOG.fine("freezeCartridge");
        if (this.isOpen()) {
            this.c64.getCartridge().freeze();
        }
    }

    @Override
    public void oscilloscope(boolean enable, double fps, int width, int height) {
        this.LOG.fine(String.format("oscilloscope enable: %b, fps: %f, width: %d, height: %d", enable, fps, width, height));
        if (this.isOpen()) {
            if (this.oscilloscope == null) {
                this.oscilloscope = new Oscilloscope(this.importedApi, this.c64, this.sidBuilder, RESOURCE_BUNDLE, width, height);
            }
            if (enable) {
                this.oscilloscope.start(fps);
            } else {
                this.oscilloscope.stop();
            }
        }
    }

    @Override
    public void delaySidBlaster(int cycles) {
        long delay = (long)((double)cycles / CPUClock.PAL.getCpuFrequency() * 1.0E9);
        long startTime = System.nanoTime();
        while (System.nanoTime() - startTime < delay) {
        }
    }

    private void doLog(ISidPlay2Section sidplay2Section, IAudioSection audioSection, IEmulationSection emulationSection, IC1541Section c1541Section) {
        this.LOG.fine("defaultPlayLength: " + sidplay2Section.getDefaultPlayLength());
        this.LOG.fine("loop: " + sidplay2Section.isLoop());
        this.LOG.fine("single: " + sidplay2Section.isSingle());
        this.LOG.fine("palEmulation: " + sidplay2Section.isPalEmulation());
        this.LOG.fine("fadeInTime: " + sidplay2Section.getFadeInTime());
        this.LOG.fine("fadeOutTime: " + sidplay2Section.getFadeOutTime());
        this.LOG.fine("samplingRate: " + (Object)((Object)audioSection.getSamplingRate()));
        this.LOG.fine("sampling: " + (Object)((Object)audioSection.getSampling()));
        this.LOG.fine("bufferSize: " + audioSection.getBufferSize());
        this.LOG.fine("audioBufferSize: " + audioSection.getAudioBufferSize());
        this.LOG.fine("reverbBypass: " + audioSection.getReverbBypass());
        this.LOG.fine("engine: " + (Object)((Object)emulationSection.getEngine()));
        this.LOG.fine("detectPSID64ChipModel: " + emulationSection.isDetectPSID64ChipModel());
        this.LOG.fine("isJiffyDosInstalled: " + c1541Section.isJiffyDosInstalled());
    }

    private void doLog(IEmulationSection emulationSection, SidTune tune) {
        this.doLogFilterNames(emulationSection, tune);
        this.doLogCPUClock(emulationSection, tune);
        this.doLogEmulation(emulationSection, tune);
        this.doLogChipModel(emulationSection, tune);
    }

    private void doLogFilterNames(IEmulationSection emulationSection, SidTune tune) {
        for (int sidNum = 0; sidNum < ISidPlay2SystemProperties.MAX_SIDS; ++sidNum) {
            if (!SidTune.isSIDUsed(emulationSection, tune, sidNum)) continue;
            Engine engine = Engine.getEngine(emulationSection, tune);
            Emulation emulation = Emulation.getEmulation(emulationSection, sidNum);
            ChipModel chipModel = ChipModel.getChipModel(emulationSection, tune, sidNum);
            String filterName = emulationSection.getFilterName(sidNum, engine, emulation, chipModel);
            this.LOG.fine(this.getFilterName(sidNum, filterName));
        }
    }

    private void doLogCPUClock(IEmulationSection emulationSection, SidTune tune) {
        CPUClock cpuClock = CPUClock.getCPUClock(emulationSection, tune);
        this.LOG.fine("cpuClock: " + (Object)((Object)cpuClock));
    }

    private void doLogEmulation(IEmulationSection emulationSection, SidTune tune) {
        StringBuilder result = new StringBuilder();
        for (int sidNum = 0; sidNum < ISidPlay2SystemProperties.MAX_SIDS; ++sidNum) {
            if (!SidTune.isSIDUsed(emulationSection, tune, sidNum)) continue;
            Emulation emulation = Emulation.getEmulation(emulationSection, sidNum);
            if (sidNum > 0) {
                result.append("+");
            }
            result.append((Object)emulation);
        }
        this.LOG.fine("Emulation: " + result);
    }

    private void doLogChipModel(IEmulationSection emulationSection, SidTune tune) {
        StringBuilder result = new StringBuilder();
        for (int sidNum = 0; sidNum < ISidPlay2SystemProperties.MAX_SIDS; ++sidNum) {
            if (!SidTune.isSIDUsed(emulationSection, tune, sidNum)) continue;
            ChipModel chipModel = ChipModel.getChipModel(emulationSection, tune, sidNum);
            int sidBase = SidTune.getSIDAddress(emulationSection, tune, sidNum);
            if (sidNum > 0) {
                result.append("+");
            }
            this.determineChipModel(result, chipModel, sidBase);
        }
        this.LOG.fine("ChipModel: " + result);
    }

    private String getFilterName(int sidNum, String filterName) {
        switch (sidNum) {
            default: {
                return "Filter: " + filterName;
            }
            case 1: {
                return "Stereo Filter: " + filterName;
            }
            case 2: 
        }
        return "3-SID Filter: " + filterName;
    }

    private void determineChipModel(StringBuilder result, ChipModel chipModel, int sidBase) {
        if (sidBase != 54272) {
            result.append(String.format("%s(at 0x%04x)", new Object[]{chipModel, sidBase}));
        } else {
            result.append((Object)chipModel);
        }
    }

    private boolean isOpen() {
        return this.c64 != null;
    }

    private void insertCart(byte[] cartContents, String cartContentsName) {
        try {
            File cartFile = this.createReadOnlyFile(cartContents, cartContentsName);
            this.c64.setCartridge(CartridgeType.CRT, cartFile);
            this.LOG.fine("Cartridge: media attached: " + cartContentsName);
        }
        catch (IOException e) {
            this.LOG.severe(e.getMessage());
            this.LOG.severe(String.format("Cannot insert media file '%s'.", cartContentsName));
        }
    }

    private void insertCart(CartridgeType cartType, int size) {
        try {
            this.c64.setCartridge(cartType, size);
            this.LOG.fine("Cartridge: media attached: " + cartType.name());
        }
        catch (IOException e) {
            this.LOG.severe(e.getMessage());
            this.LOG.severe(String.format("Cannot insert media type '%s' sizeKb=%d", cartType.name(), size));
        }
    }

    private void autodetectPSID64() {
        if (this.emulationSection.isDetectPSID64ChipModel()) {
            PSid64DetectedTuneInfo psid64TuneInfo = PSid64Detection.detectPSid64TuneInfo(this.c64.getRAM(), this.c64.getVicMemBase() + this.c64.getVIC().getVideoMatrixBase());
            if (psid64TuneInfo.isDetected()) {
                this.psid64Detected = true;
                boolean update = false;
                if (psid64TuneInfo.hasDifferentUserChipModel(ChipModel.getChipModel(this.emulationSection, this.tune, 0))) {
                    this.emulationSection.getOverrideSection().getSidModel()[0] = psid64TuneInfo.getUserChipModel();
                    update = true;
                }
                if (psid64TuneInfo.hasDifferentStereoChipModel(ChipModel.getChipModel(this.emulationSection, this.tune, 1))) {
                    this.emulationSection.getOverrideSection().getSidModel()[1] = psid64TuneInfo.getStereoChipModel();
                    update = true;
                }
                if (psid64TuneInfo.hasDifferentStereoAddress(SidTune.getSIDAddress(this.emulationSection, this.tune, 1))) {
                    this.emulationSection.getOverrideSection().getSidBase()[1] = psid64TuneInfo.getStereoAddress();
                    update = true;
                }
                if (update) {
                    this.updateSids(this.emulationSection);
                    return;
                }
            }
            if (!this.psid64Detected && this.autodetectPSID64Counter++ < 10) {
                this.context.schedule(Event.of("PSID64 Detection", event2 -> this.autodetectPSID64()), (long)this.c64.getClock().getCpuFrequency());
            }
        }
    }

    private void updateSids(IEmulationSection emulationSection) {
        this.c64.insertSIDChips((sidNum, sidEmu) -> {
            if (SidTune.isSIDUsed(emulationSection, this.tune, sidNum)) {
                return this.sidBuilder.lock((SIDEmu)sidEmu, (int)sidNum, this.tune);
            }
            if (sidEmu != SIDEmu.NONE) {
                this.sidBuilder.unlock((SIDEmu)sidEmu);
            }
            return SIDEmu.NONE;
        }, sidNum -> SidTune.getSIDAddress(emulationSection, this.tune, sidNum));
    }

    private void installHack(File d64File) {
        this.c64.getCPU().setEODHack(d64File.getName().toLowerCase(Locale.US).contains("disgrace"));
    }

    private File createReadOnlyFile(byte[] fileContents, String fileContentsUrl) throws IOException, FileNotFoundException {
        String filenamePrefix = IOUtils.getFilenameWithoutSuffix(fileContentsUrl);
        while (filenamePrefix.length() < 3) {
            filenamePrefix = filenamePrefix + " ";
        }
        File tmp = File.createTempFile(filenamePrefix, IOUtils.getFilenameSuffix(fileContentsUrl));
        try (FileOutputStream os = new FileOutputStream(tmp);){
            ((OutputStream)os).write(fileContents);
        }
        tmp.setWritable(false);
        return tmp;
    }

    private String getStatusLine(Status status) {
        String determineTapeActivity = status.determineTapeActivity(true);
        String determineDiskActivity = status.determineDiskActivity(true);
        String determineSongLength = status.determineSongLength(true);
        String determineRecording = status.determineRecording();
        String determinePSID64 = status.determinePSID64();
        String determineCartridge = status.determineCartridge();
        String determineTuneSpeed = status.determineTuneSpeed();
        String determineSong = status.determineSong();
        StringBuilder line = new StringBuilder();
        line.append(status.determineVideoNorm());
        line.append(", ");
        line.append(status.determineChipModels());
        line.append(", ");
        line.append(status.determineEmulations());
        line.append(this.playerId == null || this.playerId.isEmpty() ? "" : ", " + this.playerId);
        line.append(determinePSID64.isEmpty() ? "" : ", " + determinePSID64);
        line.append(determineCartridge.isEmpty() ? "" : ", " + determineCartridge);
        line.append(determineTuneSpeed.isEmpty() ? "" : ", " + determineTuneSpeed);
        line.append(determineSong.isEmpty() ? "" : ", " + determineSong);
        line.append(determineDiskActivity.isEmpty() ? "" : ", " + determineDiskActivity);
        line.append(determineTapeActivity.isEmpty() ? "" : ", " + determineTapeActivity);
        line.append(", ");
        line.append(status.determineTime(true));
        line.append(determineSongLength.isEmpty() ? "" : "/" + determineSongLength);
        line.append(determineRecording.isEmpty() ? "" : ", " + determineRecording);
        return line.toString();
    }

    private List<Map<?, ?>> createTuneInfo() {
        ArrayList result = new ArrayList();
        if (this.hvscEntry != null) {
            result.add(this.createMap("HVSCEntry.name", ExportedApi.getText(this.hvscEntry.getName())));
            result.add(this.createMap("HVSCEntry.title", ExportedApi.getText(this.hvscEntry.getTitle())));
            if (this.hvscEntry.getAuthor() != null && this.hvscEntry.getAuthor().length() > 0) {
                result.add(this.createMap("HVSCEntry.author", ExportedApi.getText(this.hvscEntry.getAuthor())));
            }
            if (this.hvscEntry.getReleased() != null && this.hvscEntry.getReleased().length() > 0) {
                result.add(this.createMap("HVSCEntry.released", ExportedApi.getText(this.hvscEntry.getReleased())));
            }
            result.add(this.createMap("HVSCEntry.audio", ExportedApi.getText(this.hvscEntry.getAudio())));
            result.add(this.createMap("HVSCEntry.format", ExportedApi.getText(this.hvscEntry.getFormat())));
            result.add(this.createMap("HVSCEntry.compatibility", ExportedApi.getText((Object)this.hvscEntry.getCompatibility())));
            result.add(this.createMap("HVSCEntry.speed", ExportedApi.getText((Object)this.hvscEntry.getSpeed())));
            if (this.hvscEntry.getPlayerId() != null && this.hvscEntry.getPlayerId().length() > 0) {
                result.add(this.createMap("HVSCEntry.playerId", ExportedApi.getText(this.hvscEntry.getPlayerId())));
            }
            if (this.hvscEntry.getNoOfSongs() != 1) {
                result.add(this.createMap("HVSCEntry.noOfSongs", ExportedApi.getText(this.hvscEntry.getNoOfSongs())));
                result.add(this.createMap("HVSCEntry.startSong", ExportedApi.getText(this.hvscEntry.getStartSong())));
            }
            if (this.hvscEntry.getTuneLength() != 0.0) {
                result.add(this.createMap("HVSCEntry.tuneLength", ExportedApi.getText(this.hvscEntry.getTuneLength())));
            }
            result.add(this.createMap("HVSCEntry.clockFreq", ExportedApi.getText((Object)this.hvscEntry.getClockFreq())));
            result.add(this.createMap("HVSCEntry.sidModel1", ExportedApi.getText((Object)this.hvscEntry.getSidModel1())));
            if (this.hvscEntry.getSidModel2() != SidTune.Model.UNKNOWN) {
                result.add(this.createMap("HVSCEntry.sidModel2", ExportedApi.getText((Object)this.hvscEntry.getSidModel2())));
            }
            if (this.hvscEntry.getSidModel3() != SidTune.Model.UNKNOWN) {
                result.add(this.createMap("HVSCEntry.sidModel3", ExportedApi.getText((Object)this.hvscEntry.getSidModel3())));
            }
            result.add(this.createMap("HVSCEntry.sidChipBase1", ExportedApi.getText(this.hvscEntry.getSidChipBase1())));
            if (this.hvscEntry.getSidChipBase2() != 0) {
                result.add(this.createMap("HVSCEntry.sidChipBase2", ExportedApi.getText(this.hvscEntry.getSidChipBase2())));
            }
            if (this.hvscEntry.getSidChipBase3() != 0) {
                result.add(this.createMap("HVSCEntry.sidChipBase3", ExportedApi.getText(this.hvscEntry.getSidChipBase3())));
            }
            if (this.hvscEntry.getDriverAddress() != 0) {
                result.add(this.createMap("HVSCEntry.driverAddress", ExportedApi.getText(this.hvscEntry.getDriverAddress())));
            }
            result.add(this.createMap("HVSCEntry.loadAddress", ExportedApi.getText(this.hvscEntry.getLoadAddress())));
            result.add(this.createMap("HVSCEntry.loadLength", ExportedApi.getText(this.hvscEntry.getLoadLength())));
            if (this.hvscEntry.getInitAddress() != 0) {
                result.add(this.createMap("HVSCEntry.initAddress", ExportedApi.getText(this.hvscEntry.getInitAddress())));
            }
            if (this.hvscEntry.getPlayerAddress() != 0) {
                result.add(this.createMap("HVSCEntry.playerAddress", ExportedApi.getText(this.hvscEntry.getPlayerAddress())));
            }
            if (this.hvscEntry.getFileDate() != null) {
                result.add(this.createMap("HVSCEntry.fileDate", ExportedApi.getText(this.hvscEntry.getFileDate())));
            }
            result.add(this.createMap("HVSCEntry.fileSizeKb", ExportedApi.getText(this.hvscEntry.getFileSizeKb())));
            result.add(this.createMap("HVSCEntry.tuneSizeB", ExportedApi.getText(this.hvscEntry.getTuneSizeB())));
            if (this.hvscEntry.getRelocStartPage() != 0) {
                result.add(this.createMap("HVSCEntry.relocStartPage", ExportedApi.getText(this.hvscEntry.getRelocStartPage())));
            }
            if (this.hvscEntry.getRelocNoPages() != 0) {
                result.add(this.createMap("HVSCEntry.relocNoPages", ExportedApi.getText(this.hvscEntry.getRelocNoPages())));
            }
        }
        return result;
    }

    private Map<String, List<Map<String, String>>> createPlayerInfo() {
        HashMap<String, List<Map<String, String>>> result = new HashMap<String, List<Map<String, String>>>();
        if (this.playerIds != null) {
            for (String id : this.playerIds) {
                SidIdInfo.PlayerInfoSection playerIdInfo = this.tune.getPlayerInfo(id, SID_ID_INFO_CFG_BIN);
                if (playerIdInfo == null) continue;
                ArrayList<Map<String, String>> playerIdMap = new ArrayList<Map<String, String>>();
                result.put(id, playerIdMap);
                if (playerIdInfo.getName() != null) {
                    playerIdMap.add(this.createMap("NAME", playerIdInfo.getName()));
                }
                if (playerIdInfo.getAuthor() != null) {
                    playerIdMap.add(this.createMap("AUTHOR", playerIdInfo.getAuthor()));
                }
                if (playerIdInfo.getReleased() != null) {
                    playerIdMap.add(this.createMap("RELEASED", playerIdInfo.getReleased()));
                }
                if (playerIdInfo.getReference() != null) {
                    playerIdMap.add(this.createMap("REFERENCE", playerIdInfo.getReference()));
                }
                if (playerIdInfo.getComment() == null) continue;
                playerIdMap.add(this.createMap("COMMENT", playerIdInfo.getComment()));
            }
        }
        return result;
    }

    private List<Map<?, ?>> createActiveSettings() {
        ArrayList result = new ArrayList();
        int sidNums = 0;
        for (int sidNum = 0; sidNum < ISidPlay2SystemProperties.MAX_SIDS; ++sidNum) {
            if (!SidTune.isSIDUsed(this.emulationSection, this.tune, sidNum)) continue;
            Engine engine = Engine.getEngine(this.emulationSection, this.tune);
            Emulation emulation = Emulation.getEmulation(this.emulationSection, sidNum);
            ChipModel chipModel = ChipModel.getChipModel(this.emulationSection, this.tune, sidNum);
            String filterName = this.emulationSection.getFilterName(sidNum, engine, emulation, chipModel);
            this.engines[sidNum] = engine;
            this.emulations[sidNum] = emulation;
            this.chipModels[sidNum] = chipModel;
            this.filterNames[sidNum] = filterName;
            ++sidNums;
        }
        result.add(this.createMap("ENGINES", Arrays.asList(this.engines).stream().limit(sidNums).map(Object::toString).collect(Collectors.joining(","))));
        result.add(this.createMap("EMULATIONS", Arrays.asList(this.emulations).stream().limit(sidNums).map(Object::toString).collect(Collectors.joining(","))));
        result.add(this.createMap("CHIP_MODELS", Arrays.asList(this.chipModels).stream().limit(sidNums).map(Object::toString).collect(Collectors.joining(","))));
        result.add(this.createMap("FILTER_NAMES", Arrays.asList(this.filterNames).stream().limit(sidNums).map(Object::toString).collect(Collectors.joining(","))));
        return result;
    }

    private Map<String, String> createMap(String name, String value) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Name", name);
        result.put("Value", value.replace('\n', ' '));
        return result;
    }

    private static String getText(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Double) {
            return new TimeConverter().toString((Double)value);
        }
        if (value instanceof Integer && (Integer)value > 255) {
            return String.format("0x%04X (%d)", value, value);
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        return value.toString();
    }

    private String mapOfListToString(Map<String, List<Map<String, String>>> playerInfo) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (Map.Entry<String, List<Map<String, String>>> mappingEntry : playerInfo.entrySet()) {
            result.append("{");
            result.append("\"Id\":");
            result.append("\"").append((Object)mappingEntry.getKey()).append("\",");
            result.append("\"Properties\":");
            result.append("[");
            for (Map<String, String> map : playerInfo.get(mappingEntry.getKey())) {
                result.append(this.mapToString(map));
                result.append(",");
            }
            if (result.charAt(result.length() - 1) == ',') {
                result.deleteCharAt(result.length() - 1);
            }
            result.append("]");
            result.append("}");
            result.append(",");
        }
        if (result.charAt(result.length() - 1) == ',') {
            result.deleteCharAt(result.length() - 1);
        }
        result.append("]");
        return result.toString();
    }

    private String listToString(List<Map<?, ?>> list) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (Map<?, ?> listElem : list) {
            result.append(this.mapToString(listElem));
            result.append(",");
        }
        if (result.charAt(result.length() - 1) == ',') {
            result.deleteCharAt(result.length() - 1);
        }
        result.append("]");
        return result.toString();
    }

    private String mapToString(Map<?, ?> mapping) {
        StringBuilder result = new StringBuilder();
        result.append("{");
        for (Map.Entry<?, ?> mappingEntry : mapping.entrySet()) {
            result.append("\"").append(mappingEntry.getKey()).append("\"");
            result.append(":");
            if (mappingEntry.getValue().getClass().equals(String.class)) {
                result.append("\"").append(mappingEntry.getValue()).append("\"");
            } else {
                result.append(mappingEntry.getValue());
            }
            result.append(",");
        }
        if (result.charAt(result.length() - 1) == ',') {
            result.deleteCharAt(result.length() - 1);
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public void finest(String message) {
        if (!this.mainArgs.isQuiet() && this.mainArgs.isDebug() && this.mainArgs.getVerbose() > 1) {
            LOG_IMPL.finest(message);
        }
    }

    @Override
    public void fine(String message) {
        if (!this.mainArgs.isQuiet() && this.mainArgs.isDebug()) {
            LOG_IMPL.fine(message);
        }
    }

    @Override
    public void info(String message) {
        if (!this.mainArgs.isQuiet()) {
            LOG_IMPL.info(message);
        }
    }

    @Override
    public void severe(String message) {
        if (!this.mainArgs.isQuiet()) {
            LOG_IMPL.severe(message);
        }
    }
}

