/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ITimeValue;
import com.xuggle.xuggler.Utils;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAudioSamplesGenerator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private int mNumChannels = 0;
    private int mSampleRate = 0;
    private int mDesiredNoteFrequency = 440;
    private long mSamplesGenerated = 0L;
    private long mStartingPts = 0L;

    public TestAudioSamplesGenerator() {
        this.log.trace("firing up");
    }

    public void fillNextSamples(IAudioSamples samples, long samplesRequested) {
        long samplesToGen = Math.min(samples.getMaxSamples(), samplesRequested);
        if (samples.getChannels() != this.mNumChannels) {
            throw new IllegalArgumentException("unmatched channels ");
        }
        if (samplesToGen <= 0L) {
            throw new IllegalArgumentException("incorrect number of samples to generate");
        }
        IBuffer buf = samples.getData();
        if (buf == null) {
            throw new RuntimeException("could not get IBuffer from samples");
        }
        ByteBuffer data = buf.getByteBuffer(0, buf.getBufferSize());
        if (data == null) {
            throw new RuntimeException("could not get raw data from samples");
        }
        data.clear();
        long startingSample = this.mSamplesGenerated;
        long startingPts = Utils.samplesToTimeValue(this.mSamplesGenerated, this.mSampleRate).get(ITimeValue.Unit.MICROSECONDS) + this.mStartingPts;
        for (long i = 0L; i < samplesToGen; ++i) {
            double time = (double)this.mSamplesGenerated / (double)this.mSampleRate;
            double croppedTime = time % (1.0 / (double)this.mDesiredNoteFrequency);
            double percentOfRange = croppedTime / (1.0 / (double)this.mDesiredNoteFrequency);
            double cycleValue = percentOfRange * Math.PI * 2.0;
            double samp = Math.sin(cycleValue);
            short aNoteSample = (short)(samp * 256.0 * 256.0 * 0.5);
            for (int j = 0; j < this.mNumChannels; ++j) {
                data.put((byte)(aNoteSample & 0xFF));
                data.put((byte)(aNoteSample >> 8 & 0xFF));
            }
            ++this.mSamplesGenerated;
        }
        data.flip();
        this.log.trace("completed: {}, {}, {}, {}, {}, {}", new Object[]{samplesToGen, this.mSampleRate, this.mNumChannels, startingPts, startingSample, IAudioSamples.Format.FMT_S16});
        samples.setComplete(true, samplesToGen, this.mSampleRate, this.mNumChannels, IAudioSamples.Format.FMT_S16, startingPts);
    }

    public void prepare(int numChannels, int sampleRate) {
        this.prepare(numChannels, sampleRate, 0L);
    }

    public void prepare(int numChannels, int sampleRate, long startingPts) {
        this.mNumChannels = numChannels;
        this.mSampleRate = sampleRate;
        this.mStartingPts = startingPts;
        this.log.debug("prepare - channels: {}, sampleRate: {}", (Object)numChannels, (Object)sampleRate);
    }

    public void setDesiredNoteFrequency(int note) {
        this.mDesiredNoteFrequency = note;
    }

    public int getDesiredNoteFrequency() {
        return this.mDesiredNoteFrequency;
    }
}

