/*
 * Decompiled with CFR 0.152.
 */
package ui.oscilloscope;

import java.beans.PropertyChangeListener;
import java.util.function.Consumer;
import javafx.animation.Animation;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.util.Duration;
import libsidplay.common.SIDEmu;
import libsidplay.config.ISidPlay2SystemProperties;
import libsidutils.oscilloscope.OscilloscopeUtil;
import sidplay.Player;
import sidplay.player.State;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.entities.config.EmulationSection;
import ui.oscilloscope.EnvelopeGauge;
import ui.oscilloscope.FilterGauge;
import ui.oscilloscope.FrequencyGauge;
import ui.oscilloscope.Gauge;
import ui.oscilloscope.ResonanceGauge;
import ui.oscilloscope.VolumeGauge;
import ui.oscilloscope.WaveGauge;

public class Oscilloscope
extends C64VBox
implements UIPart {
    public static final String ID = "OSCILLOSCOPE";
    private OscilloscopeUtil oscilloscopeUtil;
    @FXML
    protected CheckBox muteVoice1;
    @FXML
    protected CheckBox muteVoice2;
    @FXML
    protected CheckBox muteVoice3;
    @FXML
    protected CheckBox muteVoice4;
    @FXML
    protected CheckBox muteVoice5;
    @FXML
    protected CheckBox muteVoice6;
    @FXML
    protected CheckBox muteVoice7;
    @FXML
    protected CheckBox muteVoice8;
    @FXML
    protected CheckBox muteVoice9;
    @FXML
    protected CheckBox muteVoice10;
    @FXML
    protected CheckBox muteVoice11;
    @FXML
    protected CheckBox muteVoice12;
    @FXML
    private WaveGauge waveMono_0;
    @FXML
    private WaveGauge waveMono_1;
    @FXML
    private WaveGauge waveMono_2;
    @FXML
    private WaveGauge waveStereo_0;
    @FXML
    private WaveGauge waveStereo_1;
    @FXML
    private WaveGauge waveStereo_2;
    @FXML
    private WaveGauge wave3Sid_0;
    @FXML
    private WaveGauge wave3Sid_1;
    @FXML
    private WaveGauge wave3Sid_2;
    @FXML
    private EnvelopeGauge envMono_0;
    @FXML
    private EnvelopeGauge envMono_1;
    @FXML
    private EnvelopeGauge envMono_2;
    @FXML
    private EnvelopeGauge envStereo_0;
    @FXML
    private EnvelopeGauge envStereo_1;
    @FXML
    private EnvelopeGauge envStereo_2;
    @FXML
    private EnvelopeGauge env3Sid_0;
    @FXML
    private EnvelopeGauge env3Sid_1;
    @FXML
    private EnvelopeGauge env3Sid_2;
    @FXML
    private FrequencyGauge freqMono_0;
    @FXML
    private FrequencyGauge freqMono_1;
    @FXML
    private FrequencyGauge freqMono_2;
    @FXML
    private FrequencyGauge freqStereo_0;
    @FXML
    private FrequencyGauge freqStereo_1;
    @FXML
    private FrequencyGauge freqStereo_2;
    @FXML
    private FrequencyGauge freq3Sid_0;
    @FXML
    private FrequencyGauge freq3Sid_1;
    @FXML
    private FrequencyGauge freq3Sid_2;
    @FXML
    private VolumeGauge volumeMono;
    @FXML
    private VolumeGauge volumeStereo;
    @FXML
    private VolumeGauge volume3Sid;
    @FXML
    private ResonanceGauge resonanceMono;
    @FXML
    private ResonanceGauge resonanceStereo;
    @FXML
    private ResonanceGauge resonance3Sid;
    @FXML
    private FilterGauge filterMono;
    @FXML
    private FilterGauge filterStereo;
    @FXML
    private FilterGauge filter3Sid;
    private PauseTransition pauseTransition;
    private SequentialTransition sequentialTransition;
    private PropertyChangeListener listener;

    public Oscilloscope() {
    }

    public Oscilloscope(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.oscilloscopeUtil = new OscilloscopeUtil(this.util.getPlayer().getC64()){

            @Override
            protected void sampleGauges(Integer chipNum, SIDEmu sid, boolean isLowerResolution) {
                Oscilloscope.this.sampleGauges(chipNum, sid, isLowerResolution);
            }

            @Override
            protected void updateGauges(Integer chipNum, SIDEmu sid) {
                Oscilloscope.this.updateGauges(chipNum, gauge -> gauge.addImage(sid));
            }
        };
        this.listener = event -> {
            if (event.getNewValue() == State.START) {
                this.oscilloscopeUtil.start(this.util.getPlayer().getC64().getClock().getScreenRefresh());
                Platform.runLater(() -> this.startOscilloscope());
            } else if (event.getNewValue() == State.END || event.getNewValue() == State.RESTART || event.getNewValue() == State.QUIT) {
                this.oscilloscopeUtil.stop();
                Platform.runLater(() -> this.stopOscilloscope());
            }
        };
        this.util.getPlayer().stateProperty().addListener(this.listener);
        this.waveMono_0.setLocalizer(this.util.getBundle());
        this.waveMono_1.setLocalizer(this.util.getBundle());
        this.waveMono_2.setLocalizer(this.util.getBundle());
        this.waveStereo_0.setLocalizer(this.util.getBundle());
        this.waveStereo_1.setLocalizer(this.util.getBundle());
        this.waveStereo_2.setLocalizer(this.util.getBundle());
        this.wave3Sid_0.setLocalizer(this.util.getBundle());
        this.wave3Sid_1.setLocalizer(this.util.getBundle());
        this.wave3Sid_2.setLocalizer(this.util.getBundle());
        this.filterMono.setLocalizer(this.util.getBundle());
        this.filterStereo.setLocalizer(this.util.getBundle());
        this.filter3Sid.setLocalizer(this.util.getBundle());
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        this.muteVoice1.selectedProperty().bindBidirectional((Property)emulationSection.muteVoice1Property());
        this.muteVoice2.selectedProperty().bindBidirectional((Property)emulationSection.muteVoice2Property());
        this.muteVoice3.selectedProperty().bindBidirectional((Property)emulationSection.muteVoice3Property());
        this.muteVoice4.selectedProperty().bindBidirectional((Property)emulationSection.muteVoice4Property());
        this.muteVoice5.selectedProperty().bindBidirectional((Property)emulationSection.muteStereoVoice1Property());
        this.muteVoice6.selectedProperty().bindBidirectional((Property)emulationSection.muteStereoVoice2Property());
        this.muteVoice7.selectedProperty().bindBidirectional((Property)emulationSection.muteStereoVoice3Property());
        this.muteVoice8.selectedProperty().bindBidirectional((Property)emulationSection.muteStereoVoice4Property());
        this.muteVoice9.selectedProperty().bindBidirectional((Property)emulationSection.muteThirdSIDVoice1Property());
        this.muteVoice10.selectedProperty().bindBidirectional((Property)emulationSection.muteThirdSIDVoice2Property());
        this.muteVoice11.selectedProperty().bindBidirectional((Property)emulationSection.muteThirdSIDVoice3Property());
        this.muteVoice12.selectedProperty().bindBidirectional((Property)emulationSection.muteThirdSIDVoice4Property());
        this.startOscilloscope();
        this.oscilloscopeUtil.start((int)this.util.getPlayer().getC64().getClock().getScreenRefresh());
    }

    private void startOscilloscope() {
        for (int chipNum = 0; chipNum < ISidPlay2SystemProperties.MAX_SIDS; ++chipNum) {
            this.updateGauges(chipNum, Gauge::reset);
        }
        if (this.sequentialTransition != null) {
            this.sequentialTransition.stop();
        }
        this.pauseTransition = new PauseTransition();
        this.pauseTransition.setDuration(Duration.millis((double)(1000.0 / this.util.getPlayer().getC64().getClock().getScreenRefresh())));
        this.pauseTransition.setOnFinished(evt -> this.util.getPlayer().getC64().configureSIDs((chipNum, sid) -> this.updateGauges((Integer)chipNum, Gauge::updateGauge)));
        this.sequentialTransition = new SequentialTransition(new Animation[]{this.pauseTransition});
        this.sequentialTransition.setCycleCount(-1);
        this.sequentialTransition.playFromStart();
    }

    private void stopOscilloscope() {
        this.sequentialTransition.stop();
    }

    @Override
    public void doClose() {
        this.oscilloscopeUtil.stop();
        this.stopOscilloscope();
        this.util.getPlayer().stateProperty().removeListener(this.listener);
    }

    @FXML
    private void doMuteVoice1() {
        this.util.getPlayer().configureSID(0, sid -> sid.setVoiceMute(0, this.muteVoice1.isSelected()));
    }

    @FXML
    private void doMuteVoice2() {
        this.util.getPlayer().configureSID(0, sid -> sid.setVoiceMute(1, this.muteVoice2.isSelected()));
    }

    @FXML
    private void doMuteVoice3() {
        this.util.getPlayer().configureSID(0, sid -> sid.setVoiceMute(2, this.muteVoice3.isSelected()));
    }

    @FXML
    private void doMuteVoice4() {
        this.util.getPlayer().configureSID(0, sid -> sid.setVoiceMute(3, this.muteVoice4.isSelected()));
    }

    @FXML
    private void doMuteVoice5() {
        this.util.getPlayer().configureSID(1, sid -> sid.setVoiceMute(0, this.muteVoice5.isSelected()));
    }

    @FXML
    private void doMuteVoice6() {
        this.util.getPlayer().configureSID(1, sid -> sid.setVoiceMute(1, this.muteVoice6.isSelected()));
    }

    @FXML
    private void doMuteVoice7() {
        this.util.getPlayer().configureSID(1, sid -> sid.setVoiceMute(2, this.muteVoice7.isSelected()));
    }

    @FXML
    private void doMuteVoice8() {
        this.util.getPlayer().configureSID(1, sid -> sid.setVoiceMute(3, this.muteVoice8.isSelected()));
    }

    @FXML
    private void doMuteVoice9() {
        this.util.getPlayer().configureSID(2, sid -> sid.setVoiceMute(0, this.muteVoice9.isSelected()));
    }

    @FXML
    private void doMuteVoice10() {
        this.util.getPlayer().configureSID(2, sid -> sid.setVoiceMute(1, this.muteVoice10.isSelected()));
    }

    @FXML
    private void doMuteVoice11() {
        this.util.getPlayer().configureSID(2, sid -> sid.setVoiceMute(2, this.muteVoice11.isSelected()));
    }

    @FXML
    private void doMuteVoice12() {
        this.util.getPlayer().configureSID(2, sid -> sid.setVoiceMute(3, this.muteVoice12.isSelected()));
    }

    private void sampleGauges(Integer chipNum, SIDEmu sid, boolean isLowerResolution) {
        switch (chipNum) {
            case 0: {
                this.waveMono_0.sample(sid).advance();
                this.waveMono_1.sample(sid).advance();
                this.waveMono_2.sample(sid).advance();
                this.envMono_0.sample(sid);
                this.envMono_1.sample(sid);
                this.envMono_2.sample(sid);
                this.freqMono_0.sample(sid);
                this.freqMono_1.sample(sid);
                this.freqMono_2.sample(sid);
                this.volumeMono.sample(sid).advance();
                this.resonanceMono.sample(sid);
                this.filterMono.sample(sid);
                if (!isLowerResolution) break;
                this.envMono_0.advance();
                this.envMono_1.advance();
                this.envMono_2.advance();
                this.freqMono_0.advance();
                this.freqMono_1.advance();
                this.freqMono_2.advance();
                this.resonanceMono.advance();
                this.filterMono.advance();
                break;
            }
            case 1: {
                this.waveStereo_0.sample(sid).advance();
                this.waveStereo_1.sample(sid).advance();
                this.waveStereo_2.sample(sid).advance();
                this.envStereo_0.sample(sid);
                this.envStereo_1.sample(sid);
                this.envStereo_2.sample(sid);
                this.freqStereo_0.sample(sid);
                this.freqStereo_1.sample(sid);
                this.freqStereo_2.sample(sid);
                this.volumeStereo.sample(sid).advance();
                this.resonanceStereo.sample(sid);
                this.filterStereo.sample(sid);
                if (!isLowerResolution) break;
                this.envStereo_0.advance();
                this.envStereo_1.advance();
                this.envStereo_2.advance();
                this.freqStereo_0.advance();
                this.freqStereo_1.advance();
                this.freqStereo_2.advance();
                this.resonanceStereo.advance();
                this.filterStereo.advance();
                break;
            }
            case 2: {
                this.wave3Sid_0.sample(sid).advance();
                this.wave3Sid_1.sample(sid).advance();
                this.wave3Sid_2.sample(sid).advance();
                this.env3Sid_0.sample(sid);
                this.env3Sid_1.sample(sid);
                this.env3Sid_2.sample(sid);
                this.freq3Sid_0.sample(sid);
                this.freq3Sid_1.sample(sid);
                this.freq3Sid_2.sample(sid);
                this.volume3Sid.sample(sid).advance();
                this.resonance3Sid.sample(sid);
                this.filter3Sid.sample(sid);
                if (!isLowerResolution) break;
                this.env3Sid_0.advance();
                this.env3Sid_1.advance();
                this.env3Sid_2.advance();
                this.freq3Sid_0.advance();
                this.freq3Sid_1.advance();
                this.freq3Sid_2.advance();
                this.resonance3Sid.advance();
                this.filter3Sid.advance();
                break;
            }
        }
    }

    private void updateGauges(Integer chipNum, Consumer<Gauge> updater) {
        switch (chipNum) {
            case 0: {
                updater.accept(this.waveMono_0);
                updater.accept(this.waveMono_1);
                updater.accept(this.waveMono_2);
                updater.accept(this.envMono_0);
                updater.accept(this.envMono_1);
                updater.accept(this.envMono_2);
                updater.accept(this.freqMono_0);
                updater.accept(this.freqMono_1);
                updater.accept(this.freqMono_2);
                updater.accept(this.volumeMono);
                updater.accept(this.resonanceMono);
                updater.accept(this.filterMono);
                break;
            }
            case 1: {
                updater.accept(this.waveStereo_0);
                updater.accept(this.waveStereo_1);
                updater.accept(this.waveStereo_2);
                updater.accept(this.envStereo_0);
                updater.accept(this.envStereo_1);
                updater.accept(this.envStereo_2);
                updater.accept(this.freqStereo_0);
                updater.accept(this.freqStereo_1);
                updater.accept(this.freqStereo_2);
                updater.accept(this.volumeStereo);
                updater.accept(this.resonanceStereo);
                updater.accept(this.filterStereo);
                break;
            }
            case 2: {
                updater.accept(this.wave3Sid_0);
                updater.accept(this.wave3Sid_1);
                updater.accept(this.wave3Sid_2);
                updater.accept(this.env3Sid_0);
                updater.accept(this.env3Sid_1);
                updater.accept(this.env3Sid_2);
                updater.accept(this.freq3Sid_0);
                updater.accept(this.freq3Sid_1);
                updater.accept(this.freq3Sid_2);
                updater.accept(this.volume3Sid);
                updater.accept(this.resonance3Sid);
                updater.accept(this.filter3Sid);
                break;
            }
        }
    }
}

