/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart;

import builder.resid.SampleMixer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import libsidplay.common.Event;
import libsidplay.components.cart.CartridgeType;
import libsidplay.components.cart.supported.ActionReplay;
import libsidplay.components.cart.supported.AtomicPower;
import libsidplay.components.cart.supported.Comal80;
import libsidplay.components.cart.supported.EasyFlash;
import libsidplay.components.cart.supported.EpyxFastLoad;
import libsidplay.components.cart.supported.Expert;
import libsidplay.components.cart.supported.FinalV1;
import libsidplay.components.cart.supported.FinalV3;
import libsidplay.components.cart.supported.GMod2;
import libsidplay.components.cart.supported.GeoRAM;
import libsidplay.components.cart.supported.MagicDesk;
import libsidplay.components.cart.supported.MikroAss;
import libsidplay.components.cart.supported.Normal;
import libsidplay.components.cart.supported.OceanType1;
import libsidplay.components.cart.supported.REU;
import libsidplay.components.cart.supported.Rex;
import libsidplay.components.cart.supported.SFXSoundExpander;
import libsidplay.components.cart.supported.Zaxxon;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class Cartridge {
    private static final Charset ISO88591 = Charset.forName("ISO-8859-1");
    public final PLA pla;
    private boolean nmiState;
    private boolean irqState;
    protected SampleMixer sampler = new SampleMixer.NoOpSampleMixer();

    protected Cartridge(PLA pla) {
        this.pla = pla;
    }

    public Bank getRoml() {
        return this.pla.getDisconnectedBusBank();
    }

    public Bank getRomh() {
        return this.pla.getDisconnectedBusBank();
    }

    public Bank getUltimaxMemory() {
        return this.pla.getDisconnectedBusBank();
    }

    public Bank getIO1() {
        return this.pla.getDisconnectedBusBank();
    }

    public Bank getIO2() {
        return this.pla.getDisconnectedBusBank();
    }

    public static final Cartridge create(PLA pla, CartridgeType cartType, int sizeKB) throws IOException {
        switch (cartType) {
            case GEORAM: {
                return new GeoRAM(null, pla, sizeKB);
            }
            case REU: {
                return new REU(null, pla, sizeKB);
            }
            case SOUNDEXPANDER: {
                return new SFXSoundExpander(null, pla, sizeKB);
            }
        }
        throw new RuntimeException("Cartridge is unsupported");
    }

    public static Cartridge read(PLA pla, CartridgeType cartType, File file) throws IOException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            switch (cartType) {
                case GEORAM: {
                    GeoRAM geoRAM = new GeoRAM(dis, pla, (int)(file.length() >> 10));
                    return geoRAM;
                }
                case REU: {
                    REU rEU = new REU(dis, pla, (int)(file.length() >> 10));
                    return rEU;
                }
                case CRT: {
                    Cartridge cartridge = Cartridge.readCRT(pla, dis);
                    return cartridge;
                }
            }
            throw new RuntimeException("Cartridge unsupported");
        }
    }

    public static Cartridge readCRT(PLA pla, DataInputStream is) throws IOException {
        byte[] header = new byte[64];
        is.readFully(header);
        CRTType type = CRTType.getType(header);
        switch (type.ordinal()) {
            case 1: {
                return new ActionReplay(is, pla);
            }
            case 0: {
                return new Normal(is, pla);
            }
            case 3: {
                return new FinalV3(is, pla);
            }
            case 6: {
                return new Expert(is, pla);
            }
            case 9: {
                return new AtomicPower(is, pla);
            }
            case 10: {
                return new EpyxFastLoad(is, pla);
            }
            case 12: {
                return new Rex(is, pla);
            }
            case 13: {
                return new FinalV1(is, pla);
            }
            case 18: {
                return new Zaxxon(is, pla);
            }
            case 21: {
                return new Comal80(is, pla);
            }
            case 28: {
                return new MikroAss(is, pla);
            }
            case 32: {
                return new EasyFlash(is, pla);
            }
            case 19: {
                return new MagicDesk(is, pla);
            }
            case 5: {
                return new OceanType1(is, pla);
            }
            case 33: {
                return new GMod2(is, pla);
            }
        }
        throw new RuntimeException("Cartridges of format: " + (Object)((Object)type) + " unsupported");
    }

    public void installBankHooks(Bank[] cpuReadMap, Bank[] cpuWriteMap) {
    }

    public static Cartridge nullCartridge(PLA pla) {
        return new Cartridge(pla){

            @Override
            public String toString() {
                return "";
            }
        };
    }

    public void reset() {
        this.nmiState = false;
        this.irqState = false;
    }

    public final void freeze() {
        this.pla.getCPU().getEventScheduler().scheduleThreadSafe(Event.of("Freeze TS", event -> this.doFreeze()));
    }

    protected void doFreeze() {
    }

    public void changedNMI(boolean state) {
    }

    public void changedIRQ(boolean state) {
    }

    public void changedBA(boolean state) {
    }

    public void setNMI(boolean state) {
        if (state ^ this.nmiState) {
            this.pla.setNMI(state);
            this.nmiState = state;
        }
    }

    public void setIRQ(boolean state) {
        if (state ^ this.irqState) {
            this.pla.setIRQ(state);
            this.irqState = state;
        }
    }

    public boolean isCreatingSamples() {
        return false;
    }

    public void setSampler(SampleMixer sampler) {
        this.sampler = sampler;
    }

    public SampleMixer getSampler() {
        return this.sampler;
    }

    public void mixerStart() {
    }

    public void clock() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static enum CRTType {
        NORMAL(0),
        ACTION_REPLAY(1),
        KCS_POWER_CARTRIDGE(2),
        FINAL_CARTRIDGE_III(3),
        SIMONS_BASIC(4),
        OCEAN_TYPE_1(5),
        EXPERT_CARTRIDGE(6),
        FUN_PLAY__POWER_PLAY(7),
        SUPER_GAMES(8),
        ATOMIC_POWER(9),
        EPYX_FASTLOAD(10),
        WESTERMANN_LEARNING(11),
        REX_UTILITY(12),
        FINAL_CARTRIDGE_I(13),
        MAGIC_FORMEL(14),
        C64_GAME_SYSTEM__SYSTEM_3(15),
        WARPSPEED(16),
        DINAMIC(17),
        ZAXXON__SUPER_ZAXXON(18),
        MAGIC_DESK__DOMARK__HES_AUSTRALIA(19),
        SUPER_SNAPSHOT_5(20),
        COMAL_80(21),
        STRUCTURED_BASIC(22),
        ROSS(23),
        DELA_EP64(24),
        DELA_EP7X8(25),
        DELA_EP256(26),
        REX_EP256(27),
        MIKRO_ASSEMBLER(28),
        FINAL_PLUS(29),
        ACTION_REPLAY_4(30),
        STARDOS(31),
        EASYFLASH(32),
        GMOD2(60);

        private int magic;

        private CRTType(int magic) {
            this.magic = magic;
        }

        public static CRTType getType(byte[] header) {
            if (!new String(header, 0, 16, ISO88591).equals("C64 CARTRIDGE   ")) {
                throw new RuntimeException("File is not a .CRT file");
            }
            CRTType cart = CRTType.getType((header[22] & 0xFF) << 8 | header[23] & 0xFF);
            if (cart == null) {
                throw new RuntimeException("Cartridge magic value: " + ((header[22] & 0xFF) << 8 | header[23] & 0xFF) + " unsupported!");
            }
            return cart;
        }

        private static CRTType getType(int magic) {
            return Arrays.asList(CRTType.values()).stream().filter(crt -> crt.magic == magic).findFirst().orElse(null);
        }
    }
}

