/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.sidmapping;

import builder.jsidblaster.JSIDBlasterMapping;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.FileRequestPathServletParameters;
import sidplay.ini.IniConfig;

@WebServlet(name="SIDBlasterMappingServlet", displayName="SIDBlasterMappingServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/sidblaster-mapping/*"}, description="Get SIDBlaster SID mapping information")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class SIDBlasterMappingServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.SIDBlasterMappingServlet.MAX_SIDBLASTERMAPPING_IN_PARALLEL, new DefaultThreadFactory("/sidblastermapping"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.SIDBlasterMappingServlet.SIDBLASTERMAPPING_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block4: {
                    try {
                        SIDBlasterMappingServletParameters servletParameters = new SIDBlasterMappingServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        File file = servletParameters.fetchFile(SIDBlasterMappingServlet.this.configuration, SIDBlasterMappingServlet.this.directoryProperties, parser, SIDBlasterMappingServlet.this.hasAdminAccess(request));
                        if (file == null || servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        IEmulationSection emulationSection = servletParameters.emulationSection;
                        SidTune tune = SidTune.load(file);
                        Map<Integer, String> result = JSIDBlasterMapping.mapping(emulationSection, tune);
                        if (!this.isComplete()) {
                            SIDBlasterMappingServlet.this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, result);
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(SIDBlasterMappingServlet.this.getServletContext(), t, this.parentThread);
                        if (this.isComplete()) break block4;
                        response.setStatus(500);
                        SIDBlasterMappingServlet.this.setOutput(response, t);
                    }
                }
            }
        });
    }

    @Parameters(resourceBundle="server.restful.servlets.sidmapping.SIDBlasterMappingServletParameters")
    public static class SIDBlasterMappingServletParameters
    extends FileRequestPathServletParameters {
        @ParametersDelegate
        private IEmulationSection emulationSection = new IniConfig().getEmulationSection();
    }
}

